/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.client.rendering.purplespike;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.telepathicgrunt.the_bumblezone.client.BumblezoneClient;
import com.telepathicgrunt.the_bumblezone.entities.nonliving.PurpleSpikeEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;

public class PurpleSpikeModel<T extends PurpleSpikeEntity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"purple_spike"), "main");
    private final ModelPart topSpike;
    private final ModelPart bottomSpike;

    public PurpleSpikeModel(ModelPart root) {
        super(BumblezoneClient.ENTITY_TRANSPARENT_EMISSIVE_RENDER_TYPE);
        this.topSpike = root.getChild("topSpike");
        this.bottomSpike = root.getChild("bottomSpike");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition topSpike = partdefinition.addOrReplaceChild("topSpike", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition cube_r1 = topSpike.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(0, 0).addBox(-15.0f, 1.0f, -8.0f, 16.0f, 0.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)7.0f, (float)-7.0f, (float)-5.0f, (float)1.0472f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r2 = topSpike.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(0, 0).addBox(-8.0f, 1.0f, -15.0f, 16.0f, 0.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)-13.0f, (float)0.0f, (float)0.0f, (float)1.5708f, (float)-1.0472f));
        PartDefinition cube_r3 = topSpike.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(0, 0).addBox(-8.0f, 1.0f, -1.0f, 16.0f, 0.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)8.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)-1.5708f, (float)1.0472f));
        PartDefinition cube_r4 = topSpike.addOrReplaceChild("cube_r4", CubeListBuilder.create().texOffs(0, 0).addBox(-15.0f, 1.0f, -8.0f, 16.0f, 0.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)7.0f, (float)-6.0f, (float)3.0f, (float)2.0944f, (float)0.0f, (float)0.0f));
        PartDefinition bottomSpike = partdefinition.addOrReplaceChild("bottomSpike", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition cube_r5 = bottomSpike.addOrReplaceChild("cube_r5", CubeListBuilder.create().texOffs(0, 16).addBox(-8.0f, 1.0f, -15.0f, 16.0f, 0.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)-9.0f, (float)0.0f, (float)0.0f, (float)1.5708f, (float)-1.0472f));
        PartDefinition cube_r6 = bottomSpike.addOrReplaceChild("cube_r6", CubeListBuilder.create().texOffs(0, 16).addBox(-8.0f, 1.0f, -1.0f, 16.0f, 0.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)8.0f, (float)3.0f, (float)0.0f, (float)0.0f, (float)-1.5708f, (float)1.0472f));
        PartDefinition cube_r7 = bottomSpike.addOrReplaceChild("cube_r7", CubeListBuilder.create().texOffs(0, 16).addBox(-15.0f, 1.0f, -8.0f, 16.0f, 0.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)7.0f, (float)-2.0f, (float)3.0f, (float)2.0944f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r8 = bottomSpike.addOrReplaceChild("cube_r8", CubeListBuilder.create().texOffs(0, 16).addBox(-15.0f, 1.0f, -8.0f, 16.0f, 0.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)7.0f, (float)-3.0f, (float)-5.0f, (float)1.0472f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void setupAnim(T spike, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        boolean hasSpikeCharge = ((PurpleSpikeEntity)((Object)spike)).hasSpikeCharge();
        boolean hasSpike = ((PurpleSpikeEntity)((Object)spike)).hasSpike();
        this.topSpike.visible = !hasSpikeCharge && hasSpike;
        this.bottomSpike.visible = hasSpikeCharge || hasSpike;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int packedColor) {
        this.topSpike.render(poseStack, vertexConsumer, packedLight, packedOverlay, packedColor);
        this.bottomSpike.render(poseStack, vertexConsumer, packedLight, packedOverlay, packedColor);
    }
}

