/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.configs.neoforge;

import com.telepathicgrunt.the_bumblezone.configs.BzGeneralConfigs;
import com.telepathicgrunt.the_bumblezone.entities.mobs.BeehemothEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.neoforged.neoforge.common.ModConfigSpec;

public class BzGeneralConfig {
    public static final ModConfigSpec GENERAL_SPEC;
    public static ModConfigSpec.BooleanValue bzHoneyFluidFromHoneyBottles;
    public static ModConfigSpec.DoubleValue variantBeeAfterWorldgenSpawnRate;
    public static ModConfigSpec.ConfigValue<List<? extends String>> variantBeeTypes;
    public static ModConfigSpec.DoubleValue beehemothSpeed;
    public static ModConfigSpec.BooleanValue beehemothFriendlyFire;
    public static ModConfigSpec.BooleanValue specialBeeSpawning;
    public static ModConfigSpec.BooleanValue beeLootInjection;
    public static ModConfigSpec.BooleanValue moddedBeeLootInjection;
    public static ModConfigSpec.BooleanValue glisteringHoneyBrewingRecipe;
    public static ModConfigSpec.BooleanValue beeStingerBrewingRecipe;
    public static ModConfigSpec.BooleanValue beeSoupBrewingRecipe;
    public static ModConfigSpec.IntValue nearbyBeesPerPlayerInBz;
    public static ModConfigSpec.BooleanValue dispensersDropGlassBottles;
    public static ModConfigSpec.IntValue broodBlocksBeeSpawnCapacity;
    public static ModConfigSpec.BooleanValue pileOfPollenHyperFireSpread;
    public static ModConfigSpec.BooleanValue superCandlesBurnsMobs;
    public static ModConfigSpec.IntValue neurotoxinMaxLevel;
    public static ModConfigSpec.IntValue paralyzedMaxTickDuration;
    public static ModConfigSpec.IntValue beeQueenBonusTradeRewardMultiplier;
    public static ModConfigSpec.IntValue beeQueenBonusTradeDurationInTicks;
    public static ModConfigSpec.IntValue beeQueenBonusTradeAmountTillSatified;
    public static ModConfigSpec.BooleanValue beeQueenSpecialDayTrades;
    public static ModConfigSpec.BooleanValue beeQueenRespawning;
    public static ModConfigSpec.BooleanValue beeQueenGroundPickup;
    public static ModConfigSpec.BooleanValue allowWanderingTraderMusicDiscsTrades;
    public static ModConfigSpec.BooleanValue crystallineFlowerConsumeItemEntities;
    public static ModConfigSpec.BooleanValue crystallineFlowerConsumeExperienceOrbEntities;
    public static ModConfigSpec.BooleanValue crystallineFlowerConsumeItemUI;
    public static ModConfigSpec.BooleanValue crystallineFlowerConsumeExperienceUI;
    public static ModConfigSpec.IntValue crystallineFlowerEnchantingPowerAllowedPerTier;
    public static ModConfigSpec.IntValue crystallineFlowerExtraXpNeededForTiers;
    public static ModConfigSpec.IntValue crystallineFlowerExtraTierCost;
    public static ModConfigSpec.BooleanValue repeatableEssenceEvents;
    public static ModConfigSpec.BooleanValue blueArenaBubblesMechanic;
    public static ModConfigSpec.IntValue blueArenaTimeFrameInTicks;
    public static ModConfigSpec.IntValue greenArenaTimeFrameInTicks;
    public static ModConfigSpec.IntValue purpleArenaTimeFrameInTicks;
    public static ModConfigSpec.IntValue redArenaTimeFrameInTicks;
    public static ModConfigSpec.IntValue yellowArenaTimeFrameInTicks;
    public static ModConfigSpec.IntValue whiteArenaTimeFrameInTicks;
    public static ModConfigSpec.IntValue cosmicCrystalHealth;
    public static ModConfigSpec.IntValue ragingEssenceAbilityUse;
    public static ModConfigSpec.IntValue ragingEssenceCooldown;
    public static ModConfigSpec.ConfigValue<List<? extends Integer>> ragingEssenceStrengthLevels;
    public static ModConfigSpec.IntValue knowingEssenceAbilityUse;
    public static ModConfigSpec.IntValue knowingEssenceCooldown;
    public static ModConfigSpec.BooleanValue knowingEssenceStructureNameServer;
    public static ModConfigSpec.IntValue calmingEssenceAbilityUse;
    public static ModConfigSpec.IntValue calmingEssenceCooldown;
    public static ModConfigSpec.IntValue lifeEssenceAbilityUse;
    public static ModConfigSpec.IntValue lifeEssenceCooldown;
    public static ModConfigSpec.IntValue radianceEssenceAbilityUse;
    public static ModConfigSpec.IntValue radianceEssenceCooldown;
    public static ModConfigSpec.IntValue continuityEssenceCooldown;

    private static void setupConfig(ModConfigSpec.Builder builder) {
        builder.translation("the_bumblezone.configuration.bumblezonefluidoptions").push("Bumblezone Fluid Options");
        bzHoneyFluidFromHoneyBottles = builder.comment(new String[]{"----------------------------\n", " Whether extracting fluid from Honey Bottles will attempt to generate Bumblezone Honey Fluid. (Think extraction machines)\n"}).translation("the_bumblezone.configuration.bzhoneyfluidfromhoneybottles").define("bzHoneyFluidFromHoneyBottles", true);
        builder.pop();
        builder.translation("the_bumblezone.configuration.variantbeeoptions").push("Variant Bee Options");
        variantBeeAfterWorldgenSpawnRate = builder.comment(new String[]{" \n-----------------------------------------------------\n", " Rates for Variant Bees to spawn when doing normal mob spawning over time.", " Will not affect spawnrates of this mob from worldgen generating chunks.", " For the worldgen spawning rates, overriding the biome json with a datapack is required.\n"}).translation("the_bumblezone.config.variantbeeafterworldgenspawnrate").defineInRange("variantBeeAfterWorldgenSpawnRate", 0.05, 0.0, 1.0);
        variantBeeTypes = builder.comment(new String[]{"----------------------------\n", " What skin variations of Variant Bees can spawn! Add more bee textures to this folder `assets/the_bumblezone/textures/entity/bee_variants` and define the bee in this config!\n"}).translation("the_bumblezone.configuration.variantbeetypes").defineList("variantBeeTypes", Arrays.asList("redtail_bee", "green_bee", "blue_bee", "white_bee", "ukraine_bee", "trans_bee", "asexual_bee", "agender_bee", "aroace_bee", "aromantic_bee", "bisexual_bee", "pan_bee", "enby_bee", "reverse_bee", "neapolitan_bee", "rainbow_bee"), entry -> true);
        builder.pop();
        builder.translation("the_bumblezone.configuration.beehemothoptions").push("Beehemoth Options");
        beehemothSpeed = builder.comment(new String[]{"----------------------------\n", " Base speed for the Beehemoth when being rode by a player.\n"}).translation("the_bumblezone.configuration.beehemothspeed").defineInRange("beehemothSpeed", 0.95, 0.0, 100.0);
        beehemothFriendlyFire = builder.comment(new String[]{"----------------------------\n", " Allows tamed Beehemoths to take damage from owner.\n"}).translation("the_bumblezone.configuration.beehemothfriendlyfire").define("beehemothFriendlyFire", true);
        builder.pop();
        builder.translation("the_bumblezone.configuration.specialbeespawningoptions").push("Special Bee Spawning Options");
        specialBeeSpawning = builder.comment(new String[]{"----------------------------\n", " Whether Bumblezone will handle spawning vanilla bees near players in the Bumblezone to make it feel full of Bees.", " Bees too far will be despawned in Bumblezone unless the bee has a hive, is name tagged, or is set to persistent.\n"}).translation("the_bumblezone.configuration.specialbeespawning").define("specialBeeSpawning", true);
        nearbyBeesPerPlayerInBz = builder.comment(new String[]{"----------------------------\n", " If specialBeeSpawning is set to true, this config controls how many vanilla bees should be", " near each player in Bumblezone dimension. Higher numbers like 100 is insane lol. 25 is nice.\n"}).translation("the_bumblezone.configuration.nearbybeesperplayerinbz").defineInRange("nearbyBeesPerPlayerInBz", 25, 0, 1000);
        builder.pop();
        builder.translation("the_bumblezone.configuration.beelootinjectionoption").push("Bee Loot Injection Options");
        beeLootInjection = builder.comment(new String[]{"----------------------------\n", " Whether Bee Stingers should drop from adult Bees that die while still having their stinger.", " This pulls from this loot table for the drops: `the_bumblezone:entities/bee_stinger_drops`\n"}).translation("the_bumblezone.configuration.beelootinjection").define("beeLootInjection", true);
        moddedBeeLootInjection = builder.comment(new String[]{"----------------------------\n", " Whether Bee Stingers should drop from adult modded Bees that die while still having their stinger.", " This pulls from this loot table for the drops: `the_bumblezone:entities/bee_stinger_drops`\n"}).translation("the_bumblezone.configuration.moddedbeelootinjection").define("moddedBeeLootInjection", true);
        builder.pop();
        builder.translation("the_bumblezone.configuration.brewingrecipeoptions").push("Brewing Recipe Options");
        glisteringHoneyBrewingRecipe = builder.comment(new String[]{"----------------------------\n", " Whether Glistering Honey Crystals can be used to make Potions of Luck."}).translation("the_bumblezone.configuration.glisteringhoneybrewingrecipe").define("glisteringHoneyBrewingRecipe", true);
        beeStingerBrewingRecipe = builder.comment(new String[]{"----------------------------\n", " Whether Bee Stingers can be used to make Potions of Long Poison."}).translation("the_bumblezone.configuration.beestingerbrewingrecipe").define("beeStingerBrewingRecipe", true);
        beeSoupBrewingRecipe = builder.comment(new String[]{"----------------------------\n", " Whether Bee Soup can be used to make Potions of Neurotoxin."}).translation("the_bumblezone.configuration.beesoupbrewingrecipe").define("beeSoupBrewingRecipe", true);
        builder.pop();
        builder.translation("the_bumblezone.configuration.enchantmentsoptions").push("Enchantments Options");
        neurotoxinMaxLevel = builder.comment(new String[]{"----------------------------\n", " Maximum level that Neurotoxin enchantment's strength can be regardless of the enchantment's level.", " Note, changing this won't change enchantment's own max level. Just that this config set to 2 will make level 3 enchant behave like level 2.", " To change an enchantment's max level display, datapack replace data/the_bumblezone/enchantment/neurotoxin.json file.\n"}).translation("the_bumblezone.configuration.neurotoxinmaxlevel").defineInRange("neurotoxinMaxLevel", 2, 1, 255);
        paralyzedMaxTickDuration = builder.comment(new String[]{"----------------------------\n", " Sets maximum tick duration the Paralyzed effect can be on an entity. Actions that reapply Paralyzed can still reset the timer and keep entity stunned.\n"}).translation("the_bumblezone.configuration.paralyzedmaxtickduration").defineInRange("paralyzedMaxTickDuration", 600, 1, 1000000);
        builder.pop();
        builder.translation("the_bumblezone.configuration.beequeenoptions").push("Bee Queen Options");
        beeQueenBonusTradeRewardMultiplier = builder.comment(new String[]{"----------------------------\n", " Bonus Trades will multiply the normal trade's quantity by this amount!", " 0 or 1 set here disables Bonus Trades.\n"}).translation("the_bumblezone.configuration.beequeenbonustraderewardmultiplier").defineInRange("beeQueenBonusTradeRewardMultiplier", 3, 0, 256);
        beeQueenBonusTradeDurationInTicks = builder.comment(new String[]{"----------------------------\n", " How long in ticks that bonus Trades will last for before the Bee Queen asks for a new item.", " Setting this to 0 disables bonus Trades. Anything less than a minute (1200) will not broadcast request message to players.\n"}).translation("the_bumblezone.configuration.beequeenbonustradedurationinticks").defineInRange("beeQueenBonusTradeDurationInTicks", 24000, 0, 2000000);
        beeQueenBonusTradeAmountTillSatified = builder.comment(new String[]{"----------------------------\n", " How many boosted trades are allowed until the Bonus Trade is depleted.", " The queen will request a new item for Bonus Trades after some time to recharge.", " Setting this to 0 disables bonus Trades.\n"}).translation("the_bumblezone.configuration.beequeenbonustradeamounttillsatified").defineInRange("beeQueenBonusTradeAmountTillSatified", 24, 0, 1000000);
        beeQueenSpecialDayTrades = builder.comment(new String[]{"----------------------------\n", " Whether to allow special trades to activate during certain days of the year.\n"}).translation("the_bumblezone.configuration.beequeenspecialdaytrades").define("beeQueenSpecialDayTrades", true);
        beeQueenRespawning = builder.comment(new String[]{"----------------------------\n", " Allow Bee Queen to respawn in Throne Pillar when located with fresh Throne Honey Compass.\n"}).translation("the_bumblezone.configuration.beequeenrespawning").define("beeQueenRespawning", true);
        beeQueenGroundPickup = builder.comment(new String[]{"----------------------------\n", " Allow Bee Queen to pick up items off ground to do trading.\n"}).translation("the_bumblezone.configuration.beequeengroundpickup").define("beeQueenGroundPickup", true);
        builder.pop();
        builder.translation("the_bumblezone.configuration.crystallinefloweroptions").push("Crystalline Flower Options");
        crystallineFlowerConsumeItemEntities = builder.comment(new String[]{"----------------------------\n", " Whether the Crystalline Flower block will eat any item entity that touches the block's collision box in the world.\n"}).translation("the_bumblezone.configuration.crystallineflowerconsumeitementities").define("crystallineFlowerConsumeItemEntities", true);
        crystallineFlowerConsumeExperienceOrbEntities = builder.comment(new String[]{"----------------------------\n", " Whether the Crystalline Flower block will pull in and eat any experience orb that touches it in the world.\n"}).translation("the_bumblezone.configuration.crystallineflowerconsumeexperienceorbentities").define("crystallineFlowerConsumeExperienceOrbEntities", true);
        crystallineFlowerConsumeItemUI = builder.comment(new String[]{"----------------------------\n", " Whether the Crystalline Flower's GUI allows players to feed it items directly.\n"}).translation("the_bumblezone.configuration.crystallineflowerconsumeitemui").define("crystallineFlowerConsumeItemUI", true);
        crystallineFlowerConsumeExperienceUI = builder.comment(new String[]{"----------------------------\n", " Whether the Crystalline Flower's GUI allows players to feed it the player's experience.\n"}).translation("the_bumblezone.configuration.crystallineflowerconsumeexperienceui").define("crystallineFlowerConsumeExperienceUI", true);
        crystallineFlowerExtraXpNeededForTiers = builder.comment(new String[]{"----------------------------\n", " How much extra experience is required to reach the next tier for the Crystalline Flower.", " Remember, item consuming is also affected as items are converted to experience when the flower consumes it.\n"}).translation("the_bumblezone.configuration.crystallineflowerextraxpneededfortiers").defineInRange("crystallineFlowerExtraXpNeededForTiers", 0, -1000000, 1000000);
        crystallineFlowerExtraTierCost = builder.comment(new String[]{"----------------------------\n", " Increases or decreases the tier cost of all enchantments available by whatever value you set.", " The enchantment's final tier cost will be capped between 1 and 6.\n"}).translation("the_bumblezone.configuration.crystallineflowerextratiercost").defineInRange("crystallineFlowerExtraTierCost", 0, -5, 5);
        crystallineFlowerEnchantingPowerAllowedPerTier = builder.comment(new String[]{"----------------------------\n", " Controls how much \"enchanting power\" is used per tier to determine what enchantment shows up.", " Enchantments of higher levels or rarity requires more \"enchanting power\" before they show up in the UI.", " Think of this like how Enchanting Tables only shows stronger or rarer enchantments when you have more bookshelves.", " Except here, the flower's tier times this config value is used as the threshold to know what enchantment and level to show.\n"}).translation("the_bumblezone.configuration.crystallineflowerenchantingpowerallowedpertier").defineInRange("crystallineFlowerEnchantingPowerAllowedPerTier", 8, 0, 1000);
        builder.pop();
        builder.translation("the_bumblezone.configuration.generalmechanicsoptions").push("General Mechanics Options");
        dispensersDropGlassBottles = builder.comment(new String[]{"----------------------------\n", " Should Dispensers always drop the Glass Bottle when using specific", " bottle items on certain The Bumblezone blocks?", " ", " Example: Using Honey Bottle to feed Honeycomb Brood Blocks will grow the larva and", " drop the Glass Bottle instead of putting it back into Dispenser if this is set to true.\n"}).translation("the_bumblezone.configuration.dispensersdropglassbottles").define("dispensersDropGlassBottles", false);
        broodBlocksBeeSpawnCapacity = builder.comment(new String[]{"----------------------------\n", " Brood Blocks will automatically spawn bees until the number of active bees is the value below.", " Set this higher to allow Brood Blocks to spawn more bees in a smaller area or set it to 0 to turn", " off automatic Brood Block bee spawning.\n"}).translation("the_bumblezone.configuration.broodblocksbeespawncapacity").defineInRange("broodBlocksBeeSpawnCapacity", 40, 0, 1000);
        pileOfPollenHyperFireSpread = builder.comment(new String[]{"----------------------------\n", " Whether Pile of Pollen should spread fire super quickly to burn away huge swathes of pollen.\n"}).translation("the_bumblezone.configuration.pileofpollenhyperfirespread").define("pileOfPollenHyperFireSpread", false);
        superCandlesBurnsMobs = builder.comment(new String[]{"----------------------------\n", " Allows lit Super Candles/Potion Candle to burn living entities in its flame.\n"}).translation("the_bumblezone.configuration.supercandlesburnsmobs").define("superCandlesBurnsMobs", true);
        builder.pop();
        builder.translation("the_bumblezone.configuration.musicdiscsoptions").push("Music Disc Options");
        allowWanderingTraderMusicDiscsTrades = builder.comment(new String[]{"----------------------------\n", " Whether Wandering Traders can have a rare trade for Bumblezone Music Discs.\n"}).translation("the_bumblezone.configuration.allowwanderingtradermusicdiscstrades").define("allowWanderingTraderMusicDiscsTrades", true);
        builder.pop();
        builder.translation("the_bumblezone.configuration.essenceoptions").push("Essence Item And Events Options");
        repeatableEssenceEvents = builder.comment(new String[]{"----------------------------\n", " Whether the Essence events in Sempiternal Sanctums can be repeated after beating it once.\n"}).translation("the_bumblezone.configuration.repeatableessenceevents").define("repeatableEssenceEvents", true);
        blueArenaBubblesMechanic = builder.comment(new String[]{"----------------------------\n", " Whether the Blue Arena in Sempiternal Sanctum has the moving bubble block mechanic.\n"}).translation("the_bumblezone.configuration.bluearenabubblesmechanic").define("blueArenaBubblesMechanic", true);
        blueArenaTimeFrameInTicks = builder.comment(new String[]{"----------------------------\n", " How long in ticks the Blue Arena in Sempiternal Sanctum will last.\n"}).translation("the_bumblezone.configuration.bluearenatimeframeinticks").defineInRange("blueArenaTimeFrameInTicks", 10800, 1, 1000000);
        greenArenaTimeFrameInTicks = builder.comment(new String[]{"----------------------------\n", " How long in ticks the Green Arena in Sempiternal Sanctum will last.\n"}).translation("the_bumblezone.configuration.greenarenatimeframeinticks").defineInRange("greenArenaTimeFrameInTicks", 6000, 1, 1000000);
        purpleArenaTimeFrameInTicks = builder.comment(new String[]{"----------------------------\n", " How long in ticks the Purple Arena in Sempiternal Sanctum will last.\n"}).translation("the_bumblezone.configuration.purplearenatimeframeinticks").defineInRange("purpleArenaTimeFrameInTicks", 5020, 1, 1000000);
        redArenaTimeFrameInTicks = builder.comment(new String[]{"----------------------------\n", " How long in ticks the Red Arena in Sempiternal Sanctum will last.\n"}).translation("the_bumblezone.configuration.redarenatimeframeinticks").defineInRange("redArenaTimeFrameInTicks", 10800, 1, 1000000);
        yellowArenaTimeFrameInTicks = builder.comment(new String[]{"----------------------------\n", " How long in ticks the Yellow Arena in Sempiternal Sanctum will last.\n"}).translation("the_bumblezone.configuration.yellowarenatimeframeinticks").defineInRange("yellowArenaTimeFrameInTicks", 6000, 1, 1000000);
        whiteArenaTimeFrameInTicks = builder.comment(new String[]{"----------------------------\n", " How long in ticks the White Arena in Sempiternal Sanctum will last.\n"}).translation("the_bumblezone.configuration.whitearenatimeframeinticks").defineInRange("whiteArenaTimeFrameInTicks", 10000, 1, 1000000);
        cosmicCrystalHealth = builder.comment(new String[]{"----------------------------\n", " How much max health Cosmic Crystal entity has. (For Continuity Essence event in White Sempiternal Sanctum)\n"}).translation("the_bumblezone.configuration.cosmiccrystalhealth").defineInRange("cosmicCrystalHealth", 60, 1, 1000000);
        ragingEssenceAbilityUse = builder.comment(new String[]{"----------------------------\n", " How much ability use this item has before depleted.\n"}).translation("the_bumblezone.configuration.ragingessenceabilityuse").defineInRange("ragingEssenceAbilityUse", 28, 0, 1000000);
        ragingEssenceCooldown = builder.comment(new String[]{"----------------------------\n", " How long the cooldown is in ticks before recharged for this item.\n"}).translation("the_bumblezone.configuration.ragingessencecooldown").defineInRange("ragingEssenceCooldown", 36000, 0, 1000000);
        ragingEssenceStrengthLevels = builder.comment(new String[]{"----------------------------\n", " How many rage levels there are and what level Strength effect each rage level gives.", " The list is in order of the effect levels that the player will get as they make highlighted kills.", " Adding or removing numbers will change the maximum number of rage tiers too.\n"}).translation("the_bumblezone.configuration.ragingessencestrengthlevels").defineList("ragingEssenceStrengthLevels", Arrays.asList(1, 2, 3, 5, 8, 14, 20), entry -> {
            if (entry instanceof Integer) {
                Integer integer = (Integer)entry;
                return integer > 0;
            }
            return false;
        });
        knowingEssenceAbilityUse = builder.comment(new String[]{"----------------------------\n", " How much ability use (per second) this item has before depleted.\n"}).translation("the_bumblezone.configuration.knowingessenceabilityuse").defineInRange("knowingEssenceAbilityUse", 1200, 0, 1000000);
        knowingEssenceCooldown = builder.comment(new String[]{"----------------------------\n", " How long the cooldown is in ticks before recharged for this item.\n"}).translation("the_bumblezone.configuration.knowingessencecooldown").defineInRange("knowingEssenceCooldown", 18000, 0, 1000000);
        knowingEssenceStructureNameServer = builder.comment(new String[]{"----------------------------\n", " Whether clients should be allowed to see names of structures they are in with this item.\n"}).translation("the_bumblezone.configuration.knowingEssenceStructureNameServer").define("knowingEssenceStructureNameServer", true);
        calmingEssenceAbilityUse = builder.comment(new String[]{"----------------------------\n", " How much ability use (per second) this item has before depleted.\n"}).translation("the_bumblezone.configuration.calmingessenceabilityuse").defineInRange("calmingEssenceAbilityUse", 600, 0, 1000000);
        calmingEssenceCooldown = builder.comment(new String[]{"----------------------------\n", " How long the cooldown is in ticks before recharged for this item.\n"}).translation("the_bumblezone.configuration.calmingessencecooldown").defineInRange("calmingEssenceCooldown", 12000, 0, 1000000);
        lifeEssenceAbilityUse = builder.comment(new String[]{"----------------------------\n", " How much ability use this item has before depleted.\n"}).translation("the_bumblezone.configuration.lifeessenceabilityuse").defineInRange("lifeEssenceAbilityUse", 1000, 0, 1000000);
        lifeEssenceCooldown = builder.comment(new String[]{"----------------------------\n", " How long the cooldown is in ticks before recharged for this item.\n"}).translation("the_bumblezone.configuration.lifeessencecooldown").defineInRange("lifeEssenceCooldown", 12000, 0, 1000000);
        radianceEssenceAbilityUse = builder.comment(new String[]{"----------------------------\n", " How much ability use (per 25 ticks) this item has before depleted.\n"}).translation("the_bumblezone.configuration.radianceessenceabilityuse").defineInRange("radianceEssenceAbilityUse", 4800, 0, 1000000);
        radianceEssenceCooldown = builder.comment(new String[]{"----------------------------\n", " How long the cooldown is in ticks before recharged for this item.\n"}).translation("the_bumblezone.configuration.radianceessencecooldown").defineInRange("radianceEssenceCooldown", 12000, 0, 1000000);
        continuityEssenceCooldown = builder.comment(new String[]{"----------------------------\n", " How long the cooldown is in ticks before recharged for this item.\n"}).translation("the_bumblezone.configuration.continuityessencecooldown").defineInRange("continuityEssenceCooldown", 48000, 0, 1000000);
        builder.pop();
    }

    public static void copyToCommon() {
        if (BzGeneralConfigs.beehemothSpeed != (Double)beehemothSpeed.get()) {
            BzGeneralConfigs.beehemothSpeed = (Double)beehemothSpeed.get();
            BeehemothEntity.beehemothSpeedConfigChanged = true;
        }
        BzGeneralConfigs.variantBeeAfterWorldgenSpawnRate = (Double)variantBeeAfterWorldgenSpawnRate.get();
        BzGeneralConfigs.variantBeeTypes = new ArrayList<String>((Collection)variantBeeTypes.get());
        BzGeneralConfigs.beehemothFriendlyFire = (Boolean)beehemothFriendlyFire.get();
        BzGeneralConfigs.specialBeeSpawning = (Boolean)specialBeeSpawning.get();
        BzGeneralConfigs.beeLootInjection = (Boolean)beeLootInjection.get();
        BzGeneralConfigs.moddedBeeLootInjection = (Boolean)moddedBeeLootInjection.get();
        BzGeneralConfigs.glisteringHoneyBrewingRecipe = (Boolean)glisteringHoneyBrewingRecipe.get();
        BzGeneralConfigs.beeStingerBrewingRecipe = (Boolean)beeStingerBrewingRecipe.get();
        BzGeneralConfigs.nearbyBeesPerPlayerInBz = (Integer)nearbyBeesPerPlayerInBz.get();
        BzGeneralConfigs.dispensersDropGlassBottles = (Boolean)dispensersDropGlassBottles.get();
        BzGeneralConfigs.broodBlocksBeeSpawnCapacity = (Integer)broodBlocksBeeSpawnCapacity.get();
        BzGeneralConfigs.pileOfPollenHyperFireSpread = (Boolean)pileOfPollenHyperFireSpread.get();
        BzGeneralConfigs.superCandlesBurnsMobs = (Boolean)superCandlesBurnsMobs.get();
        BzGeneralConfigs.neurotoxinMaxLevel = (Integer)neurotoxinMaxLevel.get();
        BzGeneralConfigs.paralyzedMaxTickDuration = (Integer)paralyzedMaxTickDuration.get();
        BzGeneralConfigs.beeQueenBonusTradeRewardMultiplier = (Integer)beeQueenBonusTradeRewardMultiplier.get();
        BzGeneralConfigs.beeQueenBonusTradeDurationInTicks = (Integer)beeQueenBonusTradeDurationInTicks.get();
        BzGeneralConfigs.beeQueenBonusTradeAmountTillSatified = (Integer)beeQueenBonusTradeAmountTillSatified.get();
        BzGeneralConfigs.beeQueenSpecialDayTrades = (Boolean)beeQueenSpecialDayTrades.get();
        BzGeneralConfigs.beeQueenRespawning = (Boolean)beeQueenRespawning.get();
        BzGeneralConfigs.beeQueenGroundPickup = (Boolean)beeQueenGroundPickup.get();
        BzGeneralConfigs.allowWanderingTraderMusicDiscsTrades = (Boolean)allowWanderingTraderMusicDiscsTrades.get();
        BzGeneralConfigs.crystallineFlowerConsumeItemEntities = (Boolean)crystallineFlowerConsumeItemEntities.get();
        BzGeneralConfigs.crystallineFlowerConsumeExperienceOrbEntities = (Boolean)crystallineFlowerConsumeExperienceOrbEntities.get();
        BzGeneralConfigs.crystallineFlowerConsumeItemUI = (Boolean)crystallineFlowerConsumeItemUI.get();
        BzGeneralConfigs.crystallineFlowerConsumeExperienceUI = (Boolean)crystallineFlowerConsumeExperienceUI.get();
        BzGeneralConfigs.crystallineFlowerEnchantingPowerAllowedPerTier = (Integer)crystallineFlowerEnchantingPowerAllowedPerTier.get();
        BzGeneralConfigs.crystallineFlowerExtraXpNeededForTiers = (Integer)crystallineFlowerExtraXpNeededForTiers.get();
        BzGeneralConfigs.crystallineFlowerExtraTierCost = (Integer)crystallineFlowerExtraTierCost.get();
        BzGeneralConfigs.repeatableEssenceEvents = (Boolean)repeatableEssenceEvents.get();
        BzGeneralConfigs.blueArenaBubblesMechanic = (Boolean)blueArenaBubblesMechanic.get();
        BzGeneralConfigs.blueArenaTimeFrameInTicks = (Integer)blueArenaTimeFrameInTicks.get();
        BzGeneralConfigs.greenArenaTimeFrameInTicks = (Integer)greenArenaTimeFrameInTicks.get();
        BzGeneralConfigs.purpleArenaTimeFrameInTicks = (Integer)purpleArenaTimeFrameInTicks.get();
        BzGeneralConfigs.redArenaTimeFrameInTicks = (Integer)redArenaTimeFrameInTicks.get();
        BzGeneralConfigs.yellowArenaTimeFrameInTicks = (Integer)yellowArenaTimeFrameInTicks.get();
        BzGeneralConfigs.whiteArenaTimeFrameInTicks = (Integer)whiteArenaTimeFrameInTicks.get();
        BzGeneralConfigs.cosmicCrystalHealth = (Integer)cosmicCrystalHealth.get();
        BzGeneralConfigs.ragingEssenceAbilityUse = (Integer)ragingEssenceAbilityUse.get();
        BzGeneralConfigs.ragingEssenceCooldown = (Integer)ragingEssenceCooldown.get();
        BzGeneralConfigs.ragingEssenceStrengthLevels = ((List)ragingEssenceStrengthLevels.get()).stream().mapToInt(i -> i).toArray();
        BzGeneralConfigs.knowingEssenceAbilityUse = (Integer)knowingEssenceAbilityUse.get();
        BzGeneralConfigs.knowingEssenceCooldown = (Integer)knowingEssenceCooldown.get();
        BzGeneralConfigs.knowingEssenceStructureNameServer = (Boolean)knowingEssenceStructureNameServer.get();
        BzGeneralConfigs.calmingEssenceAbilityUse = (Integer)calmingEssenceAbilityUse.get();
        BzGeneralConfigs.calmingEssenceCooldown = (Integer)calmingEssenceCooldown.get();
        BzGeneralConfigs.lifeEssenceAbilityUse = (Integer)lifeEssenceAbilityUse.get();
        BzGeneralConfigs.lifeEssenceCooldown = (Integer)lifeEssenceCooldown.get();
        BzGeneralConfigs.radianceEssenceAbilityUse = (Integer)radianceEssenceAbilityUse.get();
        BzGeneralConfigs.radianceEssenceCooldown = (Integer)radianceEssenceCooldown.get();
        BzGeneralConfigs.continuityEssenceCooldown = (Integer)continuityEssenceCooldown.get();
    }

    static {
        ModConfigSpec.Builder configBuilder = new ModConfigSpec.Builder();
        BzGeneralConfig.setupConfig(configBuilder);
        GENERAL_SPEC = configBuilder.build();
    }
}

