/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.effects;

import com.telepathicgrunt.the_bumblezone.blocks.HoneycombBrood;
import com.telepathicgrunt.the_bumblezone.configs.BzBeeAggressionConfigs;
import com.telepathicgrunt.the_bumblezone.configs.BzGeneralConfigs;
import com.telepathicgrunt.the_bumblezone.entities.BeeAggression;
import com.telepathicgrunt.the_bumblezone.entities.BeeDedicatedSpawning;
import com.telepathicgrunt.the_bumblezone.events.entity.BzEntityDeathEvent;
import com.telepathicgrunt.the_bumblezone.modinit.BzEffects;
import com.telepathicgrunt.the_bumblezone.modinit.BzPOI;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import com.telepathicgrunt.the_bumblezone.utils.PlatformHooks;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;

public class WrathOfTheHiveEffect
extends MobEffect {
    public static final int NEARBY_WRATH_EFFECT_RADIUS = 8;
    private static final TargetingConditions SEE_THROUGH_WALLS = TargetingConditions.forCombat().ignoreLineOfSight().ignoreInvisibilityTesting();
    private static final TargetingConditions LINE_OF_SIGHT = TargetingConditions.forCombat();
    public static boolean ACTIVE_WRATH = false;

    public WrathOfTheHiveEffect(MobEffectCategory type, int potionColor) {
        super(type, potionColor);
    }

    public boolean isInstantenous() {
        return true;
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return duration >= 1;
    }

    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        Mob mob;
        Level world = entity.level();
        if (entity instanceof Mob && (mob = (Mob)entity).isNoAi()) {
            return false;
        }
        if (entity.isDeadOrDying()) {
            WrathOfTheHiveEffect.calmTheBees(world, entity);
            return false;
        }
        if (entity instanceof Player && world.getDifficulty() == Difficulty.PEACEFUL) {
            return false;
        }
        if ((entity.level().getGameTime() + entity.getUUID().getLeastSignificantBits()) % 20L != 0L) {
            return true;
        }
        if (entity.hasEffect(BzEffects.PROTECTION_OF_THE_HIVE.holder())) {
            return false;
        }
        if (amplifier >= 2) {
            ServerLevel serverLevel;
            WrathOfTheHiveEffect.unBEElievablyHighAggression(world, entity);
            if (world instanceof ServerLevel && (float)BeeDedicatedSpawning.getNearbyActiveEntitiesInDimension(serverLevel = (ServerLevel)world, entity.blockPosition()) < (float)BzGeneralConfigs.broodBlocksBeeSpawnCapacity * 3.0f && entity.getRandom().nextFloat() <= 0.09f) {
                BlockPos spawnBlockPos = GeneralUtils.getRandomBlockposWithinRange(entity, 30, 10);
                if (!world.getBlockState(spawnBlockPos).isAir()) {
                    return false;
                }
                Bee bee = (Bee)EntityType.BEE.create(world);
                if (bee == null) {
                    return true;
                }
                bee.finalizeSpawn((ServerLevelAccessor)serverLevel, serverLevel.getCurrentDifficultyAt(spawnBlockPos), MobSpawnType.TRIGGERED, null);
                bee.absMoveTo((double)spawnBlockPos.getX() + 0.5, (double)spawnBlockPos.getY() + 0.5, (double)spawnBlockPos.getZ() + 0.5, entity.getRandom().nextFloat() * 360.0f, 0.0f);
                PlatformHooks.finalizeSpawn((Mob)bee, (ServerLevelAccessor)world, null, MobSpawnType.TRIGGERED);
                world.addFreshEntity((Entity)bee);
            }
        } else {
            WrathOfTheHiveEffect.mediumAggression(world, entity);
        }
        if (!world.isClientSide() && entity instanceof Player) {
            PoiManager poiManager = ((ServerLevel)world).getPoiManager();
            List poiInRange = poiManager.getInSquare(pointOfInterestType -> pointOfInterestType.value() == BzPOI.BROOD_BLOCK_POI.get(), entity.blockPosition(), 8, PoiManager.Occupancy.ANY).collect(Collectors.toList());
            float chanceOfGrowth = 0.15f;
            if (poiInRange.size() != 0) {
                for (int index = poiInRange.size() - 1; index >= 0; --index) {
                    BlockState state;
                    if (!(entity.getRandom().nextFloat() < chanceOfGrowth)) continue;
                    PoiRecord poi = (PoiRecord)poiInRange.remove(index);
                    int yDiff = Math.abs(entity.blockPosition().getY() - poi.getPos().getY());
                    if (yDiff > 8 || !((state = world.getBlockState(poi.getPos())).getBlock() instanceof HoneycombBrood)) continue;
                    state.tick((ServerLevel)world, poi.getPos(), entity.getRandom());
                }
            }
        }
        return true;
    }

    public static void mediumAggression(Level world, LivingEntity livingEntity) {
        WrathOfTheHiveEffect.setAggression(world, livingEntity, Bee.class, LINE_OF_SIGHT, Math.max(BzBeeAggressionConfigs.speedBoostLevel - 1, 1), Math.max((BzBeeAggressionConfigs.absorptionBoostLevel - 1) / 2, 1), Math.max((BzBeeAggressionConfigs.strengthBoostLevel - 1) / 3, 1));
    }

    public static void unBEElievablyHighAggression(Level world, LivingEntity livingEntity) {
        WrathOfTheHiveEffect.setAggression(world, livingEntity, Bee.class, SEE_THROUGH_WALLS, BzBeeAggressionConfigs.speedBoostLevel - 1, BzBeeAggressionConfigs.absorptionBoostLevel - 1, BzBeeAggressionConfigs.strengthBoostLevel - 1);
    }

    private static void setAggression(Level world, LivingEntity livingEntity, Class<? extends Mob> entityToFind, TargetingConditions sightMode, int speed, int absorption, int strength) {
        if (BeeAggression.isBeelikeEntity((Entity)livingEntity)) {
            return;
        }
        boolean isHiding = false;
        MobEffectInstance hiddenEffect = livingEntity.getEffect(BzEffects.HIDDEN.holder());
        if (hiddenEffect != null && hiddenEffect.getAmplifier() >= 1) {
            isHiding = true;
        }
        sightMode.range((double)BzBeeAggressionConfigs.aggressionTriggerRadius);
        List beeList = world.getNearbyEntities(entityToFind, sightMode, livingEntity, livingEntity.getBoundingBox().inflate((double)BzBeeAggressionConfigs.aggressionTriggerRadius));
        for (Mob bee : beeList) {
            MobEffectInstance effect;
            if (bee.isNoAi()) continue;
            if (isHiding) {
                bee.setTarget(null);
                continue;
            }
            if (bee instanceof NeutralMob) {
                ((NeutralMob)bee).setRemainingPersistentAngerTime(40);
                if (bee.getTarget() == null || bee.getTarget().isDeadOrDying()) {
                    ((NeutralMob)bee).setPersistentAngerTarget(livingEntity.getUUID());
                }
            }
            if (bee.getTarget() == null || bee.getTarget().isDeadOrDying()) {
                bee.setTarget(livingEntity);
            }
            if ((effect = livingEntity.getEffect(BzEffects.WRATH_OF_THE_HIVE.holder())) == null) continue;
            int leftoverDuration = effect.getDuration();
            MobEffectInstance currentEffect = bee.getEffect(MobEffects.MOVEMENT_SPEED);
            if (currentEffect == null || currentEffect.getDuration() < leftoverDuration) {
                bee.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, leftoverDuration, speed, false, false));
            }
            if ((currentEffect = bee.getEffect(MobEffects.ABSORPTION)) == null || currentEffect.getDuration() < leftoverDuration) {
                bee.addEffect(new MobEffectInstance(MobEffects.ABSORPTION, leftoverDuration, absorption, false, false));
            }
            if ((currentEffect = bee.getEffect(MobEffects.DAMAGE_BOOST)) != null && currentEffect.getDuration() >= leftoverDuration) continue;
            bee.addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, leftoverDuration, strength, false, true));
        }
    }

    public static void calmTheBees(Level world, LivingEntity livingEntity) {
        SEE_THROUGH_WALLS.range((double)BzBeeAggressionConfigs.aggressionTriggerRadius * 1.2);
        List beeList = world.getNearbyEntities(Bee.class, SEE_THROUGH_WALLS, livingEntity, livingEntity.getBoundingBox().inflate((double)BzBeeAggressionConfigs.aggressionTriggerRadius * 1.2));
        for (Bee bee : beeList) {
            if (bee.isNoAi() || bee.getTarget() != livingEntity) continue;
            bee.setTarget(null);
            bee.setAggressive(false);
            bee.setRemainingPersistentAngerTime(0);
            bee.removeEffect(MobEffects.DAMAGE_BOOST);
            bee.removeEffect(MobEffects.MOVEMENT_SPEED);
            bee.removeEffect(MobEffects.ABSORPTION);
        }
    }

    public static void effectRemoval(LivingEntity entity, MobEffectInstance mobEffectInstance) {
        Mob mob;
        if (entity.level().isClientSide || mobEffectInstance.getEffect() != BzEffects.WRATH_OF_THE_HIVE.holder()) {
            return;
        }
        if (entity instanceof Mob && (mob = (Mob)entity).isNoAi()) {
            return;
        }
        if (BeeAggression.doesBeesHateEntity((Entity)entity)) {
            entity.addEffect(new MobEffectInstance(BzEffects.WRATH_OF_THE_HIVE.holder(), BzBeeAggressionConfigs.howLongWrathOfTheHiveLasts, 1, false, true));
        }
    }

    public static void onLivingEntityDeath(BzEntityDeathEvent event) {
        LivingEntity livingEntity = event.entity();
        if (livingEntity != null) {
            WrathOfTheHiveEffect.calmTheBees(livingEntity.level(), livingEntity);
        }
    }
}

