/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.modcompat;

import com.telepathicgrunt.the_bumblezone.modcompat.ModChecker;
import com.telepathicgrunt.the_bumblezone.modcompat.ModCompat;
import java.util.EnumSet;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class CreateJetpackCompat
implements ModCompat {
    private static Item JETPACK;

    public CreateJetpackCompat() {
        JETPACK = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"create_jetpack", (String)"jetpack"));
        ModChecker.createJetpackPresent = true;
    }

    @Override
    public EnumSet<ModCompat.Type> compatTypes() {
        return EnumSet.of(ModCompat.Type.HEAVY_AIR_RESTRICTED);
    }

    @Override
    public void restrictFlight(Entity entity, double extraGravity) {
        Player player;
        ItemStack jetpack;
        if (JETPACK != null && entity instanceof Player && (jetpack = (player = (Player)entity).getItemBySlot(EquipmentSlot.CHEST)).is(JETPACK)) {
            if (!player.getCooldowns().isOnCooldown(jetpack.getItem()) && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.displayClientMessage((Component)Component.translatable((String)"system.the_bumblezone.denied_jetpack").withStyle(ChatFormatting.ITALIC).withStyle(ChatFormatting.RED), true);
            }
            player.getCooldowns().addCooldown(jetpack.getItem(), 40);
        }
    }
}

