/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.packets;

import com.teamresourceful.resourcefullib.common.network.Packet;
import com.teamresourceful.resourcefullib.common.network.base.ClientboundPacketType;
import com.teamresourceful.resourcefullib.common.network.base.PacketType;
import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.entities.datamanagers.queentrades.QueensTradeManager;
import com.telepathicgrunt.the_bumblezone.events.lifecycle.BzDatapackSyncEvent;
import com.telepathicgrunt.the_bumblezone.modcompat.recipecategories.RandomizeTradeRowInput;
import com.telepathicgrunt.the_bumblezone.packets.MessageHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;

public record QueenRandomizerTradesSyncPacket(List<RandomizeTradeRowInput> recipeViewerRandomizerTrades) implements Packet<QueenRandomizerTradesSyncPacket>
{
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"queen_randomize_trades_sync_packet");
    public static final ClientboundPacketType<QueenRandomizerTradesSyncPacket> TYPE = new Handler();

    public static void sendToClient(BzDatapackSyncEvent event) {
        MessageHandler.DEFAULT_CHANNEL.sendToPlayer((Packet)new QueenRandomizerTradesSyncPacket(QueensTradeManager.QUEENS_TRADE_MANAGER.recipeViewerRandomizerTrades), event.player());
    }

    public PacketType<QueenRandomizerTradesSyncPacket> type() {
        return TYPE;
    }

    public static class Handler
    implements ClientboundPacketType<QueenRandomizerTradesSyncPacket> {
        public QueenRandomizerTradesSyncPacket decode(RegistryFriendlyByteBuf buf) {
            ArrayList<RandomizeTradeRowInput> parsedData = new ArrayList<RandomizeTradeRowInput>();
            CompoundTag data = (CompoundTag)buf.readNbt(NbtAccounter.create((long)0x6400000L));
            if (data == null) {
                Bumblezone.LOGGER.error("Queen Randomizer Trade packet is empty??? Wtf???");
                return new QueenRandomizerTradesSyncPacket(parsedData);
            }
            ListTag tagList = data.getList("randomize_trades", 8);
            for (int i = 0; i < tagList.size(); ++i) {
                TagKey tagKey = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.tryParse((String)tagList.getString(i)));
                RandomizeTradeRowInput wantEntry = new RandomizeTradeRowInput(Optional.of(tagKey));
                parsedData.add(wantEntry);
            }
            return new QueenRandomizerTradesSyncPacket(parsedData);
        }

        public void encode(QueenRandomizerTradesSyncPacket pkt, RegistryFriendlyByteBuf buf) {
            CompoundTag data = new CompoundTag();
            ListTag listTag = new ListTag();
            for (int i = 0; i < pkt.recipeViewerRandomizerTrades().size(); ++i) {
                listTag.add((Object)StringTag.valueOf((String)pkt.recipeViewerRandomizerTrades().get(i).tagKey().get().location().toString()));
            }
            data.put("randomize_trades", (Tag)listTag);
            buf.writeNbt((Tag)data);
        }

        public Runnable handle(QueenRandomizerTradesSyncPacket pkt) {
            return () -> {
                QueensTradeManager.QUEENS_TRADE_MANAGER.recipeViewerRandomizerTrades = pkt.recipeViewerRandomizerTrades();
            };
        }

        public Class<QueenRandomizerTradesSyncPacket> type() {
            return QueenRandomizerTradesSyncPacket.class;
        }

        public ResourceLocation id() {
            return ID;
        }
    }
}

