/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.utils;

import com.telepathicgrunt.the_bumblezone.configs.BzGeneralConfigs;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;

public class EnchantmentUtils {
    public static long getPlayerXP(Player player) {
        return (long)((float)EnchantmentUtils.getExperienceForLevel(player.experienceLevel) + player.experienceProgress * (float)player.getXpNeededForNextLevel());
    }

    private static long sum(int n, int a0, int d) {
        return (long)n * (2L * (long)a0 + ((long)n - 1L) * (long)d) / 2L;
    }

    public static long getExperienceForLevel(int level) {
        if (level == 0) {
            return 0L;
        }
        if (level <= 15) {
            return EnchantmentUtils.sum(level, 7, 2);
        }
        if (level <= 30) {
            return 315L + EnchantmentUtils.sum(level - 15, 37, 5);
        }
        return 1395L + EnchantmentUtils.sum(level - 30, 112, 9);
    }

    public static Map<ResourceLocation, EnchantmentInstance> allAllowedEnchantsWithoutMaxLimit(Level level, int enchantmentLevel, ItemStack itemStack, int xpTier) {
        HashMap<ResourceLocation, EnchantmentInstance> map = new HashMap<ResourceLocation, EnchantmentInstance>();
        boolean bookFlag = itemStack.is(Items.BOOK) || itemStack.is(Items.ENCHANTED_BOOK);
        boolean allowTreasure = xpTier == 7;
        Map<Enchantment, Integer> existingEnchantments = EnchantmentUtils.getEnchantmentsOnBook(itemStack);
        Registry enchantmentRegistry = (Registry)level.registryAccess().registry(Registries.ENCHANTMENT).get();
        enchantmentRegistry.holders().forEach(enchantment -> {
            boolean forceAllowed = enchantment.is(BzTags.FORCED_ALLOWED_CRYSTALLINE_FLOWER_ENCHANTMENTS);
            boolean disallowed = enchantment.is(BzTags.DISALLOWED_CRYSTALLINE_FLOWER_ENCHANTMENTS);
            if (!forceAllowed && disallowed) {
                return;
            }
            int minLevelAllowed = ((Enchantment)enchantment.value()).getMinLevel();
            if (existingEnchantments.containsKey(enchantment.value())) {
                minLevelAllowed = Math.max(minLevelAllowed, (Integer)existingEnchantments.get(enchantment.value()) + 1);
            }
            if ((enchantment.is(EnchantmentTags.IN_ENCHANTING_TABLE) || enchantment.is(EnchantmentTags.ON_RANDOM_LOOT) || enchantment.is(EnchantmentTags.NON_TREASURE)) && (!enchantment.is(EnchantmentTags.TREASURE) || allowTreasure) && (bookFlag || ((Enchantment)enchantment.value()).canEnchant(itemStack) && ((Enchantment)enchantment.value()).isPrimaryItem(itemStack)) || forceAllowed) {
                for (int i = ((Enchantment)enchantment.value()).getMaxLevel(); i > minLevelAllowed - 1; --i) {
                    EnchantmentInstance enchantmentInstance;
                    if (!forceAllowed && enchantmentLevel < ((Enchantment)enchantment.value()).getMinCost(i) || xpTier <= EnchantmentUtils.getEnchantmentTierCost(enchantmentInstance = new EnchantmentInstance((Holder)enchantment, xpTier <= 2 ? 1 : i))) continue;
                    map.put(enchantmentRegistry.getKey((Object)((Enchantment)enchantmentInstance.enchantment.value())), enchantmentInstance);
                    break;
                }
            }
        });
        return map;
    }

    public static Map<Enchantment, Integer> getEnchantmentsOnBook(ItemStack itemStack) {
        Set enchantments = ((ItemEnchantments)itemStack.getOrDefault(DataComponents.STORED_ENCHANTMENTS, (Object)ItemEnchantments.EMPTY)).entrySet();
        Object2IntOpenHashMap existingEnchants = new Object2IntOpenHashMap();
        for (Object2IntMap.Entry entry : enchantments) {
            existingEnchants.put((Enchantment)((Holder)entry.getKey()).value(), entry.getIntValue());
        }
        return existingEnchants;
    }

    public static int getEnchantmentTierCost(EnchantmentInstance enchantmentInstance) {
        return EnchantmentUtils.getEnchantmentTierCost(enchantmentInstance.level, ((Enchantment)enchantmentInstance.enchantment.value()).getMinCost(((ResourceKey)enchantmentInstance.enchantment.unwrapKey().get()).location().getNamespace().equals("minecraft") ? Math.max(enchantmentInstance.level, 2) : enchantmentInstance.level), enchantmentInstance.enchantment.is(EnchantmentTags.TREASURE), enchantmentInstance.enchantment.is(EnchantmentTags.CURSE));
    }

    public static int getEnchantmentTierCost(int level, int minCost, boolean isTreasureOnly, boolean isCurse) {
        int cost = 0;
        cost += minCost / 10;
        cost += (int)((float)level / 1.5f);
        if (isTreasureOnly) {
            cost += 2;
        }
        if (isCurse) {
            cost -= 3;
        }
        return Math.max(1, Math.min(6, cost += BzGeneralConfigs.crystallineFlowerExtraTierCost));
    }

    public static Holder<Enchantment> getEnchantmentHolder(ResourceLocation enchantmentRL, Level level) {
        return ((Registry)level.registryAccess().registry(Registries.ENCHANTMENT).get()).getHolder(enchantmentRL).orElse(null);
    }

    public static Holder<Enchantment> getEnchantmentHolder(ResourceKey<Enchantment> enchantmentRL, Level level) {
        return ((Registry)level.registryAccess().registry(Registries.ENCHANTMENT).get()).getHolder(enchantmentRL).orElse(null);
    }
}

