/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.worldgen.features;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.the_bumblezone.utils.OpenSimplex2F;
import com.telepathicgrunt.the_bumblezone.utils.UnsafeBulkSectionAccess;
import com.telepathicgrunt.the_bumblezone.worldgen.features.configs.BiomeBasedLayerConfig;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BrushableBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class LayeredBlockSurface
extends Feature<BiomeBasedLayerConfig> {
    protected long seed;
    protected static OpenSimplex2F noiseGen;

    public void setSeed(long seed) {
        if (this.seed != seed || noiseGen == null) {
            noiseGen = new OpenSimplex2F(seed);
            this.seed = seed;
        }
    }

    public LayeredBlockSurface(Codec<BiomeBasedLayerConfig> configFactory) {
        super(configFactory);
    }

    public boolean place(FeaturePlaceContext<BiomeBasedLayerConfig> context) {
        this.setSeed(context.level().getSeed());
        BlockPos.MutableBlockPos mutableBlockPos = context.origin().mutable();
        BlockPos.MutableBlockPos mutableBlockPosForChunk = new BlockPos.MutableBlockPos();
        ChunkPos chunkPos = new ChunkPos((BlockPos)mutableBlockPos);
        Biome targetBiome = (Biome)((Registry)context.level().registryAccess().registry(Registries.BIOME).get()).get(((BiomeBasedLayerConfig)context.config()).biomeRL);
        UnsafeBulkSectionAccess bulkSectionAccess = new UnsafeBulkSectionAccess((LevelAccessor)context.level());
        for (int xOffset = -1; xOffset <= 1; ++xOffset) {
            for (int zOffset = -1; zOffset <= 1; ++zOffset) {
                ChunkPos currentChunkPos = new ChunkPos(chunkPos.x + xOffset, chunkPos.z + zOffset);
                mutableBlockPosForChunk.set((Vec3i)currentChunkPos.getWorldPosition());
                ChunkAccess cachedChunk = context.level().getChunk(currentChunkPos.getWorldPosition());
                if (xOffset != 0 && zOffset != 0 && cachedChunk.getSection(0).getNoiseBiome(0, 0, 0).value() == targetBiome) continue;
                this.fillChunkWithPollen(context, bulkSectionAccess, cachedChunk, currentChunkPos.getWorldPosition(), targetBiome);
            }
        }
        return true;
    }

    private void fillChunkWithPollen(FeaturePlaceContext<BiomeBasedLayerConfig> context, UnsafeBulkSectionAccess bulkSectionAccess, ChunkAccess cachedChunk, BlockPos startPos, Biome targetBiome) {
        int configHeight = ((BiomeBasedLayerConfig)context.config()).height;
        BlockState configBlockState = ((BiomeBasedLayerConfig)context.config()).state;
        Optional<BlockState> configRareBlockState = ((BiomeBasedLayerConfig)context.config()).rareState;
        BlockPos.MutableBlockPos mutable = context.origin().mutable();
        BlockState previousBlockState = Blocks.AIR.defaultBlockState();
        RandomSource random = context.random();
        int maxY = context.chunkGenerator().getGenDepth() + context.chunkGenerator().getMinY() - 1;
        for (int xOffset = 0; xOffset <= 15; ++xOffset) {
            for (int zOffset = 0; zOffset <= 15; ++zOffset) {
                mutable.set(startPos.getX() + xOffset, maxY, startPos.getZ() + zOffset);
                if (targetBiome != context.level().getBiomeManager().getNoiseBiomeAtPosition((BlockPos)mutable).value()) continue;
                while (mutable.getY() >= context.chunkGenerator().getSeaLevel() - 1) {
                    BlockState currentBlockState = bulkSectionAccess.getBlockState((BlockPos)mutable);
                    if (!(currentBlockState.isAir() || !currentBlockState.getFluidState().isEmpty() || previousBlockState.getBlock() != Blocks.AIR || currentBlockState.is(configBlockState.getBlock()) || configRareBlockState.isPresent() && currentBlockState.is(configRareBlockState.get().getBlock()))) {
                        if (!currentBlockState.isFaceSturdy((BlockGetter)context.level(), (BlockPos)mutable, Direction.UP)) {
                            previousBlockState = currentBlockState;
                            mutable.move(Direction.DOWN);
                            continue;
                        }
                        for (int height = 1; height <= configHeight && mutable.getY() + height < maxY; ++height) {
                            BlockEntity blockEntity;
                            BlockState finalBlockState;
                            BlockPos finalPosition = mutable.above(height);
                            if (height > 1 && !(finalBlockState = bulkSectionAccess.getBlockState(finalPosition)).isAir()) break;
                            int layerHeight = 8;
                            if (height == configHeight) {
                                float xzScale = 0.035f;
                                float yScale = 0.015f;
                                double noiseVal = Math.abs(noiseGen.noise3_Classic((float)mutable.getX() * xzScale, (float)mutable.getY() * yScale + (float)height, (float)mutable.getZ() * xzScale));
                                layerHeight = Math.max(1, (int)((noiseVal * 0.63 + 0.4) * 8.0));
                                layerHeight = Math.min(8, layerHeight);
                            }
                            BlockState blockToPlace = configBlockState;
                            if ((height < configHeight || layerHeight == 8) && configRareBlockState.isPresent() && random.nextFloat() < ((BiomeBasedLayerConfig)context.config()).rareStateChance) {
                                blockToPlace = configRareBlockState.get();
                            }
                            if (blockToPlace.hasProperty((Property)BlockStateProperties.LAYERS)) {
                                bulkSectionAccess.setBlockState(finalPosition, (BlockState)blockToPlace.setValue((Property)BlockStateProperties.LAYERS, (Comparable)Integer.valueOf(layerHeight)), false);
                                context.level().scheduleTick(finalPosition, blockToPlace.getBlock(), 0);
                                continue;
                            }
                            bulkSectionAccess.setBlockState(finalPosition, blockToPlace, false);
                            if (!blockToPlace.hasBlockEntity() || (blockEntity = ((EntityBlock)blockToPlace.getBlock()).newBlockEntity(finalPosition, blockToPlace)) == null) continue;
                            if (blockEntity instanceof BrushableBlockEntity) {
                                BrushableBlockEntity brushableBlock = (BrushableBlockEntity)blockEntity;
                                if (((BiomeBasedLayerConfig)context.config()).suspiciousBlockLoot.isPresent()) {
                                    brushableBlock.setLootTable(ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)((BiomeBasedLayerConfig)context.config()).suspiciousBlockLoot.get()), random.nextLong());
                                }
                            }
                            cachedChunk.setBlockEntity(blockEntity);
                        }
                    }
                    previousBlockState = currentBlockState;
                    mutable.move(Direction.DOWN);
                }
            }
        }
    }
}

