/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.worldgen.features.decorators;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.the_bumblezone.modinit.BzPlacements;
import java.util.ArrayList;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import net.minecraft.world.level.levelgen.placement.RepeatingPlacement;

public class Random3DClusterPlacement
extends RepeatingPlacement {
    private final IntProvider count;
    private final Optional<IntProvider> range;
    private final boolean allowUnderwater;
    public static final MapCodec<Random3DClusterPlacement> CODEC = RecordCodecBuilder.mapCodec(configInstance -> configInstance.group((App)IntProvider.codec((int)0, (int)100000).fieldOf("count").forGetter(nbtFeatureConfig -> nbtFeatureConfig.count), (App)IntProvider.codec((int)0, (int)256).optionalFieldOf("height_range").forGetter(nbtFeatureConfig -> nbtFeatureConfig.range), (App)Codec.BOOL.fieldOf("allow_underwater").forGetter(nbtFeatureConfig -> nbtFeatureConfig.allowUnderwater)).apply((Applicative)configInstance, Random3DClusterPlacement::new));

    private Random3DClusterPlacement(IntProvider count, Optional<IntProvider> range, boolean allowUnderwater) {
        this.count = count;
        this.range = range;
        this.allowUnderwater = allowUnderwater;
    }

    public PlacementModifierType<?> type() {
        return (PlacementModifierType)BzPlacements.RANDOM_3D_CLUSTER_PLACEMENT.get();
    }

    protected int count(RandomSource random, BlockPos blockPos) {
        return this.count.sample(random);
    }

    public Stream<BlockPos> getPositions(PlacementContext placementContext, RandomSource random, BlockPos blockPos) {
        ArrayList<BlockPos> blockPosList = new ArrayList<BlockPos>();
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (int chunkNum = 0; chunkNum <= this.count(random, blockPos); ++chunkNum) {
            int attempts;
            for (attempts = 0; attempts < 8; ++attempts) {
                mutableBlockPos.set(blockPos.getX(), 0, blockPos.getZ()).move(random.nextInt(4) + 8, this.range.map(intProvider -> intProvider.sample(random)).orElseGet(() -> random.nextInt(253) + 1).intValue(), random.nextInt(4) + 8);
                BlockState state = placementContext.getBlockState((BlockPos)mutableBlockPos);
                if (!state.isAir() && (!this.allowUnderwater || state.getFluidState().is(FluidTags.WATER))) continue;
                mutableBlockPos.set(blockPos.getX(), mutableBlockPos.getY(), blockPos.getZ());
                break;
            }
            if (attempts == 8) continue;
            int maxRadius = 8;
            for (int x = 0; x <= maxRadius; ++x) {
                for (int z = 0; z <= maxRadius; ++z) {
                    for (int y = 0; y <= maxRadius; ++y) {
                        float manhattenDistance = Math.abs(x) + Math.abs(y) + Math.abs(z);
                        if (!(manhattenDistance <= 12.0f) || !(random.nextFloat() <= ((float)maxRadius - manhattenDistance / 1.5f) / (float)maxRadius)) continue;
                        blockPosList.add(mutableBlockPos.offset(x + 8, y + 8, z + 8));
                    }
                }
            }
        }
        return blockPosList.stream();
    }
}

