/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.worldgen.features.decorators;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.the_bumblezone.modinit.BzPlacements;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;

public class RoofedDimensionSurfacePlacement
extends PlacementModifier {
    private final int minHeight;
    private final int maxWaterDepth;
    public static final MapCodec<RoofedDimensionSurfacePlacement> CODEC = RecordCodecBuilder.mapCodec(configInstance -> configInstance.group((App)Codec.INT.fieldOf("min_height").orElse((Object)0).forGetter(nbtFeatureConfig -> nbtFeatureConfig.minHeight), (App)Codec.INT.fieldOf("max_water_depth").orElse((Object)0).forGetter(nbtFeatureConfig -> nbtFeatureConfig.maxWaterDepth)).apply((Applicative)configInstance, RoofedDimensionSurfacePlacement::new));

    private RoofedDimensionSurfacePlacement(int minHeight, int maxWaterDepth) {
        this.minHeight = minHeight;
        this.maxWaterDepth = maxWaterDepth;
    }

    public PlacementModifierType<?> type() {
        return (PlacementModifierType)BzPlacements.ROOFED_DIMENSION_SURFACE_PLACEMENT.get();
    }

    public Stream<BlockPos> getPositions(PlacementContext placementContext, RandomSource random, BlockPos blockPos) {
        int maxY = placementContext.generator().getGenDepth();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos().set(blockPos.getX(), this.minHeight, blockPos.getZ());
        while (mutable.getY() < maxY) {
            BlockState state = placementContext.getBlockState((BlockPos)mutable);
            if (state.isAir()) {
                return Stream.of(mutable.immutable());
            }
            if (!state.getFluidState().isEmpty()) {
                BlockPos currentPos = mutable.immutable();
                mutable.move(Direction.UP);
                int currentFluidDepth = 1;
                if (currentFluidDepth > this.maxWaterDepth) {
                    return Stream.of(new BlockPos[0]);
                }
                while (mutable.getY() < maxY) {
                    BlockState secondState = placementContext.getBlockState((BlockPos)mutable);
                    if (secondState.isAir()) {
                        return Stream.of(currentPos);
                    }
                    if (secondState.getFluidState().isEmpty()) break;
                    mutable.move(Direction.UP);
                    if (++currentFluidDepth <= this.maxWaterDepth) continue;
                    return Stream.of(new BlockPos[0]);
                }
            }
            mutable.move(Direction.UP);
        }
        return Stream.of(new BlockPos[0]);
    }
}

