/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.worldgen.processors;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.the_bumblezone.modinit.BzProcessors;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class PillarProcessor
extends StructureProcessor {
    private static final ResourceLocation EMPTY_RL = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"empty");
    public static final MapCodec<PillarProcessor> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.mapPair((MapCodec)BlockState.CODEC.fieldOf("trigger"), (MapCodec)BlockState.CODEC.fieldOf("replacement")).codec().listOf().xmap(list -> list.stream().collect(Collectors.toMap(Pair::getFirst, Pair::getSecond)), map -> map.entrySet().stream().map(entry -> Pair.of((Object)((BlockState)entry.getKey()), (Object)((BlockState)entry.getValue()))).collect(Collectors.toList())).fieldOf("pillar_trigger_and_replacements").forGetter(processor -> processor.pillarTriggerAndReplacementBlocks), (App)ResourceLocation.CODEC.optionalFieldOf("pillar_processor_list", (Object)EMPTY_RL).forGetter(processor -> processor.processorList), (App)Direction.CODEC.optionalFieldOf("direction", (Object)Direction.DOWN).forGetter(processor -> processor.direction), (App)IntProvider.codec((int)0, (int)1000).optionalFieldOf("pillar_length").forGetter(config -> config.pillarLength), (App)Codec.BOOL.optionalFieldOf("forced_placement", (Object)false).forGetter(config -> config.forcePlacement)).apply((Applicative)instance, instance.stable(PillarProcessor::new)));
    public final Map<BlockState, BlockState> pillarTriggerAndReplacementBlocks;
    public final ResourceLocation processorList;
    public final Direction direction;
    public final Optional<IntProvider> pillarLength;
    public final boolean forcePlacement;

    private PillarProcessor(Map<BlockState, BlockState> pillarTriggerAndReplacementBlocks, ResourceLocation processorList, Direction direction, Optional<IntProvider> pillarLength, boolean forcePlacement) {
        this.pillarTriggerAndReplacementBlocks = pillarTriggerAndReplacementBlocks;
        this.processorList = processorList;
        this.direction = direction;
        this.pillarLength = pillarLength;
        this.forcePlacement = forcePlacement;
    }

    public StructureTemplate.StructureBlockInfo processBlock(LevelReader levelReader, BlockPos templateOffset, BlockPos worldOffset, StructureTemplate.StructureBlockInfo structureBlockInfoLocal, StructureTemplate.StructureBlockInfo structureBlockInfoWorld, StructurePlaceSettings settings) {
        if (GeneralUtils.isOutsideStructureAllowedBounds(settings, structureBlockInfoWorld.pos())) {
            return structureBlockInfoWorld;
        }
        BlockState blockState = structureBlockInfoWorld.state();
        if (this.pillarTriggerAndReplacementBlocks.containsKey(blockState)) {
            WorldGenRegion worldGenRegion;
            BlockPos worldPos = structureBlockInfoWorld.pos();
            RandomSource random = RandomSource.create();
            random.setSeed(worldPos.asLong());
            boolean isNotInWorldgen = levelReader instanceof ServerLevel;
            BlockState replacementState = this.pillarTriggerAndReplacementBlocks.get(blockState);
            BlockPos.MutableBlockPos currentPos = new BlockPos.MutableBlockPos().set((Vec3i)worldPos);
            StructureProcessorList structureProcessorList = null;
            if (this.processorList != null && !this.processorList.equals((Object)EMPTY_RL)) {
                structureProcessorList = (StructureProcessorList)levelReader.registryAccess().registryOrThrow(Registries.PROCESSOR_LIST).get(this.processorList);
            }
            if (levelReader instanceof WorldGenRegion && !(worldGenRegion = (WorldGenRegion)levelReader).getCenter().equals((Object)new ChunkPos((BlockPos)currentPos))) {
                return replacementState == null || replacementState.is(Blocks.STRUCTURE_VOID) ? null : new StructureTemplate.StructureBlockInfo(worldPos, replacementState, null);
            }
            int pillarHeight = this.pillarLength.map(intProvider -> intProvider.sample(random)).orElse(1000);
            int terrainY = Integer.MIN_VALUE;
            if (this.direction == Direction.DOWN && !this.forcePlacement && (terrainY = GeneralUtils.getFirstLandYFromPos(levelReader, worldPos)) <= levelReader.getMinBuildHeight() && pillarHeight + 2 >= worldPos.getY() - levelReader.getMinBuildHeight()) {
                return replacementState == null || replacementState.is(Blocks.STRUCTURE_VOID) ? null : new StructureTemplate.StructureBlockInfo(worldPos, replacementState, null);
            }
            boolean isVertical = this.direction.getAxis() == Direction.Axis.Y;
            ChunkAccess currentChunk = levelReader.getChunk(worldPos);
            BlockState currentBlock = currentChunk.getBlockState(worldPos.below());
            while ((this.forcePlacement || !currentBlock.canOcclude() && !currentBlock.hasBlockEntity() || currentBlock.is(BlockTags.REPLACEABLE)) && (this.forcePlacement || currentPos.getY() >= terrainY) && !levelReader.isOutsideBuildHeight(currentPos.getY()) && currentPos.closerThan((Vec3i)worldPos, (double)pillarHeight)) {
                StructureTemplate.StructureBlockInfo newPillarState1 = new StructureTemplate.StructureBlockInfo(currentPos.subtract((Vec3i)worldPos).offset((Vec3i)templateOffset), replacementState, null);
                StructureTemplate.StructureBlockInfo newPillarState2 = new StructureTemplate.StructureBlockInfo(currentPos.immutable(), replacementState, null);
                if (structureProcessorList != null) {
                    for (StructureProcessor processor : structureProcessorList.list()) {
                        if (newPillarState2 == null) break;
                        newPillarState2 = processor.processBlock(levelReader, newPillarState1.pos(), newPillarState2.pos(), newPillarState1, newPillarState2, settings);
                    }
                }
                if (newPillarState2 != null) {
                    BlockState newState = newPillarState2.state().rotate(settings.getRotation());
                    if (isNotInWorldgen) {
                        ((ServerLevel)levelReader).setBlock((BlockPos)currentPos, newState, 3);
                    } else if (isVertical) {
                        currentChunk.setBlockState((BlockPos)currentPos, newState, false);
                    } else {
                        levelReader.getChunk((BlockPos)currentPos).setBlockState((BlockPos)currentPos, newState, false);
                    }
                }
                currentPos.move(this.direction);
                currentBlock = levelReader.getBlockState((BlockPos)currentPos);
            }
            return replacementState == null || replacementState.is(Blocks.STRUCTURE_VOID) ? null : new StructureTemplate.StructureBlockInfo(worldPos, replacementState, null);
        }
        return structureBlockInfoWorld;
    }

    protected StructureProcessorType<?> getType() {
        return (StructureProcessorType)BzProcessors.PILLAR_PROCESSOR.get();
    }
}

