/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.client.particles;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.particles.SimpleParticleType;

public class PollenPuffParticle
extends TextureSheetParticle {
    private PollenPuffParticle(ClientLevel clientWorld, double xPos, double yPos, double zPos, double xSpeed, double ySpeed, double zSpeed, TextureAtlasSprite sprite) {
        super(clientWorld, xPos, yPos, zPos);
        this.xd += xSpeed;
        this.yd += ySpeed;
        this.zd += zSpeed;
        this.setSize(0.1f, 0.1f);
        this.gravity = -5.0E-4f * (this.random.nextFloat() * 0.5f + 0.5f);
        this.quadSize *= this.random.nextFloat() * 0.5f + 0.63f;
        this.age = 90 + this.random.nextInt(90);
        this.hasPhysics = false;
        this.sprite = sprite;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        this.preMoveUpdate();
        if (!this.removed) {
            this.yd -= (double)this.gravity;
            this.move(this.xd, this.yd, this.zd);
            this.xd *= (double)0.98f;
            this.yd *= (double)0.98f;
            this.zd *= (double)0.98f;
        }
    }

    protected void preMoveUpdate() {
        if (this.age-- <= 0) {
            this.remove();
        }
    }

    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Factory(SpriteSet sprite) {
            this.sprites = sprite;
        }

        public Particle createParticle(SimpleParticleType particleType, ClientLevel clientWorld, double xPos, double yPos, double zPos, double xSpeed, double ySpeed, double zSpeed) {
            return new PollenPuffParticle(clientWorld, xPos, yPos, zPos, xSpeed, ySpeed, zSpeed, this.sprites.get(clientWorld.random));
        }
    }
}

