/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.client.rendering.cosmiccrystal;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.telepathicgrunt.the_bumblezone.client.rendering.cosmiccrystal.CosmicCrystalAnimation;
import com.telepathicgrunt.the_bumblezone.entities.living.CosmicCrystalEntity;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class CosmicCrystalModel
extends HierarchicalModel<CosmicCrystalEntity> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"cosmic_crystal"), "main");
    private final ModelPart root;
    private final ModelPart body;
    private final ModelPart spikes;
    private final ModelPart charging;

    public CosmicCrystalModel(ModelPart root) {
        super(RenderType::entityTranslucent);
        this.root = root;
        this.body = root.getChild("body");
        this.spikes = root.getChild("laser").getChild("spikes");
        this.charging = root.getChild("laser").getChild("charging");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)-0.15f));
        PartDefinition bottom = body.addOrReplaceChild("bottom", CubeListBuilder.create(), PartPose.offset((float)-0.5f, (float)-5.0f, (float)-0.75f));
        PartDefinition insideB = bottom.addOrReplaceChild("insideB", CubeListBuilder.create(), PartPose.offset((float)0.6207f, (float)1.4229f, (float)0.783f));
        PartDefinition insideBottom_r1 = insideB.addOrReplaceChild("insideBottom_r1", CubeListBuilder.create().texOffs(18, 38).addBox(-3.0f, -3.0f, -3.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(-1.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-1.1074f, (float)-0.4245f, (float)0.6825f));
        PartDefinition outsideB = bottom.addOrReplaceChild("outsideB", CubeListBuilder.create(), PartPose.offset((float)0.4954f, (float)1.2721f, (float)0.9316f));
        PartDefinition outsideBottom_r1 = outsideB.addOrReplaceChild("outsideBottom_r1", CubeListBuilder.create().texOffs(24, 8).addBox(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-1.1074f, (float)-0.4245f, (float)0.6825f));
        PartDefinition top = body.addOrReplaceChild("top", CubeListBuilder.create(), PartPose.offset((float)-0.5f, (float)-29.0f, (float)-0.75f));
        PartDefinition insideT = top.addOrReplaceChild("insideT", CubeListBuilder.create(), PartPose.offset((float)0.6207f, (float)1.4229f, (float)0.783f));
        PartDefinition insideTop_r1 = insideT.addOrReplaceChild("insideTop_r1", CubeListBuilder.create().texOffs(26, 26).addBox(-3.0f, -3.0f, -3.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(-1.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-1.1074f, (float)-0.4245f, (float)0.6825f));
        PartDefinition outsideT = top.addOrReplaceChild("outsideT", CubeListBuilder.create(), PartPose.offset((float)0.4954f, (float)1.2721f, (float)0.9316f));
        PartDefinition outsideTop_r1 = outsideT.addOrReplaceChild("outsideTop_r1", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-1.1074f, (float)-0.4245f, (float)0.6825f));
        PartDefinition middle = body.addOrReplaceChild("middle", CubeListBuilder.create(), PartPose.offset((float)-0.5f, (float)-17.0f, (float)-0.75f));
        PartDefinition insideM = middle.addOrReplaceChild("insideM", CubeListBuilder.create(), PartPose.offset((float)0.6207f, (float)1.4229f, (float)0.533f));
        PartDefinition insideMiddle_r1 = insideM.addOrReplaceChild("insideMiddle_r1", CubeListBuilder.create().texOffs(0, 32).addBox(-3.0f, -3.0f, -3.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(1.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-1.1074f, (float)-0.4245f, (float)0.6825f));
        PartDefinition outsideM = middle.addOrReplaceChild("outsideM", CubeListBuilder.create(), PartPose.offset((float)0.4954f, (float)1.2721f, (float)0.9316f));
        PartDefinition outsideMiddle_r1 = outsideM.addOrReplaceChild("outsideMiddle_r1", CubeListBuilder.create().texOffs(0, 16).addBox(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(3.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-1.1074f, (float)-0.4245f, (float)0.6825f));
        PartDefinition laser = partdefinition.addOrReplaceChild("laser", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition spikes = laser.addOrReplaceChild("spikes", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition spike4_r1 = spikes.addOrReplaceChild("spike4_r1", CubeListBuilder.create().texOffs(30, 58).addBox(-5.0f, 1.0f, -2.0f, 4.0f, 0.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-1.5708f, (float)1.0472f, (float)-1.5708f));
        PartDefinition spike3_r1 = spikes.addOrReplaceChild("spike3_r1", CubeListBuilder.create().texOffs(30, 58).addBox(-5.0f, 1.0f, -2.0f, 4.0f, 0.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)3.1416f, (float)0.0f, (float)-2.618f));
        PartDefinition spike2_r1 = spikes.addOrReplaceChild("spike2_r1", CubeListBuilder.create().texOffs(30, 58).addBox(-5.0f, 1.0f, -2.0f, 4.0f, 0.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)1.5708f, (float)-1.0472f, (float)-1.5708f));
        PartDefinition spike1_r1 = spikes.addOrReplaceChild("spike1_r1", CubeListBuilder.create().texOffs(30, 58).addBox(-5.0f, 1.0f, -2.0f, 4.0f, 0.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.5236f));
        PartDefinition charging = laser.addOrReplaceChild("charging", CubeListBuilder.create().texOffs(-10, 50).addBox(-5.0f, 3.0f, -5.0f, 10.0f, 0.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-1.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(CosmicCrystalEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.body.visible = true;
        this.body.getAllParts().forEach(ModelPart::resetPose);
        boolean isLaserState = CosmicCrystalEntity.isLaserState(entity.getCosmicCrystalState());
        if (isLaserState && entity.isLaserFiring()) {
            float pulse;
            this.spikes.visible = true;
            this.charging.visible = false;
            this.spikes.getAllParts().forEach(ModelPart::resetPose);
            this.spikes.xScale = pulse = Math.abs(Mth.sin((float)((float)(entity.currentStateTimeTick % 360 * 6) * ((float)Math.PI / 180)))) + 1.5f;
            this.spikes.zScale = pulse;
        } else if (isLaserState && entity.currentStateTimeTick > entity.getLaserStartDelay()) {
            float chargeTime;
            this.spikes.visible = false;
            this.charging.visible = true;
            this.charging.getAllParts().forEach(ModelPart::resetPose);
            float durationToFiring = entity.getLaserFireStartTime() - entity.getLaserStartDelay();
            this.charging.xScale = chargeTime = (1.0f - (float)(entity.currentStateTimeTick - entity.getLaserStartDelay()) / durationToFiring) * 3.0f;
            this.charging.zScale = chargeTime;
        } else {
            this.charging.visible = false;
            this.spikes.visible = false;
        }
        this.animate(entity.idleAnimationState, CosmicCrystalAnimation.MODEL_IDLE, ageInTicks);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int packedColor) {
        this.root.render(poseStack, vertexConsumer, packedLight, packedOverlay, packedColor);
    }

    public ModelPart root() {
        return this.root;
    }
}

