/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.commands.NonOpCommands;
import com.telepathicgrunt.the_bumblezone.events.lifecycle.BzRegisterCommandsEvent;
import com.telepathicgrunt.the_bumblezone.items.essence.EssenceOfTheBees;
import com.telepathicgrunt.the_bumblezone.modcompat.BumblezoneAPI;
import com.telepathicgrunt.the_bumblezone.modinit.BzDimension;
import com.telepathicgrunt.the_bumblezone.modules.PlayerDataHandler;
import com.telepathicgrunt.the_bumblezone.modules.base.ModuleHelper;
import com.telepathicgrunt.the_bumblezone.modules.registry.ModuleRegistry;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceKeyArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class OpCommands {
    private static final ResourceKey<Registry<Registry<?>>> ROOT_REGISTRY_KEY = ResourceKey.createRegistryKey((ResourceLocation)ResourceLocation.withDefaultNamespace((String)"root"));
    private static MinecraftServer currentMinecraftServer = null;
    private static Set<String> cachedSuggestion = new HashSet<String>();

    public static void createCommand(BzRegisterCommandsEvent commandEvent) {
        CommandDispatcher<CommandSourceStack> commandDispatcher = commandEvent.dispatcher();
        CommandBuildContext buildContext = commandEvent.context();
        String commandTeleportString = "bumblezone_teleport";
        String commandWriteString = "bumblezone_modify_data";
        String commandReadString = "bumblezone_read_data";
        String commandTagLogOutputString = "bumblezone_tag_log_output";
        String dataArg = "data_to_modify";
        String newDataArg = "new_value";
        String entityArg = "entity_to_check";
        LiteralCommandNode source = commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)commandWriteString).requires(permission -> permission.hasPermission(2))).then(Commands.argument((String)dataArg, (ArgumentType)StringArgumentType.string()).suggests((ctx, sb) -> SharedSuggestionProvider.suggest(OpCommands.methodBooleanWriteSuggestions((CommandContext<CommandSourceStack>)ctx), (SuggestionsBuilder)sb)).then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)newDataArg, (ArgumentType)BoolArgumentType.bool()).executes(cs -> {
            OpCommands.runBooleanSetMethod((CommandSourceStack)cs.getSource(), (String)cs.getArgument(dataArg, String.class), EntityArgument.getPlayers((CommandContext)cs, (String)"targets"), (Boolean)cs.getArgument(newDataArg, Boolean.TYPE), (CommandContext<CommandSourceStack>)cs);
            return 1;
        })))));
        commandDispatcher.register((LiteralArgumentBuilder)Commands.literal((String)commandWriteString).redirect((CommandNode)source));
        LiteralCommandNode source2 = commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)commandReadString).requires(permission -> permission.hasPermission(2))).then(Commands.argument((String)dataArg, (ArgumentType)StringArgumentType.string()).suggests((ctx, sb) -> SharedSuggestionProvider.suggest(OpCommands.methodReadSuggestions((CommandContext<CommandSourceStack>)ctx), (SuggestionsBuilder)sb)).then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).executes(cs -> {
            OpCommands.runReadMethod((CommandSourceStack)cs.getSource(), (String)cs.getArgument(dataArg, String.class), null, EntityArgument.getPlayers((CommandContext)cs, (String)"targets"), (CommandContext<CommandSourceStack>)cs);
            return 1;
        }))));
        commandDispatcher.register((LiteralArgumentBuilder)Commands.literal((String)commandReadString).redirect((CommandNode)source2));
        LiteralCommandNode source3 = commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)commandReadString).requires(permission -> permission.hasPermission(2))).then(Commands.literal((String)DATA_READ_ARG.QUEENS_DESIRED_KILLED_ENTITY_COUNTER.name().toLowerCase(Locale.ROOT)).then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)entityArg, (ArgumentType)StringArgumentType.string()).suggests((ctx, sb) -> SharedSuggestionProvider.suggest(OpCommands.killedSuggestions(EntityArgument.getPlayers((CommandContext)ctx, (String)"targets")), (SuggestionsBuilder)sb)).executes(cs -> {
            OpCommands.runReadMethod((CommandSourceStack)cs.getSource(), DATA_READ_ARG.QUEENS_DESIRED_KILLED_ENTITY_COUNTER.name(), (String)cs.getArgument(entityArg, String.class), EntityArgument.getPlayers((CommandContext)cs, (String)"targets"), (CommandContext<CommandSourceStack>)cs);
            return 1;
        })))));
        commandDispatcher.register((LiteralArgumentBuilder)Commands.literal((String)commandReadString).redirect((CommandNode)source3));
        LiteralCommandNode source4 = commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)commandTeleportString).requires(permission -> permission.hasPermission(2))).then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.entities()).executes(cs -> {
            OpCommands.runTeleportMethod((CommandSourceStack)cs.getSource(), EntityArgument.getEntities((CommandContext)cs, (String)"targets"), (CommandContext<CommandSourceStack>)cs);
            return 1;
        })));
        commandDispatcher.register((LiteralArgumentBuilder)Commands.literal((String)commandTeleportString).redirect((CommandNode)source4));
        LiteralCommandNode source5 = commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)commandTagLogOutputString).requires(permission -> permission.hasPermission(2))).then(Commands.argument((String)"registry", (ArgumentType)ResourceKeyArgument.key(ROOT_REGISTRY_KEY)).suggests((ctx, builder) -> SharedSuggestionProvider.suggestResource(((CommandSourceStack)ctx.getSource()).registryAccess().listRegistries().map(ResourceKey::location), (SuggestionsBuilder)builder)).then(Commands.argument((String)"tag", (ArgumentType)ResourceLocationArgument.id()).suggests(OpCommands.suggestFromRegistry(r -> r.getTagNames().map(TagKey::location)::iterator, "registry", ROOT_REGISTRY_KEY)).executes(cs -> {
            ResourceKey<Registry<?>> registryKey = OpCommands.getResourceKey((CommandContext<CommandSourceStack>)cs, "registry", ROOT_REGISTRY_KEY).orElseThrow();
            Registry registry = (Registry)((CommandSourceStack)cs.getSource()).getServer().registryAccess().registry(registryKey).get();
            ResourceLocation tagLocation = ResourceLocationArgument.getId((CommandContext)cs, (String)"tag");
            TagKey tagKey = TagKey.create((ResourceKey)((ResourceKey)OpCommands.cast(registryKey)), (ResourceLocation)tagLocation);
            Iterable tag = registry.getTagOrEmpty((TagKey)OpCommands.cast(tagKey));
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\nTAGSTART");
            stringBuilder.append("\n{");
            for (Holder holder : tag) {
                stringBuilder.append("\n\t\"");
                stringBuilder.append(((ResourceKey)holder.unwrapKey().get()).location());
                stringBuilder.append("\",");
            }
            stringBuilder.append("\n}\n");
            Bumblezone.LOGGER.info(stringBuilder.toString());
            return 1;
        }))));
        commandDispatcher.register((LiteralArgumentBuilder)Commands.literal((String)commandTagLogOutputString).redirect((CommandNode)source5));
    }

    private static Set<String> methodBooleanWriteSuggestions(CommandContext<CommandSourceStack> cs) {
        if (currentMinecraftServer == ((CommandSourceStack)cs.getSource()).getServer()) {
            return cachedSuggestion;
        }
        HashSet<String> suggestedStrings = new HashSet<String>();
        Arrays.stream(DATA_BOOLEAN_WRITE_ARG.values()).forEach(e -> suggestedStrings.add(e.name().toLowerCase(Locale.ROOT)));
        currentMinecraftServer = ((CommandSourceStack)cs.getSource()).getServer();
        cachedSuggestion = suggestedStrings;
        return suggestedStrings;
    }

    private static Set<String> methodReadSuggestions(CommandContext<CommandSourceStack> cs) {
        if (currentMinecraftServer == ((CommandSourceStack)cs.getSource()).getServer()) {
            return cachedSuggestion;
        }
        HashSet<String> suggestedStrings = new HashSet<String>();
        Arrays.stream(DATA_READ_ARG.values()).forEach(e -> suggestedStrings.add(e.name().toLowerCase(Locale.ROOT)));
        currentMinecraftServer = ((CommandSourceStack)cs.getSource()).getServer();
        cachedSuggestion = suggestedStrings;
        return suggestedStrings;
    }

    public static void runBooleanSetMethod(CommandSourceStack commandSourceStack, String dataString, Collection<ServerPlayer> targets, boolean bool, CommandContext<CommandSourceStack> cs) {
        DATA_READ_ARG dataArg;
        try {
            dataArg = DATA_READ_ARG.valueOf(dataString.toUpperCase(Locale.ROOT));
        }
        catch (Exception e) {
            MutableComponent mutableComponent = Component.translatable((String)"command.the_bumblezone.invalid_data_arg");
            commandSourceStack.sendFailure((Component)mutableComponent);
            return;
        }
        if (DATA_READ_ARG.IS_BEE_ESSENCED.equals((Object)dataArg)) {
            for (ServerPlayer targetPlayer : targets) {
                EssenceOfTheBees.setEssence(targetPlayer, bool);
            }
            MutableComponent mutableComponent = Component.translatable((String)"command.the_bumblezone.data_change_success");
            commandSourceStack.sendSuccess(() -> mutableComponent, true);
            return;
        }
    }

    private static Set<String> killedSuggestions(Collection<ServerPlayer> targets) {
        if (targets.isEmpty()) {
            return new HashSet<String>();
        }
        AtomicReference suggestedStrings = new AtomicReference(new HashSet());
        for (Player player : targets) {
            ModuleHelper.getModule((Entity)player, ModuleRegistry.PLAYER_DATA).ifPresent(module -> suggestedStrings.set(module.mobsKilledTracker.keySet().stream().map(killed -> "\"" + killed.toString() + "\"").collect(Collectors.toSet())));
        }
        return suggestedStrings.get();
    }

    public static void runReadMethod(CommandSourceStack commandSourceStack, String dataString, String killedString, Collection<ServerPlayer> targets, CommandContext<CommandSourceStack> cs) {
        NonOpCommands.DATA_ARG dataArg;
        try {
            dataArg = NonOpCommands.DATA_ARG.valueOf(dataString.toUpperCase(Locale.ROOT));
        }
        catch (Exception e) {
            MutableComponent mutableComponent = Component.translatable((String)"command.the_bumblezone.invalid_data_arg");
            commandSourceStack.sendFailure((Component)mutableComponent);
            return;
        }
        for (ServerPlayer targetPlayer : targets) {
            if (NonOpCommands.DATA_ARG.IS_BEE_ESSENCED.equals((Object)dataArg)) {
                boolean hasBeeEssence = EssenceOfTheBees.hasEssence(targetPlayer);
                MutableComponent mutableComponent = Component.translatable((String)(hasBeeEssence ? "command.the_bumblezone.have_bee_essence" : "command.the_bumblezone.does_not_have_bee_essence"), (Object[])new Object[]{targetPlayer.getDisplayName()});
                commandSourceStack.sendSuccess(() -> mutableComponent, false);
                return;
            }
            if (!PlayerDataHandler.rootAdvancementDone(targetPlayer)) {
                commandSourceStack.sendFailure((Component)Component.translatable((String)"command.the_bumblezone.queens_desired_not_active", (Object[])new Object[]{targetPlayer.getDisplayName()}));
                continue;
            }
            switch (dataArg) {
                case QUEENS_DESIRED_CRAFTED_BEEHIVE: {
                    ModuleHelper.getModule((Entity)targetPlayer, ModuleRegistry.PLAYER_DATA).ifPresent(capability -> commandSourceStack.sendSuccess(() -> Component.translatable((String)"command.the_bumblezone.queens_desired_crafted_beehive", (Object[])new Object[]{targetPlayer.getDisplayName(), capability.craftedBeehives}), false));
                    break;
                }
                case QUEENS_DESIRED_BEES_BRED: {
                    ModuleHelper.getModule((Entity)targetPlayer, ModuleRegistry.PLAYER_DATA).ifPresent(capability -> commandSourceStack.sendSuccess(() -> Component.translatable((String)"command.the_bumblezone.queens_desired_bees_bred", (Object[])new Object[]{targetPlayer.getDisplayName(), capability.beesBred}), false));
                    break;
                }
                case QUEENS_DESIRED_FLOWERS_SPAWNED: {
                    ModuleHelper.getModule((Entity)targetPlayer, ModuleRegistry.PLAYER_DATA).ifPresent(capability -> commandSourceStack.sendSuccess(() -> Component.translatable((String)"command.the_bumblezone.queens_desired_flowers_spawned", (Object[])new Object[]{targetPlayer.getDisplayName(), capability.flowersSpawned}), false));
                    break;
                }
                case QUEENS_DESIRED_HONEY_BOTTLE_DRANK: {
                    ModuleHelper.getModule((Entity)targetPlayer, ModuleRegistry.PLAYER_DATA).ifPresent(capability -> commandSourceStack.sendSuccess(() -> Component.translatable((String)"command.the_bumblezone.queens_desired_honey_bottle_drank", (Object[])new Object[]{targetPlayer.getDisplayName(), capability.honeyBottleDrank}), false));
                    break;
                }
                case QUEENS_DESIRED_BEE_STINGERS_FIRED: {
                    ModuleHelper.getModule((Entity)targetPlayer, ModuleRegistry.PLAYER_DATA).ifPresent(capability -> commandSourceStack.sendSuccess(() -> Component.translatable((String)"command.the_bumblezone.queens_desired_bee_stingers_fired", (Object[])new Object[]{targetPlayer.getDisplayName(), capability.beeStingersFired}), false));
                    break;
                }
                case QUEENS_DESIRED_BEE_SAVED: {
                    ModuleHelper.getModule((Entity)targetPlayer, ModuleRegistry.PLAYER_DATA).ifPresent(capability -> commandSourceStack.sendSuccess(() -> Component.translatable((String)"command.the_bumblezone.queens_desired_bee_saved", (Object[])new Object[]{targetPlayer.getDisplayName(), capability.beeSaved}), false));
                    break;
                }
                case QUEENS_DESIRED_POLLEN_PUFF_HITS: {
                    ModuleHelper.getModule((Entity)targetPlayer, ModuleRegistry.PLAYER_DATA).ifPresent(capability -> commandSourceStack.sendSuccess(() -> Component.translatable((String)"command.the_bumblezone.queens_desired_pollen_puff_hits", (Object[])new Object[]{targetPlayer.getDisplayName(), capability.pollenPuffHits}), false));
                    break;
                }
                case QUEENS_DESIRED_HONEY_SLIME_BRED: {
                    ModuleHelper.getModule((Entity)targetPlayer, ModuleRegistry.PLAYER_DATA).ifPresent(capability -> commandSourceStack.sendSuccess(() -> Component.translatable((String)"command.the_bumblezone.queens_desired_honey_slime_bred", (Object[])new Object[]{targetPlayer.getDisplayName(), capability.honeySlimeBred}), false));
                    break;
                }
                case QUEENS_DESIRED_BEES_FED: {
                    ModuleHelper.getModule((Entity)targetPlayer, ModuleRegistry.PLAYER_DATA).ifPresent(capability -> commandSourceStack.sendSuccess(() -> Component.translatable((String)"command.the_bumblezone.queens_desired_bees_fed", (Object[])new Object[]{targetPlayer.getDisplayName(), capability.beesFed}), false));
                    break;
                }
                case QUEENS_DESIRED_QUEEN_BEE_TRADE: {
                    ModuleHelper.getModule((Entity)targetPlayer, ModuleRegistry.PLAYER_DATA).ifPresent(capability -> commandSourceStack.sendSuccess(() -> Component.translatable((String)"command.the_bumblezone.queens_desired_queen_bee_trade", (Object[])new Object[]{targetPlayer.getDisplayName(), capability.queenBeeTrade}), false));
                    break;
                }
                case QUEENS_DESIRED_KILLED_ENTITY_COUNTER: {
                    if (killedString != null) {
                        ResourceLocation rl = ResourceLocation.tryParse((String)killedString);
                        ModuleHelper.getModule((Entity)targetPlayer, ModuleRegistry.PLAYER_DATA).ifPresent(capability -> {
                            int killed = capability.mobsKilledTracker.getOrDefault((Object)rl, 0);
                            String translationKey = rl.equals((Object)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"ender_dragon")) ? "command.the_bumblezone.queens_desired_killed_entity_counter_ender_dragon" : (rl.equals((Object)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"wither")) ? "command.the_bumblezone.queens_desired_killed_entity_counter_wither" : "command.the_bumblezone.queens_desired_killed_entity_counter");
                            if (BuiltInRegistries.ENTITY_TYPE.containsKey(rl)) {
                                commandSourceStack.sendSuccess(() -> Component.translatable((String)translationKey, (Object[])new Object[]{targetPlayer.getDisplayName(), killed, Component.translatable((String)Util.makeDescriptionId((String)"entity", (ResourceLocation)rl))}), false);
                            } else {
                                commandSourceStack.sendSuccess(() -> Component.translatable((String)translationKey, (Object[])new Object[]{targetPlayer.getDisplayName(), killed, Component.translatable((String)("tag.entity_type." + killedString.replaceAll("[\\\\:/-]", ".")))}), false);
                            }
                        });
                        break;
                    }
                    commandSourceStack.sendSuccess(() -> Component.translatable((String)"command.the_bumblezone.invalid_entity_arg"), false);
                    return;
                }
            }
        }
    }

    public static void runTeleportMethod(CommandSourceStack commandSourceStack, Collection<? extends Entity> targets, CommandContext<CommandSourceStack> cs) {
        for (Entity entity : targets) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)entity;
            if (entity.level().dimension().equals(BzDimension.BZ_WORLD_KEY)) {
                BumblezoneAPI.teleportOutOfBz(livingEntity);
                continue;
            }
            BumblezoneAPI.queueEntityForTeleportingToBumblezone((Entity)livingEntity);
        }
    }

    private static <O> O cast(Object input) {
        return (O)input;
    }

    private static <T extends Registry<?>> SuggestionProvider<CommandSourceStack> suggestFromRegistry(Function<Registry<?>, Iterable<ResourceLocation>> namesFunction, String argumentString, ResourceKey<Registry<T>> registryKey) {
        return (ctx, builder) -> OpCommands.getResourceKey((CommandContext<CommandSourceStack>)ctx, argumentString, registryKey).flatMap(key -> ((CommandSourceStack)ctx.getSource()).registryAccess().registry(key).map(registry -> {
            SharedSuggestionProvider.suggestResource((Iterable)((Iterable)namesFunction.apply((Registry<?>)registry)), (SuggestionsBuilder)builder);
            return builder.buildFuture();
        })).orElseGet(() -> ((SuggestionsBuilder)builder).buildFuture());
    }

    private static <T> Optional<ResourceKey<T>> getResourceKey(CommandContext<CommandSourceStack> ctx, String name, ResourceKey<Registry<T>> registryKey) {
        ResourceKey key = (ResourceKey)ctx.getArgument(name, ResourceKey.class);
        return key.cast(registryKey);
    }

    static enum DATA_READ_ARG {
        IS_BEE_ESSENCED,
        QUEENS_DESIRED_CRAFTED_BEEHIVE,
        QUEENS_DESIRED_BEES_BRED,
        QUEENS_DESIRED_FLOWERS_SPAWNED,
        QUEENS_DESIRED_HONEY_BOTTLE_DRANK,
        QUEENS_DESIRED_BEE_STINGERS_FIRED,
        QUEENS_DESIRED_BEE_SAVED,
        QUEENS_DESIRED_POLLEN_PUFF_HITS,
        QUEENS_DESIRED_HONEY_SLIME_BRED,
        QUEENS_DESIRED_BEES_FED,
        QUEENS_DESIRED_QUEEN_BEE_TRADE,
        QUEENS_DESIRED_KILLED_ENTITY_COUNTER;

    }

    static enum DATA_BOOLEAN_WRITE_ARG {
        IS_BEE_ESSENCED;

    }
}

