/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.entities.goals;

import com.telepathicgrunt.the_bumblezone.entities.controllers.HoneySlimeMoveController;
import com.telepathicgrunt.the_bumblezone.entities.mobs.HoneySlimeEntity;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;

public class HoneySlimeAngerAttackingGoal
extends TargetGoal {
    private final HoneySlimeEntity slime;

    public HoneySlimeAngerAttackingGoal(HoneySlimeEntity slimeIn) {
        super((Mob)slimeIn, true);
        this.slime = slimeIn;
        this.setFlags(EnumSet.of(Goal.Flag.TARGET));
    }

    public boolean canUse() {
        LivingEntity livingEntity = this.slime.getTarget();
        if (livingEntity == null) {
            this.slime.setRemainingPersistentAngerTime(0);
            return false;
        }
        return true;
    }

    public boolean canContinueToUse() {
        return this.slime.getTarget() != null && super.canContinueToUse();
    }

    public void tick() {
        if (this.slime.isPassenger()) {
            return;
        }
        if (this.slime.getTarget() != null) {
            this.slime.lookAt((Entity)this.slime.getTarget(), 10.0f, 10.0f);
        }
        ((HoneySlimeMoveController)this.slime.getMoveControl()).setDirection(this.slime.getYRot(), this.slime.canDamagePlayer());
    }
}

