/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.items;

import com.telepathicgrunt.the_bumblezone.entities.nonliving.PollenPuffEntity;
import com.telepathicgrunt.the_bumblezone.modinit.BzSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class PollenPuff
extends Item
implements ProjectileItem {
    public PollenPuff(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player playerEntity, InteractionHand hand) {
        ItemStack itemstack = playerEntity.getItemInHand(hand);
        if (!world.isClientSide()) {
            world.playSound(null, playerEntity.getX(), playerEntity.getY(), playerEntity.getZ(), (SoundEvent)BzSounds.POLLEN_PUFF_THROW.get(), SoundSource.PLAYERS, 0.5f, 0.4f / (playerEntity.getRandom().nextFloat() * 0.4f + 0.8f));
            PollenPuffEntity pollenPuffEntity = new PollenPuffEntity(world, (LivingEntity)playerEntity);
            pollenPuffEntity.setItem(itemstack);
            pollenPuffEntity.shootFromRotation((Entity)playerEntity, playerEntity.getXRot(), playerEntity.getYRot(), 0.0f, 1.5f, 1.0f);
            world.addFreshEntity((Entity)pollenPuffEntity);
            playerEntity.awardStat(Stats.ITEM_USED.get((Object)this));
            if (!playerEntity.isCreative()) {
                itemstack.shrink(1);
            }
        }
        return InteractionResultHolder.sidedSuccess((Object)itemstack, (boolean)world.isClientSide());
    }

    public static void spawnItemstackEntity(Level world, RandomSource random, BlockPos blockPos, ItemStack itemStack) {
        if (!world.isClientSide() && !itemStack.isEmpty()) {
            double x = (double)(random.nextFloat() * 0.5f) + 0.25;
            double y = (double)(random.nextFloat() * 0.5f) + 0.25;
            double z = (double)(random.nextFloat() * 0.5f) + 0.25;
            ItemEntity itemEntity = new ItemEntity(world, (double)blockPos.getX() + x, (double)blockPos.getY() + y, (double)blockPos.getZ() + z, itemStack);
            itemEntity.setDefaultPickUpDelay();
            world.addFreshEntity((Entity)itemEntity);
        }
    }

    public static void spawnItemstackEntity(Level world, Vec3 pos, ItemStack itemStack) {
        if (!world.isClientSide() && !itemStack.isEmpty()) {
            ItemEntity itemEntity = new ItemEntity(world, pos.x(), pos.y(), pos.z(), itemStack);
            itemEntity.setDefaultPickUpDelay();
            world.addFreshEntity((Entity)itemEntity);
        }
    }

    public Projectile asProjectile(Level level, Position position, ItemStack itemStack, Direction direction) {
        PollenPuffEntity pollenPuffEntity = new PollenPuffEntity(level, position.x(), position.y(), position.z());
        pollenPuffEntity.setItem(itemStack);
        return pollenPuffEntity;
    }
}

