/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.modcompat.neoforge.framedblocks;

import com.telepathicgrunt.the_bumblezone.blocks.AncientWax;
import com.telepathicgrunt.the_bumblezone.blocks.CarvableWax;
import com.telepathicgrunt.the_bumblezone.blocks.LuminescentWaxBase;
import com.telepathicgrunt.the_bumblezone.mixin.neoforge.block.UseOnContextAccessor;
import com.telepathicgrunt.the_bumblezone.modcompat.ModChecker;
import com.telepathicgrunt.the_bumblezone.modcompat.ModCompat;
import com.telepathicgrunt.the_bumblezone.modcompat.neoforge.framedblocks.CarvableWaxBlockCamoContainer;
import com.telepathicgrunt.the_bumblezone.modcompat.neoforge.framedblocks.CarvableWaxBlockCamoContainerFactory;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.UseItemOnBlockEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import xfacthd.framedblocks.api.block.blockentity.FramedBlockEntity;
import xfacthd.framedblocks.api.camo.CamoContainer;
import xfacthd.framedblocks.api.camo.CamoContainerFactory;
import xfacthd.framedblocks.api.camo.block.AbstractBlockCamoContainer;
import xfacthd.framedblocks.api.util.FramedConstants;

public final class FramedBlocksCompat
implements ModCompat {
    private static final DeferredRegister<CamoContainerFactory<?>> CAMO_FACTORIES = DeferredRegister.create((ResourceLocation)FramedConstants.CAMO_CONTAINER_FACTORY_REGISTRY_NAME, (String)"the_bumblezone");
    static final DeferredHolder<CamoContainerFactory<?>, CarvableWaxBlockCamoContainerFactory> WAX_BLOCK_CAMO_FACTORY = CAMO_FACTORIES.register("carvable_wax", CarvableWaxBlockCamoContainerFactory::new);

    public FramedBlocksCompat(IEventBus modEventBus) {
        CAMO_FACTORIES.register(modEventBus);
        NeoForge.EVENT_BUS.addListener(FramedBlocksCompat::onItemUsedOnBlock);
        ModChecker.framedBlocksPresent = true;
    }

    private static void onItemUsedOnBlock(UseItemOnBlockEvent event) {
        CarvableWaxBlockCamoContainer waxCamo;
        Block block;
        BlockEntity blockEntity;
        Level level = event.getLevel();
        Player player = event.getPlayer();
        BlockPos pos = event.getPos();
        if (player == null || !((blockEntity = level.getBlockEntity(pos)) instanceof FramedBlockEntity)) {
            return;
        }
        FramedBlockEntity be = (FramedBlockEntity)blockEntity;
        BlockHitResult hit = ((UseOnContextAccessor)event.getUseOnContext()).bumblezone$getHitResult();
        CamoContainer camo = be.getCamo(hit, player);
        if (camo instanceof CarvableWaxBlockCamoContainer && (block = (waxCamo = (CarvableWaxBlockCamoContainer)camo).getState().getBlock()) instanceof CarvableWax) {
            CarvableWax wax = (CarvableWax)block;
            BlockState carvedState = wax.tryCarve(event.getItemStack(), waxCamo.getState(), level, pos, player, event.getHand());
            if (carvedState != null) {
                if (!level.isClientSide()) {
                    be.setCamo((CamoContainer)waxCamo.copyWithState(carvedState), hit, player);
                }
                event.cancelWithResult(ItemInteractionResult.sidedSuccess((boolean)level.isClientSide()));
            }
        } else if (camo instanceof AbstractBlockCamoContainer) {
            AbstractBlockCamoContainer blockCamo = (AbstractBlockCamoContainer)camo;
            Block block2 = blockCamo.getState().getBlock();
            if (block2 instanceof LuminescentWaxBase) {
                LuminescentWaxBase lumiWax = (LuminescentWaxBase)block2;
                rotatedState = lumiWax.tryRotate(event.getItemStack(), blockCamo.getState(), level, pos, player, event.getHand());
                if (rotatedState != null) {
                    if (!level.isClientSide()) {
                        be.setCamo((CamoContainer)blockCamo.copyWithState((BlockState)rotatedState), hit, player);
                    }
                    event.cancelWithResult(ItemInteractionResult.sidedSuccess((boolean)level.isClientSide()));
                }
            } else {
                AncientWax ancientWax;
                BlockState swappedState;
                rotatedState = blockCamo.getState().getBlock();
                if (rotatedState instanceof AncientWax && (swappedState = (ancientWax = (AncientWax)rotatedState).trySwap(event.getItemStack(), blockCamo.getState(), level, pos, player, event.getHand())) != null) {
                    if (!level.isClientSide()) {
                        be.setCamo((CamoContainer)blockCamo.copyWithState(swappedState), hit, player);
                    }
                    event.cancelWithResult(ItemInteractionResult.sidedSuccess((boolean)level.isClientSide()));
                }
            }
        }
    }
}

