/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.packets;

import com.teamresourceful.resourcefullib.common.network.Packet;
import com.teamresourceful.resourcefullib.common.network.base.ClientboundPacketType;
import com.teamresourceful.resourcefullib.common.network.base.PacketType;
import com.telepathicgrunt.the_bumblezone.packets.MessageHandler;
import com.telepathicgrunt.the_bumblezone.packets.handlers.MobEffectClientSyncPacketHandleBody;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;

public record MobEffectClientSyncPacket(int entityId, ResourceLocation effectRl, byte effectAmplifier, int effectDurationTicks, byte flags) implements Packet<MobEffectClientSyncPacket>
{
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"mob_effect_client_sync");
    public static final ClientboundPacketType<MobEffectClientSyncPacket> TYPE = new Handler();
    private static final int FLAG_AMBIENT = 1;
    private static final int FLAG_VISIBLE = 2;
    private static final int FLAG_SHOW_ICON = 4;

    public MobEffectClientSyncPacket(int mobId, MobEffectInstance mobEffectInstance) {
        this(mobId, BuiltInRegistries.MOB_EFFECT.getKey((Object)((MobEffect)mobEffectInstance.getEffect().value())), (byte)(mobEffectInstance.getAmplifier() & 0xFF), Math.min(mobEffectInstance.getDuration(), Short.MAX_VALUE), MobEffectClientSyncPacket.getFlags(mobEffectInstance));
    }

    private static byte getFlags(MobEffectInstance mobEffectInstance) {
        byte flags = 0;
        if (mobEffectInstance.isAmbient()) {
            flags = (byte)(flags | 1);
        }
        if (mobEffectInstance.isVisible()) {
            flags = (byte)(flags | 2);
        }
        if (mobEffectInstance.showIcon()) {
            flags = (byte)(flags | 4);
        }
        return flags;
    }

    public boolean isEffectVisible() {
        return (this.flags & 2) == 2;
    }

    public boolean isEffectAmbient() {
        return (this.flags & 1) == 1;
    }

    public boolean effectShowsIcon() {
        return (this.flags & 4) == 4;
    }

    public static void sendToClient(Entity entity, MobEffectInstance mobEffectInstance) {
        MessageHandler.DEFAULT_CHANNEL.sendToPlayersInLevel((Packet)new MobEffectClientSyncPacket(entity.getId(), mobEffectInstance), entity.level());
    }

    public PacketType<MobEffectClientSyncPacket> type() {
        return TYPE;
    }

    private static final class Handler
    implements ClientboundPacketType<MobEffectClientSyncPacket> {
        private Handler() {
        }

        public void encode(MobEffectClientSyncPacket message, RegistryFriendlyByteBuf buffer) {
            buffer.writeVarInt(message.entityId);
            buffer.writeResourceLocation(message.effectRl);
            buffer.writeByte((int)message.effectAmplifier);
            buffer.writeVarInt(message.effectDurationTicks);
            buffer.writeByte((int)message.flags);
        }

        public MobEffectClientSyncPacket decode(RegistryFriendlyByteBuf buffer) {
            return new MobEffectClientSyncPacket(buffer.readVarInt(), buffer.readResourceLocation(), buffer.readByte(), buffer.readVarInt(), buffer.readByte());
        }

        public Runnable handle(MobEffectClientSyncPacket message) {
            return () -> MobEffectClientSyncPacketHandleBody.handle(message);
        }

        public Class<MobEffectClientSyncPacket> type() {
            return MobEffectClientSyncPacket.class;
        }

        public ResourceLocation id() {
            return ID;
        }
    }
}

