/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.blocks.blockentities;

import com.telepathicgrunt.the_bumblezone.blocks.HoneyCocoon;
import com.telepathicgrunt.the_bumblezone.blocks.blockentities.BzRandomizableContainerBlockEntity;
import com.telepathicgrunt.the_bumblezone.configs.BzModCompatibilityConfigs;
import com.telepathicgrunt.the_bumblezone.menus.StrictChestMenu;
import com.telepathicgrunt.the_bumblezone.modcompat.ModChecker;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlockEntities;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzFluids;
import com.telepathicgrunt.the_bumblezone.modinit.BzMenuTypes;
import java.util.UUID;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.loot.LootTable;
import org.jetbrains.annotations.NotNull;

public class HoneyCocoonBlockEntity
extends BzRandomizableContainerBlockEntity {
    private NonNullList<ItemStack> itemStacks = NonNullList.withSize((int)18, (Object)ItemStack.EMPTY);
    private UUID blockEntityUuid = null;

    protected HoneyCocoonBlockEntity(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    public HoneyCocoonBlockEntity(BlockPos blockPos, BlockState blockState) {
        this((BlockEntityType)BzBlockEntities.HONEY_COCOON.get(), blockPos, blockState);
    }

    public int getContainerSize() {
        return this.itemStacks.size();
    }

    protected Component getDefaultName() {
        return Component.translatable((String)"container.the_bumblezone.honey_cocoon");
    }

    public void loadAdditional(@NotNull CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.loadFromTag(tag, provider);
    }

    public void loadFromTag(CompoundTag compoundTag, HolderLookup.Provider provider) {
        this.itemStacks = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        if (!this.tryLoadLootTable(compoundTag) && compoundTag.contains("Items", 9)) {
            ContainerHelper.loadAllItems((CompoundTag)compoundTag, this.itemStacks, (HolderLookup.Provider)provider);
        }
        if (compoundTag.hasUUID("blockEntityUuid")) {
            this.blockEntityUuid = compoundTag.getUUID("blockEntityUuid");
        }
    }

    protected void saveAdditional(@NotNull CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        if (!this.trySaveLootTable(tag)) {
            ContainerHelper.saveAllItems((CompoundTag)tag, this.itemStacks, (HolderLookup.Provider)provider);
        }
        tag.putUUID("blockEntityUuid", this.getBlockEntityUuid());
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, HoneyCocoonBlockEntity honeyCocoonBlockEntity) {
        if (level instanceof ServerLevel) {
            boolean lootrActive;
            ServerLevel serverLevel = (ServerLevel)level;
            boolean bl = lootrActive = ModChecker.lootrPresent && BzModCompatibilityConfigs.allowLootrCompat;
            if (honeyCocoonBlockEntity.getLootTable() != null && (Boolean)blockState.getValue((Property)HoneyCocoon.IS_LOOT_CONTAINER) != lootrActive) {
                serverLevel.setBlock(blockPos, (BlockState)blockState.setValue((Property)HoneyCocoon.IS_LOOT_CONTAINER, (Comparable)Boolean.valueOf(lootrActive)), 2);
            }
        }
    }

    protected NonNullList<ItemStack> getItems() {
        if (this.isLootWithLootrOn()) {
            return NonNullList.create();
        }
        return this.itemStacks;
    }

    protected void setItems(@NotNull NonNullList<ItemStack> itemStacks) {
        if (this.isLootWithLootrOn()) {
            return;
        }
        this.itemStacks = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < this.itemStacks.size(); ++i) {
            if (i >= itemStacks.size()) continue;
            this.itemStacks.set(0, (Object)((ItemStack)itemStacks.get(i)));
        }
    }

    public ItemStack getItem(int slotIndex) {
        if (this.isLootWithLootrOn()) {
            return ItemStack.EMPTY;
        }
        return super.getItem(slotIndex);
    }

    public ItemStack removeItem(int slotIndex, int removeAmount) {
        if (this.isLootWithLootrOn()) {
            return ItemStack.EMPTY;
        }
        return super.removeItem(slotIndex, removeAmount);
    }

    public ItemStack removeItemNoUpdate(int slotIndex) {
        if (this.isLootWithLootrOn()) {
            return ItemStack.EMPTY;
        }
        return super.removeItemNoUpdate(slotIndex);
    }

    public void setItem(int slotIndex, ItemStack itemStack) {
        if (this.isLootWithLootrOn()) {
            return;
        }
        super.setItem(slotIndex, itemStack);
    }

    private boolean isLootWithLootrOn() {
        if (this.getLootTable() == null || !ModChecker.lootrPresent || !BzModCompatibilityConfigs.allowLootrCompat) {
            return false;
        }
        BlockState state = this.getBlockState();
        return state.is((Block)BzBlocks.HONEY_COCOON.get()) && (Boolean)state.getValue((Property)HoneyCocoon.IS_LOOT_CONTAINER) != false;
    }

    protected AbstractContainerMenu createMenu(int slot, @NotNull Inventory inventory) {
        return new StrictChestMenu((MenuType)BzMenuTypes.STRICT_9x2.get(), slot, inventory, (Container)this, this.getContainerSize() / 9);
    }

    public int[] getSlotsForFace(@NotNull Direction direction) {
        return IntStream.range(0, this.getContainerSize()).toArray();
    }

    @Override
    public Direction getInputDirection() {
        return Direction.UP;
    }

    @Override
    public boolean canPlaceItemThroughFace(int i, @NotNull ItemStack stack, Direction direction) {
        if (this.isLootWithLootrOn()) {
            return false;
        }
        return super.canPlaceItemThroughFace(i, stack, direction);
    }

    @Override
    public boolean canTakeItemThroughFace(int i, @NotNull ItemStack stack, @NotNull Direction direction) {
        if (this.isLootWithLootrOn()) {
            return false;
        }
        return super.canTakeItemThroughFace(i, stack, direction);
    }

    public boolean triggerEvent(int i, int i1) {
        if (i == 1) {
            return true;
        }
        return super.triggerEvent(i, i1);
    }

    public boolean isUnpackedLoottable() {
        return this.lootTable == null;
    }

    public void unpackLootTable(Player player) {
        BlockState blockState;
        if (ModChecker.lootrPresent && BzModCompatibilityConfigs.allowLootrCompat) {
            return;
        }
        super.unpackLootTable(player);
        if (this.level != null && (blockState = this.level.getBlockState(this.worldPosition)).is((Block)BzBlocks.HONEY_COCOON.get()) && ((Boolean)blockState.getValue((Property)HoneyCocoon.WATERLOGGED)).booleanValue()) {
            this.level.scheduleTick(this.worldPosition, (Fluid)BzFluids.SUGAR_WATER_FLUID.get(), ((FlowingFluid)BzFluids.SUGAR_WATER_FLUID.get()).getTickDelay((LevelReader)this.level));
            this.level.scheduleTick(this.worldPosition, blockState.getBlock(), 150);
        }
    }

    public UUID getBlockEntityUuid() {
        if (this.blockEntityUuid == null) {
            this.blockEntityUuid = UUID.randomUUID();
        }
        return this.blockEntityUuid;
    }

    public ResourceKey<LootTable> getLootTable() {
        return this.lootTable;
    }

    public long getLootSeed() {
        return this.lootTableSeed;
    }
}

