/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.client.rendering.rootmin;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.telepathicgrunt.the_bumblezone.client.rendering.rootmin.RootminAnimations;
import com.telepathicgrunt.the_bumblezone.entities.mobs.RootminEntity;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;

public class RootminModel
extends HierarchicalModel<RootminEntity> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"rootmin"), "main");
    private final ModelPart root;

    public RootminModel(ModelPart root) {
        this.root = root.getChild("root");
    }

    public ModelPart root() {
        return this.root;
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition root = partdefinition.addOrReplaceChild("root", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-8.0f, -15.0f, -8.0f, 16.0f, 16.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-10.0f, (float)0.0f));
        PartDefinition slightly_shut_eyes = body.addOrReplaceChild("slightly_shut_eyes", CubeListBuilder.create().texOffs(27, 37).addBox(2.0f, -9.0f, -8.0f, 6.0f, 1.0f, 2.0f, new CubeDeformation(0.025f)).texOffs(27, 37).addBox(-8.0f, -9.0f, -8.0f, 6.0f, 1.0f, 2.0f, new CubeDeformation(0.025f)), PartPose.offset((float)0.0f, (float)1.0f, (float)0.0f));
        PartDefinition almost_shut_eyes = body.addOrReplaceChild("almost_shut_eyes", CubeListBuilder.create().texOffs(27, 37).addBox(2.0f, -9.0f, -8.0f, 6.0f, 3.0f, 2.0f, new CubeDeformation(0.025f)).texOffs(27, 37).addBox(-8.0f, -9.0f, -8.0f, 6.0f, 3.0f, 2.0f, new CubeDeformation(0.025f)), PartPose.offset((float)0.0f, (float)1.0f, (float)0.0f));
        PartDefinition shut_eyes = body.addOrReplaceChild("shut_eyes", CubeListBuilder.create().texOffs(27, 37).addBox(2.0f, -9.0f, -8.0f, 6.0f, 5.0f, 2.0f, new CubeDeformation(0.025f)).texOffs(27, 37).addBox(-8.0f, -9.0f, -8.0f, 6.0f, 5.0f, 2.0f, new CubeDeformation(0.025f)), PartPose.offset((float)0.0f, (float)1.0f, (float)0.0f));
        PartDefinition mouth = body.addOrReplaceChild("mouth", CubeListBuilder.create().texOffs(0, 33).addBox(-2.0f, -2.0f, -8.0f, 4.0f, 4.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-5.0f, (float)-8.0f));
        PartDefinition right_leg = root.addOrReplaceChild("right_leg", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-4.0f, (float)-12.0f, (float)-1.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition leg_r1 = right_leg.addOrReplaceChild("leg_r1", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, -12.0f, -1.0f, 6.0f, 12.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)12.0f, (float)2.25f, (float)0.0f, (float)1.1345f, (float)0.0f));
        PartDefinition leg_r2 = right_leg.addOrReplaceChild("leg_r2", CubeListBuilder.create().texOffs(0, 0).addBox(-5.0f, -12.0f, -1.0f, 6.0f, 12.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)12.0f, (float)2.25f, (float)0.0f, (float)-1.1345f, (float)0.0f));
        PartDefinition right_foot = right_leg.addOrReplaceChild("right_foot", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)11.75f, (float)0.25f));
        PartDefinition leg_r3 = right_foot.addOrReplaceChild("leg_r3", CubeListBuilder.create().texOffs(0, 49).addBox(-3.0f, 0.0f, 0.5f, 5.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)2.0f, (float)-1.7453f, (float)0.0f, (float)0.0f));
        PartDefinition left_leg = root.addOrReplaceChild("left_leg", CubeListBuilder.create(), PartPose.offsetAndRotation((float)4.0f, (float)-12.0f, (float)-1.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition leg_r4 = left_leg.addOrReplaceChild("leg_r4", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(-1.0f, -12.0f, -1.0f, 6.0f, 12.0f, 0.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)12.0f, (float)2.25f, (float)0.0f, (float)1.1345f, (float)0.0f));
        PartDefinition leg_r5 = left_leg.addOrReplaceChild("leg_r5", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(-5.0f, -12.0f, -1.0f, 6.0f, 12.0f, 0.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)12.0f, (float)2.25f, (float)0.0f, (float)-1.1345f, (float)0.0f));
        PartDefinition left_foot = left_leg.addOrReplaceChild("left_foot", CubeListBuilder.create(), PartPose.offset((float)1.0f, (float)11.75f, (float)0.25f));
        PartDefinition leg_r6 = left_foot.addOrReplaceChild("leg_r6", CubeListBuilder.create().texOffs(0, 49).mirror().addBox(-3.0f, 0.0f, 0.5f, 5.0f, 8.0f, 0.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)2.0f, (float)-1.7453f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(RootminEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.animate(entity.idleAnimationState, RootminAnimations.IDLE, ageInTicks);
        this.animate(entity.angryAnimationState, RootminAnimations.ANGRY, ageInTicks);
        this.animate(entity.curiousAnimationState, RootminAnimations.CURIOUS, ageInTicks);
        this.animate(entity.curseAnimationState, RootminAnimations.CURSE, ageInTicks);
        this.animate(entity.embarassedAnimationState, RootminAnimations.EMBARASSED, ageInTicks);
        this.animate(entity.shockAnimationState, RootminAnimations.SHOCK, ageInTicks);
        this.animate(entity.shootAnimationState, RootminAnimations.SHOOT, ageInTicks);
        this.animate(entity.runAnimationState, RootminAnimations.RUN, ageInTicks);
        this.animate(entity.walkAnimationState, RootminAnimations.WALK, ageInTicks);
        this.animate(entity.blockToEntityAnimationState, RootminAnimations.BLOCK_TO_ENTITY, ageInTicks);
        this.animate(entity.entityToBlockAnimationState, RootminAnimations.ENTITY_TO_BLOCK, ageInTicks);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int packedColor) {
        this.root.render(poseStack, vertexConsumer, packedLight, packedOverlay, packedColor);
    }
}

