/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.enchantments;

import com.mojang.datafixers.util.Pair;
import com.telepathicgrunt.the_bumblezone.enchantments.datacomponents.HiveLifelineMarker;
import com.telepathicgrunt.the_bumblezone.events.entity.BzEntityAttackedEvent;
import com.telepathicgrunt.the_bumblezone.modinit.BzEnchantments;
import com.telepathicgrunt.the_bumblezone.modinit.BzParticles;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import java.util.Comparator;
import java.util.List;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

public class HiveLifelineEnchantmentApplication {
    private static final TargetingConditions SEE_THROUGH_WALLS = TargetingConditions.forCombat().ignoreLineOfSight().ignoreInvisibilityTesting();

    public static Pair<HiveLifelineMarker, Integer> getHiveLifelineEnchantLevel(ItemStack stack) {
        return EnchantmentHelper.getHighestLevel((ItemStack)stack, (DataComponentType)((DataComponentType)BzEnchantments.HIVE_LIFELINE_MARKER.get()));
    }

    public static boolean entityHurtEvent(BzEntityAttackedEvent event) {
        ServerPlayer player;
        LivingEntity livingEntity = event.entity();
        if (!(livingEntity instanceof ServerPlayer) || !((livingEntity = (player = (ServerPlayer)livingEntity).level()) instanceof ServerLevel)) {
            return false;
        }
        ServerLevel serverLevel = (ServerLevel)livingEntity;
        Entity attacker = event.source().getEntity();
        if (attacker == null || attacker.getType().is(BzTags.HIVE_LIFELINE_CANNOT_TRIGGER_LIFELINE)) {
            return false;
        }
        ItemStack currentHiveLifelineArmor = null;
        Pair<HiveLifelineMarker, Integer> hiveLifelineMarker = null;
        for (ItemStack armorItem : player.getArmorSlots()) {
            Pair<HiveLifelineMarker, Integer> enchantmentResult;
            if (player.getCooldowns().isOnCooldown(armorItem.getItem()) || (enchantmentResult = HiveLifelineEnchantmentApplication.getHiveLifelineEnchantLevel(armorItem)) == null) continue;
            currentHiveLifelineArmor = armorItem;
            hiveLifelineMarker = enchantmentResult;
            break;
        }
        if (currentHiveLifelineArmor == null) {
            return false;
        }
        int baseRange = ((HiveLifelineMarker)hiveLifelineMarker.getFirst()).lifelineEntityRange();
        int additionalRange = ((HiveLifelineMarker)hiveLifelineMarker.getFirst()).lifelineEntityRangeIncreasePerAdditionalLevel() * ((Integer)hiveLifelineMarker.getSecond() - 1);
        List entitiesNearby = serverLevel.getNearbyEntities(LivingEntity.class, SEE_THROUGH_WALLS, (LivingEntity)player, player.getBoundingBox().inflate((double)(baseRange + additionalRange)));
        entitiesNearby.sort(Comparator.comparingDouble(entity -> entity.position().distanceTo(player.position())));
        for (LivingEntity nearbyEntity : entitiesNearby) {
            Mob mob;
            if (!nearbyEntity.getType().is(BzTags.HIVE_LIFELINE_TAKES_PLAYER_DAMAGE) || nearbyEntity.isInvulnerable() || nearbyEntity.isDeadOrDying() || nearbyEntity instanceof Mob && (mob = (Mob)nearbyEntity).isNoAi()) continue;
            nearbyEntity.hurt(event.source(), event.amount());
            player.getCooldowns().addCooldown(currentHiveLifelineArmor.getItem(), ((HiveLifelineMarker)hiveLifelineMarker.getFirst()).armorCooldownTicks());
            serverLevel.sendParticles((ParticleOptions)((SimpleParticleType)BzParticles.SPARKLE_PARTICLE.get()), player.position().x(), player.position().y() + 1.0, player.position().z(), 50, player.getRandom().nextGaussian() * 0.1, player.getRandom().nextGaussian() * 0.1 + 0.1, player.getRandom().nextGaussian() * 0.1, (double)player.getRandom().nextFloat() * 0.1 + (double)0.1f);
            serverLevel.sendParticles((ParticleOptions)((SimpleParticleType)BzParticles.SPARKLE_PARTICLE.get()), nearbyEntity.position().x(), nearbyEntity.position().y() + 1.0, nearbyEntity.position().z(), 50, nearbyEntity.getRandom().nextGaussian() * 0.1, nearbyEntity.getRandom().nextGaussian() * 0.1 + 0.1, nearbyEntity.getRandom().nextGaussian() * 0.1, (double)nearbyEntity.getRandom().nextFloat() * 0.1 + (double)0.1f);
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.ANGRY_VILLAGER, nearbyEntity.position().x(), nearbyEntity.position().y() + 1.0, nearbyEntity.position().z(), 3, nearbyEntity.getRandom().nextGaussian() * 0.4, nearbyEntity.getRandom().nextGaussian() * 0.4 + 0.1, nearbyEntity.getRandom().nextGaussian() * 0.4, (double)nearbyEntity.getRandom().nextFloat() * 0.1 + (double)0.1f);
            currentHiveLifelineArmor.hurtAndBreak(1, serverLevel, player, item -> {});
            return true;
        }
        return false;
    }
}

