/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.entities.goals;

import com.telepathicgrunt.the_bumblezone.entities.mobs.BeehemothEntity;
import java.util.EnumSet;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.Nullable;

public class BeehemothTemptGoal
extends Goal {
    private static final TargetingConditions TEMP_TARGETING = TargetingConditions.forNonCombat().range(10.0).ignoreLineOfSight();
    private final TargetingConditions targetingConditions;
    protected final BeehemothEntity mob;
    private final double speedModifier;
    @Nullable
    protected Player player;
    private final TagKey<Item> temptItemTag;

    public BeehemothTemptGoal(BeehemothEntity pathfinderMob, double speedModifier, TagKey<Item> temptItemTag) {
        this.mob = pathfinderMob;
        this.speedModifier = speedModifier;
        this.temptItemTag = temptItemTag;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.targetingConditions = TEMP_TARGETING.copy().selector(entity -> this.mob.getOwner() == entity).selector(this::shouldFollow);
    }

    public boolean canUse() {
        if (this.mob.isTame()) {
            Player ownerPlayer;
            LivingEntity owner = this.mob.getOwner();
            if (owner instanceof Player && (ownerPlayer = (Player)owner).isAlive() && ownerPlayer.level() == this.mob.level() && this.shouldFollow((LivingEntity)ownerPlayer)) {
                this.player = ownerPlayer;
                this.mob.setInSittingPose(false);
                return true;
            }
            return false;
        }
        this.player = this.mob.level().getNearestPlayer(this.targetingConditions, (LivingEntity)this.mob);
        return this.player != null;
    }

    private boolean shouldFollow(LivingEntity livingEntity) {
        return livingEntity.getMainHandItem().is(this.temptItemTag) || livingEntity.getOffhandItem().is(this.temptItemTag);
    }

    public boolean canContinueToUse() {
        double d = this.mob.distanceToSqr((Entity)this.player);
        double d2 = this.mob.isTame() ? 200.0 : 36.0;
        if (d > d2) {
            return false;
        }
        return this.canUse();
    }

    public void stop() {
        this.player = null;
        this.mob.getNavigation().stop();
    }

    public void tick() {
        this.mob.getLookControl().setLookAt((Entity)this.player, (float)(this.mob.getMaxHeadYRot() + 20), (float)this.mob.getMaxHeadXRot());
        if (this.mob.distanceToSqr((Entity)this.player) < 6.25) {
            this.mob.getNavigation().stop();
        } else {
            this.mob.getNavigation().moveTo((Entity)this.player, this.speedModifier * (double)(this.mob.isTame() ? 2 : 1));
        }
    }
}

