/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.entities.goals;

import com.telepathicgrunt.the_bumblezone.entities.controllers.HoneySlimeMoveController;
import com.telepathicgrunt.the_bumblezone.entities.mobs.HoneySlimeEntity;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class HoneySlimeTemptGoal
extends Goal {
    private static final TargetingConditions ENTITY_PREDICATE = TargetingConditions.forNonCombat().range(10.0).ignoreLineOfSight();
    protected final HoneySlimeEntity slime;
    private double targetX;
    private double targetY;
    private double targetZ;
    private double pitch;
    private double yaw;
    protected Player closestPlayer;
    private int delayTemptCounter;

    public HoneySlimeTemptGoal(HoneySlimeEntity creatureIn) {
        this.slime = creatureIn;
        this.setFlags(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        if (this.delayTemptCounter > 0) {
            --this.delayTemptCounter;
            return false;
        }
        this.closestPlayer = this.slime.level().getNearestPlayer(ENTITY_PREDICATE, (LivingEntity)this.slime);
        if (this.closestPlayer == null) {
            return false;
        }
        return this.isTempting(this.closestPlayer.getMainHandItem()) || this.isTempting(this.closestPlayer.getOffhandItem());
    }

    protected boolean isTempting(ItemStack stack) {
        return this.slime.isFood(stack);
    }

    public boolean canContinueToUse() {
        if (this.isScaredByPlayerMovement()) {
            if (this.slime.distanceToSqr((Entity)this.closestPlayer) < 36.0) {
                if (this.closestPlayer.distanceToSqr(this.targetX, this.targetY, this.targetZ) > 0.010000000000000002) {
                    return false;
                }
                if (Math.abs((double)this.closestPlayer.getXRot() - this.pitch) > 5.0 || Math.abs((double)this.closestPlayer.getYRot() - this.yaw) > 5.0) {
                    return false;
                }
            } else {
                this.targetX = this.closestPlayer.getX();
                this.targetY = this.closestPlayer.getY();
                this.targetZ = this.closestPlayer.getZ();
            }
            this.pitch = this.closestPlayer.getXRot();
            this.yaw = this.closestPlayer.getYRot();
        }
        return this.canUse();
    }

    protected boolean isScaredByPlayerMovement() {
        return false;
    }

    public void start() {
        this.targetX = this.closestPlayer.getX();
        this.targetY = this.closestPlayer.getY();
        this.targetZ = this.closestPlayer.getZ();
    }

    public void stop() {
        this.closestPlayer = null;
        this.slime.getNavigation().stop();
        this.delayTemptCounter = 100;
    }

    public void tick() {
        this.slime.getLookControl().setLookAt((Entity)this.closestPlayer, (float)(this.slime.getMaxHeadYRot() + 20), (float)this.slime.getMaxHeadXRot());
        if (this.slime.distanceToSqr((Entity)this.closestPlayer) < 6.25) {
            this.slime.getNavigation().stop();
        } else {
            this.slime.lookAt((Entity)this.closestPlayer, 10.0f, 10.0f);
            ((HoneySlimeMoveController)this.slime.getMoveControl()).setDirection(this.slime.getYRot(), true);
            ((HoneySlimeMoveController)this.slime.getMoveControl()).setSpeed(1.0);
        }
    }
}

