/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.items;

import com.telepathicgrunt.the_bumblezone.blocks.blockentities.PotionCandleBlockEntity;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class PotionCandleBlockItem
extends BlockItem {
    public PotionCandleBlockItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    protected boolean updateCustomBlockEntityTag(BlockPos pos, Level level, Player player, ItemStack itemStack, BlockState state) {
        BlockEntity blockEntity;
        CustomData customData = (CustomData)itemStack.get(DataComponents.BLOCK_ENTITY_DATA);
        if (level.isClientSide() && customData != null && !customData.isEmpty() && (blockEntity = level.getBlockEntity(pos)) instanceof PotionCandleBlockEntity) {
            PotionCandleBlockEntity potionCandleBlockEntity = (PotionCandleBlockEntity)blockEntity;
            CompoundTag blockEntityTag = customData.copyTag();
            int color = blockEntityTag.contains("color") ? blockEntityTag.getInt("color") : 0xFFFFFF;
            potionCandleBlockEntity.setColor(color);
            ResourceLocation rl = ResourceLocation.tryParse((String)blockEntityTag.getString("status"));
            Optional optionalMobEffectReference = BuiltInRegistries.MOB_EFFECT.getHolder(rl);
            optionalMobEffectReference.ifPresent(potionCandleBlockEntity::setMobEffect);
        }
        return super.updateCustomBlockEntityTag(pos, level, player, itemStack, state);
    }

    public String getDescriptionId() {
        return this.getOrCreateDescriptionId();
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> components, TooltipFlag tooltipFlag) {
        ResourceLocation rl;
        Optional mobEffect;
        CompoundTag blockEntityTag;
        CustomData customData = (CustomData)itemStack.get(DataComponents.BLOCK_ENTITY_DATA);
        if (customData != null && !customData.isEmpty() && (blockEntityTag = customData.copyTag()).contains("status") && (mobEffect = BuiltInRegistries.MOB_EFFECT.getOptional(rl = ResourceLocation.tryParse((String)blockEntityTag.getString("status")))).isPresent()) {
            int lingerTime;
            components.add((Component)PotionCandleBlockItem.formatComponent(Component.translatable((String)"item.the_bumblezone.potion_candle.status_effect", (Object[])new Object[]{((MobEffect)mobEffect.get()).getDisplayName()})));
            components.add((Component)PotionCandleBlockItem.formatComponent(Component.translatable((String)"item.the_bumblezone.potion_candle.amplifier", (Object[])new Object[]{blockEntityTag.getInt("amplifier")})));
            components.add((Component)PotionCandleBlockItem.formatComponent(Component.translatable((String)"item.the_bumblezone.potion_candle.range", (Object[])new Object[]{blockEntityTag.getInt("range")})));
            if (blockEntityTag.contains("infinite") && blockEntityTag.getBoolean("infinite")) {
                components.add((Component)PotionCandleBlockItem.formatComponent(Component.translatable((String)"item.the_bumblezone.potion_candle.max_duration", (Object[])new Object[]{Component.translatable((String)"item.the_bumblezone.potion_candle.infinite")})));
            } else if (blockEntityTag.contains("max_duration")) {
                components.add((Component)PotionCandleBlockItem.formatComponent(Component.translatable((String)"item.the_bumblezone.potion_candle.max_duration", (Object[])new Object[]{PotionCandleBlockItem.formatTime(blockEntityTag.getInt("max_duration"))})));
            } else {
                components.add((Component)PotionCandleBlockItem.formatComponent(Component.translatable((String)"item.the_bumblezone.potion_candle.max_duration", (Object[])new Object[]{PotionCandleBlockItem.formatTime(12000L)})));
            }
            if (((MobEffect)mobEffect.get()).isInstantenous()) {
                components.add((Component)PotionCandleBlockItem.formatComponent(Component.translatable((String)"item.the_bumblezone.potion_candle.apply_interval", (Object[])new Object[]{PotionCandleBlockItem.formatTime(PotionCandleBlockEntity.getInstantEffectThresholdTime(blockEntityTag.getInt("amplifier")))})));
            }
            if ((lingerTime = blockEntityTag.getInt("linger_time")) > 20) {
                components.add((Component)PotionCandleBlockItem.formatComponent(Component.translatable((String)"item.the_bumblezone.potion_candle.lingering_time", (Object[])new Object[]{PotionCandleBlockItem.formatTime(lingerTime)})));
            }
        }
    }

    private static MutableComponent formatComponent(MutableComponent component) {
        return component.withStyle(ChatFormatting.ITALIC).withStyle(ChatFormatting.GRAY);
    }

    private static String formatTime(long duration) {
        long totalSeconds = duration / 20L;
        long minutes = totalSeconds / 60L;
        long seconds = totalSeconds % 60L;
        return String.format("%d:%02d", minutes, seconds);
    }
}

