/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.items.essence;

import com.telepathicgrunt.the_bumblezone.configs.BzGeneralConfigs;
import com.telepathicgrunt.the_bumblezone.events.entity.BzEntityDeathEvent;
import com.telepathicgrunt.the_bumblezone.items.datacomponents.AbilityEssenceActivityData;
import com.telepathicgrunt.the_bumblezone.items.datacomponents.RagingEssenceCurrentTargetData;
import com.telepathicgrunt.the_bumblezone.items.datacomponents.RagingEssenceStateData;
import com.telepathicgrunt.the_bumblezone.items.datacomponents.RagingEssenceTimerData;
import com.telepathicgrunt.the_bumblezone.items.essence.AbilityEssenceItem;
import com.telepathicgrunt.the_bumblezone.modinit.BzDataComponents;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class RagingEssence
extends AbilityEssenceItem {
    private static final Supplier<Integer> cooldownLengthInTicks = () -> BzGeneralConfigs.ragingEssenceCooldown;
    private static final Supplier<Integer> abilityUseAmount = () -> BzGeneralConfigs.ragingEssenceAbilityUse;
    private static final int radius = 24;
    private static final int trackingRange = 2304;
    private static final int maxEmpoweredTimeLimit = 375;
    private static final int maxCurrentTargets = 4;

    public RagingEssence(Item.Properties properties) {
        super(properties, cooldownLengthInTicks, abilityUseAmount);
    }

    @Override
    public void verifyComponentsAfterLoad(ItemStack itemStack) {
        if (itemStack.get((DataComponentType)BzDataComponents.RAGING_ESSENCE_STATE_DATA.get()) == null) {
            itemStack.set((DataComponentType)BzDataComponents.RAGING_ESSENCE_STATE_DATA.get(), (Object)new RagingEssenceStateData());
        }
        if (itemStack.get((DataComponentType)BzDataComponents.RAGING_ESSENCE_CURRENT_TARGET_DATA.get()) == null) {
            itemStack.set((DataComponentType)BzDataComponents.RAGING_ESSENCE_CURRENT_TARGET_DATA.get(), (Object)new RagingEssenceCurrentTargetData());
        }
        if (itemStack.get((DataComponentType)BzDataComponents.RAGING_ESSENCE_TIMER_DATA.get()) == null) {
            itemStack.set((DataComponentType)BzDataComponents.RAGING_ESSENCE_TIMER_DATA.get(), (Object)new RagingEssenceTimerData());
        }
        super.verifyComponentsAfterLoad(itemStack);
    }

    @Override
    public int getColor() {
        return 0xFF2B2B;
    }

    @Override
    void addDescriptionComponents(List<Component> components) {
        components.add((Component)Component.translatable((String)"item.the_bumblezone.essence_raging_description_1").withStyle(ChatFormatting.RED).withStyle(ChatFormatting.ITALIC));
        components.add((Component)Component.translatable((String)"item.the_bumblezone.essence_raging_description_2").withStyle(ChatFormatting.RED).withStyle(ChatFormatting.ITALIC));
    }

    public static void setRageState(ItemStack itemStack, short rageState) {
        itemStack.set((DataComponentType)BzDataComponents.RAGING_ESSENCE_STATE_DATA.get(), (Object)new RagingEssenceStateData(rageState));
    }

    public static short getRageState(ItemStack itemStack) {
        return ((RagingEssenceStateData)itemStack.get((DataComponentType)BzDataComponents.RAGING_ESSENCE_STATE_DATA.get())).rageStateLevel();
    }

    public static void setEmpoweredTimestamp(ItemStack itemStack, long empoweredTimestamp) {
        itemStack.set((DataComponentType)BzDataComponents.RAGING_ESSENCE_TIMER_DATA.get(), (Object)new RagingEssenceTimerData(empoweredTimestamp));
    }

    public static long getEmpoweredTimestamp(ItemStack itemStack) {
        return ((RagingEssenceTimerData)itemStack.get((DataComponentType)BzDataComponents.RAGING_ESSENCE_TIMER_DATA.get())).empoweredTimestamp();
    }

    public static void setCurrentTargets(ItemStack itemStack, List<UUID> targetsToKill) {
        itemStack.set((DataComponentType)BzDataComponents.RAGING_ESSENCE_CURRENT_TARGET_DATA.get(), (Object)new RagingEssenceCurrentTargetData(targetsToKill));
    }

    public static List<UUID> getCurrentTargets(ItemStack itemStack) {
        return new ArrayList<UUID>(((RagingEssenceCurrentTargetData)itemStack.get((DataComponentType)BzDataComponents.RAGING_ESSENCE_CURRENT_TARGET_DATA.get())).currentTargets());
    }

    @Override
    public void applyAbilityEffects(ItemStack itemStack, Level level, ServerPlayer serverPlayer) {
        AbilityEssenceActivityData abilityEssenceActivityData = (AbilityEssenceActivityData)itemStack.get((DataComponentType)BzDataComponents.ABILITY_ESSENCE_ACTIVITY_DATA.get());
        if (abilityEssenceActivityData.isActive() && BzGeneralConfigs.ragingEssenceStrengthLevels.length > 0) {
            short rageState = RagingEssence.getRageState(itemStack);
            if (rageState > BzGeneralConfigs.ragingEssenceStrengthLevels.length) {
                RagingEssence.setRageState(itemStack, (short)BzGeneralConfigs.ragingEssenceStrengthLevels.length);
                rageState = (short)BzGeneralConfigs.ragingEssenceStrengthLevels.length;
            }
            if (rageState > 0 && ((long)serverPlayer.tickCount + serverPlayer.getUUID().getLeastSignificantBits()) % 5L == 0L) {
                RagingEssence.spawnParticles(serverPlayer.serverLevel(), serverPlayer.position(), serverPlayer.getRandom(), rageState);
                if (level.getGameTime() - RagingEssence.getEmpoweredTimestamp(itemStack) > 375L) {
                    RagingEssence.resetRage(itemStack, serverPlayer);
                    if (this.decrementAbilityUseRemaining(itemStack, serverPlayer, 1)) {
                        return;
                    }
                }
            }
            if (((long)serverPlayer.tickCount + serverPlayer.getUUID().getLeastSignificantBits()) % 20L == 0L) {
                Object entities;
                List<UUID> currentTargetsToKill = RagingEssence.getCurrentTargets(itemStack);
                if (currentTargetsToKill.size() < 4 && rageState + currentTargetsToKill.size() <= BzGeneralConfigs.ragingEssenceStrengthLevels.length && !(entities = level.getEntities((Entity)serverPlayer, new AABB(serverPlayer.getX() - 24.0, serverPlayer.getY() - 6.0, serverPlayer.getZ() - 24.0, serverPlayer.getX() + 24.0, serverPlayer.getY() + 6.0, serverPlayer.getZ() + 24.0), e -> !currentTargetsToKill.contains(e.getUUID()) && RagingEssence.isTargetable(e, serverPlayer.getUUID()))).isEmpty() && currentTargetsToKill.size() < 4) {
                    int entitiesToAdd;
                    entities.sort((e1, e2) -> (int)(((LivingEntity)e1).getHealth() - ((LivingEntity)e2).getHealth()));
                    int rageLeft = BzGeneralConfigs.ragingEssenceStrengthLevels.length - rageState;
                    for (int i = entitiesToAdd = Math.min(rageLeft + 1, 4) - currentTargetsToKill.size(); i >= 1 && !entities.isEmpty(); --i) {
                        if (i == 1) {
                            currentTargetsToKill.add(((Entity)entities.remove(entities.size() - 1)).getUUID());
                            continue;
                        }
                        currentTargetsToKill.add(((Entity)entities.remove(0)).getUUID());
                    }
                    RagingEssence.setCurrentTargets(itemStack, currentTargetsToKill);
                    return;
                }
                if (!currentTargetsToKill.isEmpty()) {
                    for (UUID uuid : currentTargetsToKill) {
                        Entity entity = serverPlayer.serverLevel().getEntity(uuid);
                        if (entity != null && !(entity.distanceToSqr(serverPlayer.position()) > 5308416.0)) continue;
                        RagingEssence.resetRage(itemStack, serverPlayer);
                        return;
                    }
                }
                if (rageState > 0) {
                    List<Holder> radianceEffects = BuiltInRegistries.MOB_EFFECT.getTag(BzTags.RAGING_RAGE_EFFECTS).stream().flatMap(HolderSet.ListBacked::stream).filter(Holder::isBound).toList();
                    for (Holder effectHolder : radianceEffects) {
                        if (effectHolder.value() == MobEffects.DAMAGE_BOOST) {
                            serverPlayer.addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, (int)((level.getGameTime() - RagingEssence.getEmpoweredTimestamp(itemStack)) * 4L), BzGeneralConfigs.ragingEssenceStrengthLevels[rageState - 1] - 1, false, false));
                            continue;
                        }
                        serverPlayer.addEffect(new MobEffectInstance(effectHolder, (int)((level.getGameTime() - RagingEssence.getEmpoweredTimestamp(itemStack)) * 4L), (int)rageState, false, false));
                    }
                }
            }
        }
    }

    public static void OnEntityDeath(BzEntityDeathEvent event) {
        DamageSource damageSource = event.source();
        LivingEntity livingEntity = event.entity();
        Entity entity = damageSource.getEntity();
        if (entity instanceof ServerPlayer) {
            Item item;
            ServerPlayer player = (ServerPlayer)entity;
            ItemStack itemStack = player.getOffhandItem();
            AbilityEssenceActivityData abilityEssenceActivityData = (AbilityEssenceActivityData)itemStack.get((DataComponentType)BzDataComponents.ABILITY_ESSENCE_ACTIVITY_DATA.get());
            if (livingEntity.isDeadOrDying() && (item = itemStack.getItem()) instanceof RagingEssence) {
                RagingEssence ragingEssence = (RagingEssence)item;
                if (abilityEssenceActivityData.isActive() && !player.getCooldowns().isOnCooldown(itemStack.getItem())) {
                    List<UUID> currentTargetsToKill = RagingEssence.getCurrentTargets(itemStack);
                    short rageState = RagingEssence.getRageState(itemStack);
                    if (rageState == BzGeneralConfigs.ragingEssenceStrengthLevels.length || currentTargetsToKill.contains(livingEntity.getUUID())) {
                        if (rageState >= BzGeneralConfigs.ragingEssenceStrengthLevels.length) {
                            RagingEssence.resetRage(itemStack, player);
                        } else {
                            RagingEssence.setRageState(itemStack, (short)(rageState + 1));
                            RagingEssence.setEmpoweredTimestamp(itemStack, livingEntity.level().getGameTime());
                            currentTargetsToKill.remove(livingEntity.getUUID());
                            RagingEssence.setCurrentTargets(itemStack, currentTargetsToKill);
                            ragingEssence.decrementAbilityUseRemaining(itemStack, player, 1);
                        }
                    }
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isTargetable(Entity entity, UUID playerUUID) {
        if (!(entity instanceof LivingEntity)) return false;
        LivingEntity livingEntity = (LivingEntity)entity;
        if (entity.isInvulnerable()) return false;
        if (!livingEntity.attackable()) return false;
        if (livingEntity.isDeadOrDying()) return false;
        if (entity instanceof Enemy) return true;
        if (!(entity instanceof NeutralMob)) return false;
        NeutralMob neutralMob = (NeutralMob)entity;
        if (neutralMob.getPersistentAngerTarget() != playerUUID) return false;
        return true;
    }

    private static void resetRage(ItemStack stack, ServerPlayer serverPlayer) {
        RagingEssence.setCurrentTargets(stack, new ArrayList<UUID>());
        RagingEssence.setRageState(stack, (short)0);
        List<Holder> radianceEffects = BuiltInRegistries.MOB_EFFECT.getTag(BzTags.RAGING_RAGE_EFFECTS).stream().flatMap(HolderSet.ListBacked::stream).filter(Holder::isBound).toList();
        for (Holder effectHolder : radianceEffects) {
            serverPlayer.removeEffect(effectHolder);
        }
        serverPlayer.serverLevel().sendParticles((ParticleOptions)ParticleTypes.POOF, serverPlayer.position().x(), serverPlayer.position().y() + 1.0, serverPlayer.position().z(), 50, serverPlayer.getRandom().nextGaussian() * 0.3, serverPlayer.getRandom().nextGaussian() * 0.25 + 0.1, serverPlayer.getRandom().nextGaussian() * 0.3, (double)0.06f);
    }

    public static void spawnParticles(ServerLevel world, Vec3 location, RandomSource random, int rageState) {
        if (rageState == BzGeneralConfigs.ragingEssenceStrengthLevels.length) {
            rageState *= 2;
        }
        world.sendParticles((ParticleOptions)ParticleTypes.FLAME, location.x(), location.y() + 1.0, location.z(), rageState, random.nextGaussian() * 0.2, random.nextGaussian() * 0.25 + 0.1, random.nextGaussian() * 0.2, (double)0.02f);
        world.sendParticles((ParticleOptions)ParticleTypes.CRIT, location.x(), location.y() + 1.0, location.z(), rageState, random.nextGaussian() * 0.2, random.nextGaussian() * 0.25 + 0.1, random.nextGaussian() * 0.2, (double)0.1f);
    }

    public static boolean IsRagingEssenceActive(Player player) {
        if (player != null) {
            ItemStack offHandItem = player.getOffhandItem();
            return offHandItem.is((Item)BzItems.ESSENCE_RAGING.get()) && ((AbilityEssenceActivityData)offHandItem.get((DataComponentType)BzDataComponents.ABILITY_ESSENCE_ACTIVITY_DATA.get())).isActive() && !player.getCooldowns().isOnCooldown(offHandItem.getItem());
        }
        return false;
    }

    public static boolean IsValidEntityToGlow(Entity entity, Player player) {
        return RagingEssence.GetTeamColor(entity, player) != -1;
    }

    public static int GetTeamColor(Entity entity, Player player) {
        ItemStack stack = player.getOffhandItem();
        short rageState = RagingEssence.getRageState(stack);
        List<UUID> currentTargetsToKill = RagingEssence.getCurrentTargets(stack);
        if (rageState == BzGeneralConfigs.ragingEssenceStrengthLevels.length && RagingEssence.isTargetable(entity, player.getUUID()) || currentTargetsToKill.contains(entity.getUUID())) {
            if (rageState == BzGeneralConfigs.ragingEssenceStrengthLevels.length) {
                float percentage = Math.abs((float)(player.tickCount % 40 - 20) / 20.0f);
                int red = 255;
                int green = Mth.lerpInt((float)percentage, (int)0, (int)128);
                return (red & 0xFF) << 16 | (green & 0xFF) << 8;
            }
            float percentage = (float)rageState / (float)BzGeneralConfigs.ragingEssenceStrengthLevels.length;
            return Mth.lerpInt((float)percentage, (int)85, (int)255) << 16;
        }
        return -1;
    }
}

