/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.items.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.the_bumblezone.modinit.BzRecipes;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class NbtKeepingShapelessRecipe
implements CraftingRecipe {
    private final String group;
    private final CraftingBookCategory category;
    private final ItemStack result;
    private final NonNullList<Ingredient> ingredients;
    private final Item itemToKeepNbtOf;

    public NbtKeepingShapelessRecipe(String string, CraftingBookCategory craftingBookCategory, ItemStack itemStack, NonNullList<Ingredient> nonNullList, Item itemToKeepNbtOf) {
        this.group = string;
        this.category = craftingBookCategory;
        this.result = itemStack;
        this.ingredients = nonNullList;
        this.itemToKeepNbtOf = itemToKeepNbtOf;
    }

    public String getGroup() {
        return this.group;
    }

    public CraftingBookCategory category() {
        return this.category;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.result;
    }

    public NonNullList<Ingredient> getIngredients() {
        return this.ingredients;
    }

    public boolean matches(CraftingInput craftingContainer, Level level) {
        StackedContents stackedContents = new StackedContents();
        int i = 0;
        for (int j = 0; j < craftingContainer.size(); ++j) {
            ItemStack itemStack = craftingContainer.getItem(j);
            if (itemStack.isEmpty()) continue;
            ++i;
            stackedContents.accountStack(itemStack, 1);
        }
        return i == this.ingredients.size() && stackedContents.canCraft((Recipe)this, null);
    }

    public boolean canCraftInDimensions(int i, int j) {
        return i * j >= this.ingredients.size();
    }

    public ItemStack assemble(CraftingInput craftingContainer, HolderLookup.Provider provider) {
        ItemStack resultItem = this.result.copy();
        for (ItemStack input : craftingContainer.items()) {
            if (!input.is(this.itemToKeepNbtOf)) continue;
            resultItem = input.transmuteCopy((ItemLike)resultItem.getItem(), 1);
            break;
        }
        return resultItem;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)BzRecipes.NBT_KEEPING_SHAPELESS_RECIPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<NbtKeepingShapelessRecipe> {
        private static final MapCodec<NbtKeepingShapelessRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("group").forGetter(shapelessRecipe -> shapelessRecipe.group), (App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(shapelessRecipe -> shapelessRecipe.category), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(shapelessRecipe -> shapelessRecipe.result), (App)Ingredient.CODEC_NONEMPTY.listOf().fieldOf("ingredients").flatXmap(list -> {
            Object[] ingredients = (Ingredient[])list.toArray(Ingredient[]::new);
            if (ingredients.length == 0) {
                return DataResult.error(() -> "No ingredients for shapeless recipe");
            }
            return DataResult.success((Object)NonNullList.of((Object)Ingredient.EMPTY, (Object[])ingredients));
        }, DataResult::success).forGetter(shapelessRecipe -> shapelessRecipe.ingredients), (App)BuiltInRegistries.ITEM.byNameCodec().fieldOf("keep_nbt_of").forGetter(shapelessRecipe -> shapelessRecipe.itemToKeepNbtOf)).apply((Applicative)instance, NbtKeepingShapelessRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, NbtKeepingShapelessRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<NbtKeepingShapelessRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, NbtKeepingShapelessRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        public static NbtKeepingShapelessRecipe fromNetwork(RegistryFriendlyByteBuf friendlyByteBuf) {
            String string = friendlyByteBuf.readUtf();
            CraftingBookCategory craftingBookCategory = (CraftingBookCategory)friendlyByteBuf.readEnum(CraftingBookCategory.class);
            int ingredientCount = friendlyByteBuf.readVarInt();
            NonNullList ingredientNonNullList = NonNullList.withSize((int)ingredientCount, (Object)Ingredient.EMPTY);
            ingredientNonNullList.replaceAll(ignored -> (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)friendlyByteBuf));
            ItemStack itemStack = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)friendlyByteBuf);
            Item item = ((ItemStack)ItemStack.STREAM_CODEC.decode((Object)friendlyByteBuf)).getItem();
            return new NbtKeepingShapelessRecipe(string, craftingBookCategory, itemStack, (NonNullList<Ingredient>)ingredientNonNullList, item);
        }

        public static void toNetwork(RegistryFriendlyByteBuf friendlyByteBuf, NbtKeepingShapelessRecipe shapelessRecipe) {
            friendlyByteBuf.writeUtf(shapelessRecipe.getGroup());
            friendlyByteBuf.writeEnum((Enum)shapelessRecipe.category());
            friendlyByteBuf.writeVarInt(shapelessRecipe.getIngredients().size());
            for (Ingredient ingredient : shapelessRecipe.getIngredients()) {
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)friendlyByteBuf, (Object)ingredient);
            }
            ItemStack.STREAM_CODEC.encode((Object)friendlyByteBuf, (Object)shapelessRecipe.getResultItem((HolderLookup.Provider)RegistryAccess.EMPTY));
            ItemStack.STREAM_CODEC.encode((Object)friendlyByteBuf, (Object)shapelessRecipe.itemToKeepNbtOf.getDefaultInstance());
        }
    }
}

