/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.mixin.entities;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.sugar.Local;
import com.teamresourceful.resourcefullib.common.fluid.data.FluidData;
import com.telepathicgrunt.the_bumblezone.blocks.EmptyHoneycombBrood;
import com.telepathicgrunt.the_bumblezone.blocks.FilledPorousHoneycomb;
import com.telepathicgrunt.the_bumblezone.blocks.PorousHoneycomb;
import com.telepathicgrunt.the_bumblezone.items.StinglessBeeHelmet;
import com.telepathicgrunt.the_bumblezone.items.essence.CalmingEssence;
import com.telepathicgrunt.the_bumblezone.loot.EntityLootDropInterface;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzFluids;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.utils.PlatformHooks;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class}, priority=1200)
public abstract class EntityMixin
implements EntityLootDropInterface {
    @Unique
    public boolean thebumblezone_performedEntityDrops = false;

    @Override
    public boolean thebumblezone_hasPerformedEntityDrops() {
        return this.thebumblezone_performedEntityDrops;
    }

    @Override
    public void thebumblezone_performedEntityDrops() {
        this.thebumblezone_performedEntityDrops = true;
    }

    @Shadow
    public abstract AABB getBoundingBox();

    @Shadow
    public abstract Level level();

    @ModifyReturnValue(method={"getVehicleAttachmentPoint(Lnet/minecraft/world/entity/Entity;)Lnet/minecraft/world/phys/Vec3;"}, at={@At(value="RETURN")}, require=0)
    private Vec3 bumblezone$beeRidingOffset(Vec3 original, @Local(index=0, argsOnly=true) Entity vehicle) {
        return StinglessBeeHelmet.beeRidingOffset(original, vehicle, (Entity)this);
    }

    @ModifyReturnValue(method={"updateFluidHeightAndDoFluidPushing(Lnet/minecraft/tags/TagKey;D)Z"}, at={@At(value="RETURN")}, require=0)
    private boolean bumblezone$applyMissingWaterPhysicsForSugarWaterFluid(boolean appliedFluidPush) {
        if (!appliedFluidPush) {
            return PlatformHooks.getFluidHeight((Entity)this, BzTags.SUGAR_WATER_FLUID, (FluidData)BzFluids.SUGAR_WATER_FLUID_TYPE.get()) > 0.0;
        }
        return true;
    }

    @Inject(method={"checkInsideBlocks()V"}, at={@At(value="HEAD")})
    private void bumblezone$pollinatedBeeBlockFilling(CallbackInfo ci) {
        Bee bee;
        EntityMixin entityMixin = this;
        if (entityMixin instanceof Bee && ((bee = (Bee)entityMixin).hasNectar() || bee.getHealth() < bee.getMaxHealth())) {
            AABB aABB = this.getBoundingBox();
            BlockPos minBlockPos = BlockPos.containing((double)(aABB.minX - 1.0E-7), (double)(aABB.minY - 1.0E-7), (double)(aABB.minZ - 1.0E-7));
            BlockPos maxBlockPos = BlockPos.containing((double)(aABB.maxX + 1.0E-7), (double)(aABB.maxY + 1.0E-7), (double)(aABB.maxZ + 1.0E-7));
            BlockPos minThreshold = BlockPos.containing((double)(aABB.minX + 1.0E-7), (double)(aABB.minY + 1.0E-7), (double)(aABB.minZ + 1.0E-7));
            BlockPos maxThreshold = BlockPos.containing((double)(aABB.maxX - 1.0E-7), (double)(aABB.maxY - 1.0E-7), (double)(aABB.maxZ - 1.0E-7));
            if (this.level().hasChunksAt(minThreshold, maxThreshold)) {
                BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
                for (int x = minBlockPos.getX(); x <= maxBlockPos.getX(); ++x) {
                    for (int y = minBlockPos.getY(); y <= maxBlockPos.getY(); ++y) {
                        for (int z = minBlockPos.getZ(); z <= maxBlockPos.getZ(); ++z) {
                            int sideCheckPassed = 0;
                            if (x < minThreshold.getX()) {
                                ++sideCheckPassed;
                            }
                            if (y < minThreshold.getY()) {
                                ++sideCheckPassed;
                            }
                            if (z < minThreshold.getZ()) {
                                ++sideCheckPassed;
                            }
                            if (x > maxThreshold.getX()) {
                                ++sideCheckPassed;
                            }
                            if (y > maxThreshold.getY()) {
                                ++sideCheckPassed;
                            }
                            if (z > maxThreshold.getZ()) {
                                ++sideCheckPassed;
                            }
                            if (sideCheckPassed != 1) continue;
                            mutableBlockPos.set(x, y, z);
                            BlockState blockState = this.level().getBlockState((BlockPos)mutableBlockPos);
                            if (blockState.is((Block)BzBlocks.POROUS_HONEYCOMB.get())) {
                                PorousHoneycomb.beeHoneyFill(blockState, this.level(), (BlockPos)mutableBlockPos, (Entity)this);
                                continue;
                            }
                            if (blockState.is((Block)BzBlocks.FILLED_POROUS_HONEYCOMB.get())) {
                                FilledPorousHoneycomb.beeHoneyTake(blockState, this.level(), (BlockPos)mutableBlockPos, (Entity)this);
                                continue;
                            }
                            if (!blockState.is((Block)BzBlocks.EMPTY_HONEYCOMB_BROOD.get())) continue;
                            EmptyHoneycombBrood.beeHoneyFill(blockState, this.level(), (BlockPos)mutableBlockPos, (Entity)this);
                        }
                    }
                }
            }
        }
    }

    @Inject(method={"isAlliedTo(Lnet/minecraft/world/entity/Entity;)Z"}, at={@At(value="RETURN")}, cancellable=true)
    private void bumblezone$preventAngerableAtPlayer2(Entity comparer, CallbackInfoReturnable<Boolean> cir) {
        Entity current = (Entity)this;
        if (current instanceof Mob || comparer instanceof Mob) {
            Player player;
            Player player2;
            if (current instanceof Player && CalmingEssence.IsCalmingEssenceActive(player2 = (Player)current)) {
                if (!comparer.getType().is(BzTags.CALMING_ALLOW_ANGER_THROUGH)) {
                    cir.setReturnValue((Object)false);
                }
            } else if (comparer instanceof Player && CalmingEssence.IsCalmingEssenceActive(player = (Player)comparer) && !current.getType().is(BzTags.CALMING_ALLOW_ANGER_THROUGH)) {
                cir.setReturnValue((Object)false);
            }
        }
    }
}

