/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.modcompat.neoforge;

import com.blakebr0.ironjetpacks.util.JetpackUtils;
import com.telepathicgrunt.the_bumblezone.modcompat.ModChecker;
import com.telepathicgrunt.the_bumblezone.modcompat.ModCompat;
import java.util.EnumSet;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class IronJetpacksCompat
implements ModCompat {
    public IronJetpacksCompat() {
        ModChecker.ironJetpacksPresent = true;
    }

    @Override
    public EnumSet<ModCompat.Type> compatTypes() {
        return EnumSet.of(ModCompat.Type.HEAVY_AIR_RESTRICTED);
    }

    @Override
    public void restrictFlight(Entity entity, double extraGravity) {
        Player player;
        ItemStack jetpack;
        if (entity instanceof Player && !(jetpack = JetpackUtils.getEquippedJetpack((Player)(player = (Player)entity))).isEmpty()) {
            ServerPlayer serverPlayer;
            if (JetpackUtils.isEngineOn((ItemStack)jetpack)) {
                JetpackUtils.toggleEngine((ItemStack)jetpack);
                if (player instanceof ServerPlayer) {
                    serverPlayer = (ServerPlayer)player;
                    serverPlayer.displayClientMessage((Component)Component.translatable((String)"system.the_bumblezone.denied_jetpack").withStyle(ChatFormatting.ITALIC).withStyle(ChatFormatting.RED), true);
                }
            }
            if (!player.getCooldowns().isOnCooldown(jetpack.getItem()) && player instanceof ServerPlayer) {
                serverPlayer = (ServerPlayer)player;
                serverPlayer.displayClientMessage((Component)Component.translatable((String)"system.the_bumblezone.denied_jetpack").withStyle(ChatFormatting.ITALIC).withStyle(ChatFormatting.RED), true);
            }
            player.getCooldowns().addCooldown(jetpack.getItem(), 40);
        }
    }
}

