/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.modcompat.neoforge;

import com.mojang.datafixers.util.Function6;
import com.telepathicgrunt.the_bumblezone.blocks.EmptyHoneycombBrood;
import com.telepathicgrunt.the_bumblezone.blocks.HoneycombBrood;
import com.telepathicgrunt.the_bumblezone.configs.BzGeneralConfigs;
import com.telepathicgrunt.the_bumblezone.configs.BzModCompatibilityConfigs;
import com.telepathicgrunt.the_bumblezone.events.entity.BzProjectileHitEvent;
import com.telepathicgrunt.the_bumblezone.mixin.blocks.DispenserBlockInvoker;
import com.telepathicgrunt.the_bumblezone.modcompat.BroodBlockModdedCompatDispenseBehavior;
import com.telepathicgrunt.the_bumblezone.modcompat.ModChecker;
import com.telepathicgrunt.the_bumblezone.modcompat.ModCompat;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import java.util.EnumSet;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.entity.DispenserBlockEntity;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class PotionOfBeesCompat
implements ModCompat {
    private static Optional<EntityType<?>> SPLASH_POTION_OF_BEES_ENTITY;
    private static Optional<EntityType<?>> LINGERING_POTION_OF_BEES_ENTITY;
    private static Optional<Item> POTION_OF_BEES;
    private static Optional<Item> SPLASH_POTION_OF_BEES;
    private static Optional<Item> LINGERING_POTION_OF_BEES;

    public PotionOfBeesCompat() {
        POTION_OF_BEES = BuiltInRegistries.ITEM.getOptional(ResourceLocation.fromNamespaceAndPath((String)"potionofbees", (String)"potion_of_bees"));
        SPLASH_POTION_OF_BEES = BuiltInRegistries.ITEM.getOptional(ResourceLocation.fromNamespaceAndPath((String)"potionofbees", (String)"splash_potion_of_bees"));
        LINGERING_POTION_OF_BEES = BuiltInRegistries.ITEM.getOptional(ResourceLocation.fromNamespaceAndPath((String)"potionofbees", (String)"lingering_potion_of_bees"));
        SPLASH_POTION_OF_BEES_ENTITY = BuiltInRegistries.ENTITY_TYPE.getOptional(ResourceLocation.fromNamespaceAndPath((String)"potionofbees", (String)"splash_potion_of_bees"));
        LINGERING_POTION_OF_BEES_ENTITY = BuiltInRegistries.ENTITY_TYPE.getOptional(ResourceLocation.fromNamespaceAndPath((String)"potionofbees", (String)"lingering_potion_of_bees"));
        if (POTION_OF_BEES.isPresent() && BzModCompatibilityConfigs.allowPotionOfBeesRevivingEmptyBroodBlock) {
            PotionOfBeesCompat.setupDispenserCompat(POTION_OF_BEES.get());
        }
        if (SPLASH_POTION_OF_BEES.isPresent() && BzModCompatibilityConfigs.allowPotionOfBeesRevivingEmptyBroodBlock) {
            PotionOfBeesCompat.setupDispenserCompat(SPLASH_POTION_OF_BEES.get());
        }
        if (LINGERING_POTION_OF_BEES.isPresent() && BzModCompatibilityConfigs.allowPotionOfBeesRevivingEmptyBroodBlock) {
            PotionOfBeesCompat.setupDispenserCompat(LINGERING_POTION_OF_BEES.get());
        }
        BzProjectileHitEvent.EVENT.addListener(PotionOfBeesCompat::onProjectileHit);
        ModChecker.potionOfBeesPresent = true;
    }

    private static void setupDispenserCompat(Item containerItem) {
        BroodBlockModdedCompatDispenseBehavior newDispenseBehavior = new BroodBlockModdedCompatDispenseBehavior(DispenserBlockInvoker.bumblezone$getDISPENSER_REGISTRY().get(containerItem), (Function6<DispenseItemBehavior, BlockSource, ItemStack, ServerLevel, BlockPos, BlockState, ItemStack>)((Function6)(originalModdedDispenseBehavior, blockSource, itemStack, serverLevel, blockPos, blockState) -> {
            if (PotionOfBeesCompat.isLingeringPotionOfBeesItem(itemStack)) {
                PotionOfBeesCompat.reviveBroodsInRange((Level)serverLevel, blockPos, 3);
            } else if (PotionOfBeesCompat.isSplashPotionOfBeesItem(itemStack)) {
                PotionOfBeesCompat.reviveBroodsInRange((Level)serverLevel, blockPos, 1);
            } else {
                serverLevel.setBlockAndUpdate(blockPos, (BlockState)((BlockState)((Block)BzBlocks.HONEYCOMB_BROOD.get()).defaultBlockState().setValue((Property)HoneycombBrood.FACING, (Comparable)((Direction)blockState.getValue((Property)EmptyHoneycombBrood.FACING)))).setValue((Property)HoneycombBrood.STAGE, (Comparable)Integer.valueOf(3)));
            }
            itemStack.shrink(1);
            if (!BzGeneralConfigs.dispensersDropGlassBottles) {
                if (!itemStack.isEmpty()) {
                    ItemStack honeyBottle;
                    DispenserBlockEntity dispenser;
                    if (blockSource.blockEntity() instanceof DispenserBlockEntity && !HopperBlockEntity.addItem(null, (Container)(dispenser = blockSource.blockEntity()), (ItemStack)(honeyBottle = new ItemStack((ItemLike)Items.GLASS_BOTTLE)), null).isEmpty()) {
                        BroodBlockModdedCompatDispenseBehavior.DEFAULT_DROP_ITEM_BEHAVIOR.dispense(blockSource, honeyBottle);
                    }
                } else {
                    itemStack = new ItemStack((ItemLike)Items.GLASS_BOTTLE);
                }
            } else {
                BroodBlockModdedCompatDispenseBehavior.DEFAULT_DROP_ITEM_BEHAVIOR.dispense(blockSource, new ItemStack((ItemLike)Items.GLASS_BOTTLE));
            }
            return itemStack;
        }));
        DispenserBlock.registerBehavior((ItemLike)containerItem, (DispenseItemBehavior)newDispenseBehavior);
    }

    @Override
    public EnumSet<ModCompat.Type> compatTypes() {
        return EnumSet.of(ModCompat.Type.EMPTY_BROOD);
    }

    public static boolean isPotionOfBeesItem(ItemStack itemStack) {
        return POTION_OF_BEES.isPresent() && itemStack.is(POTION_OF_BEES.get());
    }

    public static boolean isSplashPotionOfBeesItem(ItemStack itemStack) {
        return SPLASH_POTION_OF_BEES.isPresent() && itemStack.is(SPLASH_POTION_OF_BEES.get());
    }

    public static boolean isLingeringPotionOfBeesItem(ItemStack itemStack) {
        return LINGERING_POTION_OF_BEES.isPresent() && itemStack.is(LINGERING_POTION_OF_BEES.get());
    }

    private static void onProjectileHit(boolean cancelled, BzProjectileHitEvent event) {
        if (BzModCompatibilityConfigs.allowPotionOfBeesRevivingEmptyBroodBlock && event.projectile() != null) {
            if (SPLASH_POTION_OF_BEES_ENTITY.isPresent() && event.projectile().getType() == SPLASH_POTION_OF_BEES_ENTITY.get()) {
                PotionOfBeesCompat.reviveLarvaBlockEvent(event.projectile(), event.hitResult(), 1);
            } else if (LINGERING_POTION_OF_BEES_ENTITY.isPresent() && event.projectile().getType() == LINGERING_POTION_OF_BEES_ENTITY.get()) {
                PotionOfBeesCompat.reviveLarvaBlockEvent(event.projectile(), event.hitResult(), 3);
            }
        }
    }

    private static void reviveLarvaBlockEvent(Projectile projectile, HitResult rayTraceResult, int range) {
        Level world = projectile.level();
        Vec3 hitBlockPos = rayTraceResult.getLocation();
        BlockPos originalPosition = BlockPos.containing((Position)hitBlockPos);
        PotionOfBeesCompat.reviveBroodsInRange(world, originalPosition, range);
    }

    @Override
    public InteractionResult onEmptyBroodInteract(ItemStack itemstack, Player playerEntity, InteractionHand playerHand) {
        if (!BzModCompatibilityConfigs.allowPotionOfBeesRevivingEmptyBroodBlock) {
            return InteractionResult.PASS;
        }
        if (PotionOfBeesCompat.isPotionOfBeesItem(itemstack) && !playerEntity.isCrouching()) {
            if (!playerEntity.isCreative()) {
                playerEntity.setItemInHand(playerHand, new ItemStack((ItemLike)Items.GLASS_BOTTLE));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static void reviveBroodsInRange(Level world, BlockPos originalPosition, int range) {
        BlockPos.MutableBlockPos position = new BlockPos.MutableBlockPos().set((Vec3i)originalPosition);
        for (int x = -range; x <= range; ++x) {
            for (int y = -range; y <= range; ++y) {
                for (int z = -range; z <= range; ++z) {
                    position.set((Vec3i)originalPosition).move(x, y, z);
                    BlockState block = world.getBlockState((BlockPos)position);
                    if (!block.getBlock().equals(BzBlocks.EMPTY_HONEYCOMB_BROOD.get())) continue;
                    PotionOfBeesCompat.reviveLarvaBlock(world, block, (BlockPos)position);
                }
            }
        }
    }

    private static void reviveLarvaBlock(Level world, BlockState state, BlockPos position) {
        world.setBlockAndUpdate(position, (BlockState)((BlockState)((Block)BzBlocks.HONEYCOMB_BROOD.get()).defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)((Direction)state.getValue((Property)BlockStateProperties.FACING)))).setValue((Property)HoneycombBrood.STAGE, (Comparable)Integer.valueOf(3 - world.random.nextInt(world.random.nextInt(world.random.nextInt(4) + 1) + 1))));
    }
}

