/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.utils;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.LevelAccessor;

public class BzPlacingUtils {
    public static int topOfSurfaceBelowHeight(LevelAccessor world, int startHeight, int minHeight, BlockPos position) {
        BlockPos.MutableBlockPos blockpos$Mutable = new BlockPos.MutableBlockPos(position.getX(), startHeight, position.getZ());
        while (blockpos$Mutable.getY() > minHeight && !world.isEmptyBlock((BlockPos)blockpos$Mutable)) {
            blockpos$Mutable.move(Direction.DOWN);
        }
        while (blockpos$Mutable.getY() > minHeight && world.isEmptyBlock((BlockPos)blockpos$Mutable)) {
            blockpos$Mutable.move(Direction.DOWN);
        }
        return blockpos$Mutable.getY();
    }

    public static int topOfSurfaceBelowHeightThroughWater(LevelAccessor world, int startHeight, int minHeight, BlockPos position) {
        BlockPos.MutableBlockPos blockpos$Mutable = new BlockPos.MutableBlockPos(position.getX(), startHeight, position.getZ());
        while (blockpos$Mutable.getY() > minHeight && !world.isEmptyBlock((BlockPos)blockpos$Mutable) && !world.getBlockState((BlockPos)blockpos$Mutable).getFluidState().is(FluidTags.WATER)) {
            blockpos$Mutable.move(Direction.DOWN);
        }
        while (blockpos$Mutable.getY() > minHeight && (world.isEmptyBlock((BlockPos)blockpos$Mutable) || world.getBlockState((BlockPos)blockpos$Mutable).getFluidState().is(FluidTags.WATER))) {
            blockpos$Mutable.move(Direction.DOWN);
        }
        return blockpos$Mutable.getY();
    }

    public static int topOfCeilingAboveHeight(LevelAccessor world, int startHeight, BlockPos position) {
        BlockPos.MutableBlockPos blockpos$Mutable = new BlockPos.MutableBlockPos(position.getX(), startHeight, position.getZ());
        while (blockpos$Mutable.getY() < 255 && !world.isEmptyBlock((BlockPos)blockpos$Mutable)) {
            blockpos$Mutable.move(Direction.UP);
        }
        while (blockpos$Mutable.getY() > 255 && world.isEmptyBlock((BlockPos)blockpos$Mutable)) {
            blockpos$Mutable.move(Direction.UP);
        }
        return Math.min(blockpos$Mutable.getY(), 255);
    }

    public static int topOfUnderwaterSurfaceBelowHeight(LevelAccessor world, int startHeight, BlockPos position) {
        BlockPos.MutableBlockPos blockpos$Mutable = new BlockPos.MutableBlockPos(position.getX(), startHeight, position.getZ());
        while (!(blockpos$Mutable.getY() <= 74 || world.isEmptyBlock((BlockPos)blockpos$Mutable) || world.getBlockState((BlockPos)blockpos$Mutable).getFluidState().is(FluidTags.WATER) && !world.getBlockState((BlockPos)blockpos$Mutable).is(BlockTags.REPLACEABLE_BY_TREES))) {
            blockpos$Mutable.move(Direction.DOWN);
        }
        while (blockpos$Mutable.getY() > 74 && (world.isEmptyBlock((BlockPos)blockpos$Mutable) || world.getBlockState((BlockPos)blockpos$Mutable).getFluidState().is(FluidTags.WATER) && world.getBlockState((BlockPos)blockpos$Mutable).is(BlockTags.REPLACEABLE_BY_TREES))) {
            blockpos$Mutable.move(Direction.DOWN);
        }
        return blockpos$Mutable.getY();
    }
}

