/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.worldgen.processors;

import com.mojang.serialization.MapCodec;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzProcessors;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class CloseOffOutsideFluidsProcessor
extends StructureProcessor {
    public static final MapCodec<CloseOffOutsideFluidsProcessor> CODEC = MapCodec.unit(CloseOffOutsideFluidsProcessor::new);

    private CloseOffOutsideFluidsProcessor() {
    }

    public StructureTemplate.StructureBlockInfo processBlock(LevelReader levelReader, BlockPos pos, BlockPos blockPos, StructureTemplate.StructureBlockInfo structureBlockInfoLocal, StructureTemplate.StructureBlockInfo structureBlockInfoWorld, StructurePlaceSettings settings) {
        BlockPos worldPos = structureBlockInfoWorld.pos();
        if (structureBlockInfoWorld.state().isAir()) {
            if (GeneralUtils.isOutsideStructureAllowedBounds(settings, structureBlockInfoWorld.pos())) {
                return structureBlockInfoWorld;
            }
            ChunkAccess cachedChunk = levelReader.getChunk(structureBlockInfoWorld.pos());
            BlockPos.MutableBlockPos sidePos = new BlockPos.MutableBlockPos();
            for (Direction direction : Direction.values()) {
                BlockState neighborState;
                if (Direction.DOWN == direction) continue;
                sidePos.set((Vec3i)worldPos).move(direction);
                if (cachedChunk.getPos().x != sidePos.getX() >> 4 || cachedChunk.getPos().z != sidePos.getZ() >> 4) {
                    cachedChunk = levelReader.getChunk((BlockPos)sidePos);
                }
                if (!(neighborState = cachedChunk.getBlockState((BlockPos)sidePos)).getFluidState().isSource()) continue;
                if (!levelReader.getBlockState(sidePos.below()).getFluidState().isEmpty()) {
                    int sectionYIndex = cachedChunk.getSectionIndex(sidePos.getY());
                    LevelChunkSection levelChunkSection = cachedChunk.getSection(sectionYIndex);
                    levelChunkSection.setBlockState(SectionPos.sectionRelative((int)sidePos.getX()), SectionPos.sectionRelative((int)sidePos.getY()), SectionPos.sectionRelative((int)sidePos.getZ()), ((Block)BzBlocks.FILLED_POROUS_HONEYCOMB.get()).defaultBlockState(), false);
                    continue;
                }
                if (levelReader.isOutsideBuildHeight((BlockPos)sidePos)) continue;
                ((LevelAccessor)levelReader).scheduleTick((BlockPos)sidePos, neighborState.getFluidState().getType(), 0);
            }
        }
        return structureBlockInfoWorld;
    }

    protected StructureProcessorType<?> getType() {
        return (StructureProcessorType)BzProcessors.CLOSE_OFF_OUTSIDE_FLUIDS_PROCESSOR.get();
    }
}

