/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.worldgen.surfacerules;

import com.mojang.serialization.MapCodec;
import com.telepathicgrunt.the_bumblezone.utils.OpenSimplex2F;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.SurfaceRules;

public record PollinatedSurfaceSource(BlockState resultState, RandomLayerStateRule rule) implements SurfaceRules.RuleSource
{
    public static final KeyDispatchDataCodec<PollinatedSurfaceSource> CODEC = KeyDispatchDataCodec.of((MapCodec)BlockState.CODEC.xmap(PollinatedSurfaceSource::new, PollinatedSurfaceSource::resultState).fieldOf("result_state"));

    PollinatedSurfaceSource(BlockState blockState) {
        this(blockState, new RandomLayerStateRule(blockState));
    }

    public KeyDispatchDataCodec<? extends SurfaceRules.RuleSource> codec() {
        return CODEC;
    }

    public SurfaceRules.SurfaceRule apply(SurfaceRules.Context context) {
        return this.rule;
    }

    public static class RandomLayerStateRule
    implements SurfaceRules.SurfaceRule {
        protected final BlockState blockState;
        protected static long seed;
        private static OpenSimplex2F noiseGenerator;
        private static final float xzScale = 0.035f;
        private static final float yScale = 0.015f;
        private final boolean haslayer;

        public RandomLayerStateRule(BlockState blockState) {
            this.blockState = blockState;
            this.haslayer = this.blockState.hasProperty((Property)BlockStateProperties.LAYERS);
        }

        public static void initNoise(long seedIn) {
            if (seed != seedIn || noiseGenerator == null) {
                noiseGenerator = new OpenSimplex2F(seedIn);
                seed = seedIn;
            }
        }

        public BlockState tryApply(int x, int y, int z) {
            if (this.haslayer) {
                double noiseVal = noiseGenerator.noise3_Classic((float)x * 0.035f, (float)y * 0.015f, (float)z * 0.035f);
                int layerHeight = Math.max(0, (int)((noiseVal / 2.0 + 0.5) * 8.0));
                layerHeight = Math.min(8, layerHeight + (Integer)this.blockState.getValue((Property)BlockStateProperties.LAYERS));
                return (BlockState)this.blockState.setValue((Property)BlockStateProperties.LAYERS, (Comparable)Integer.valueOf(layerHeight));
            }
            return this.blockState;
        }

        static {
            noiseGenerator = null;
        }
    }
}

