/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.blocks;

import com.mojang.serialization.MapCodec;
import com.telepathicgrunt.the_bumblezone.blocks.EssenceBlock;
import com.telepathicgrunt.the_bumblezone.blocks.blockentities.EssenceBlockEntity;
import com.telepathicgrunt.the_bumblezone.bossbars.ServerEssenceEvent;
import com.telepathicgrunt.the_bumblezone.configs.BzGeneralConfigs;
import com.telepathicgrunt.the_bumblezone.items.essence.EssenceOfTheBees;
import com.telepathicgrunt.the_bumblezone.modinit.BzSounds;
import com.telepathicgrunt.the_bumblezone.modinit.BzStats;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.packets.MusicPacketFromServer;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.BossEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;

public class EssenceBlockRed
extends EssenceBlock {
    public static final MapCodec<EssenceBlockRed> CODEC = Block.simpleCodec(EssenceBlockRed::new);
    private static final int ENTITIES_TO_KILL = 100;

    public EssenceBlockRed() {
        this(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_RED).strength(-1.0f, 3600000.8f).lightLevel(blockState -> 15).noLootTable().forceSolidOn().isValidSpawn((blockState, blockGetter, blockPos, entityType) -> false).isViewBlocking((blockState, blockGetter, blockPos) -> false).pushReaction(PushReaction.BLOCK));
    }

    public EssenceBlockRed(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public MapCodec<? extends EssenceBlockRed> codec() {
        return CODEC;
    }

    @Override
    public ResourceLocation getArenaNbt() {
        return ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"essence/red_arena");
    }

    @Override
    public int getEventTimeFrame() {
        return BzGeneralConfigs.redArenaTimeFrameInTicks;
    }

    @Override
    public ServerEssenceEvent getServerEssenceEvent() {
        return (ServerEssenceEvent)new ServerEssenceEvent("essence.the_bumblezone.red_essence_event", BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.NOTCHED_20).setDarkenScreen(true);
    }

    @Override
    public ResourceLocation getEssenceItemReward() {
        return ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"gameplay/rewards/red_arena_victory");
    }

    @Override
    public int getEssenceXpReward() {
        return 3000;
    }

    @Override
    public boolean hasMiningFatigue() {
        return true;
    }

    @Override
    public void awardPlayerWinStat(ServerPlayer serverPlayer) {
        serverPlayer.awardStat((ResourceLocation)BzStats.RAGING_EVENT_DEFEATED_RL.get());
    }

    @Override
    public void performUniqueArenaTick(ServerLevel serverLevel, BlockPos blockPos, BlockState blockState, EssenceBlockEntity essenceBlockEntity) {
        if (essenceBlockEntity.getPlayerInArena().size() == 0) {
            return;
        }
        int entitiesKilled = essenceBlockEntity.getExtraEventTrackingProgress();
        List<EssenceBlockEntity.EventEntities> eventEntitiesInArena = essenceBlockEntity.getEventEntitiesInArena();
        if (entitiesKilled != 100 && (double)eventEntitiesInArena.size() < Math.min(3.0 + (double)essenceBlockEntity.getPlayerInArena().size() * 1.5, (double)(100 - entitiesKilled))) {
            int currentEntityCount = eventEntitiesInArena.size() + entitiesKilled;
            EssenceBlockRed.SpawnNewEnemy(serverLevel, blockPos, blockState, essenceBlockEntity, currentEntityCount, eventEntitiesInArena);
        } else {
            for (int i = eventEntitiesInArena.size() - 1; i >= 0; --i) {
                Mob mob;
                NeutralMob neutralMob;
                UUID entityToCheck = eventEntitiesInArena.get(i).uuid();
                Entity entity = serverLevel.getEntity(entityToCheck);
                if (entity == null) {
                    ++entitiesKilled;
                    eventEntitiesInArena.remove(i);
                    continue;
                }
                if (entity instanceof NeutralMob && !((neutralMob = (NeutralMob)entity).getTarget() instanceof Player)) {
                    playerUUID = essenceBlockEntity.getPlayerInArena().get(serverLevel.getRandom().nextInt(essenceBlockEntity.getPlayerInArena().size()));
                    player = serverLevel.getPlayerByUUID(playerUUID);
                    neutralMob.setRemainingPersistentAngerTime(Integer.MAX_VALUE);
                    neutralMob.setPersistentAngerTarget(playerUUID);
                    neutralMob.setTarget((LivingEntity)player);
                } else if (entity instanceof Mob && !((mob = (Mob)entity).getTarget() instanceof Player)) {
                    playerUUID = essenceBlockEntity.getPlayerInArena().get(serverLevel.getRandom().nextInt(essenceBlockEntity.getPlayerInArena().size()));
                    player = serverLevel.getPlayerByUUID(playerUUID);
                    mob.setTarget((LivingEntity)player);
                }
                if (Math.abs(entity.blockPosition().getX() - blockPos.getX()) <= essenceBlockEntity.getArenaSize().getX() / 2 && Math.abs(entity.blockPosition().getY() - blockPos.getY()) <= essenceBlockEntity.getArenaSize().getY() / 2 && Math.abs(entity.blockPosition().getZ() - blockPos.getZ()) <= essenceBlockEntity.getArenaSize().getZ() / 2) continue;
                int yOffset = -essenceBlockEntity.getArenaSize().getY() / 2 + 2;
                BlockPos center = blockPos.offset(0, yOffset, 0);
                entity.moveTo((double)center.getX(), (double)center.getY(), (double)center.getZ());
            }
        }
        float newProgress = entitiesKilled / 100;
        essenceBlockEntity.getEventBar().setProgress(1.0f - newProgress);
        essenceBlockEntity.setExtraEventTrackingProgress(entitiesKilled);
        if (entitiesKilled == 100) {
            EssenceBlockEntity.EndEvent(serverLevel, blockPos, blockState, essenceBlockEntity, true);
        }
    }

    private static void SpawnNewEnemy(ServerLevel serverLevel, BlockPos blockPos, BlockState blockState, EssenceBlockEntity essenceBlockEntity, int currentEntityCount, List<EssenceBlockEntity.EventEntities> eventEntitiesInArena) {
        TagKey<EntityType<?>> enemyTagToUse = BzTags.ESSENCE_RAGING_ARENA_NORMAL_ENEMY;
        int entityToSpawnIndex = currentEntityCount + 1;
        if (entityToSpawnIndex % 25 == 0 || entityToSpawnIndex == 49 || entityToSpawnIndex == 73 || entityToSpawnIndex == 74 || entityToSpawnIndex == 97 || entityToSpawnIndex == 98 || entityToSpawnIndex == 99) {
            enemyTagToUse = BzTags.ESSENCE_RAGING_ARENA_BOSS_ENEMY;
        } else if (entityToSpawnIndex % 5 == 0) {
            enemyTagToUse = BzTags.ESSENCE_RAGING_ARENA_STRONG_ENEMY;
        } else if (entityToSpawnIndex % 3 == 0) {
            enemyTagToUse = BzTags.ESSENCE_RAGING_ARENA_RANGED_ENEMY;
        }
        List entityTypeList = BuiltInRegistries.ENTITY_TYPE.getTag(enemyTagToUse).map(holders -> holders.stream().map(Holder::value).toList()).orElseGet(ArrayList::new);
        EntityType entityTypeToSpawn = (EntityType)entityTypeList.get(serverLevel.getRandom().nextInt(entityTypeList.size()));
        int yOffset = -essenceBlockEntity.getArenaSize().getY() / 2 + 2;
        Entity entity = entityTypeToSpawn.spawn(serverLevel, blockPos.offset(0, yOffset, 0), MobSpawnType.TRIGGERED);
        if (entity != null) {
            entity.addTag("the_bumblezone.red_essence_arena");
            if (entity instanceof Slime) {
                Slime slime = (Slime)entity;
                slime.setSize(4, true);
            }
            eventEntitiesInArena.add(new EssenceBlockEntity.EventEntities(entity.getUUID()));
            UUID playerUUID = essenceBlockEntity.getPlayerInArena().get(serverLevel.getRandom().nextInt(essenceBlockEntity.getPlayerInArena().size()));
            ServerPlayer player = serverLevel.getServer().getPlayerList().getPlayer(playerUUID);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = player;
                float maxHeart = Math.max(serverPlayer.getHealth(), serverPlayer.getMaxHealth());
                float maxArmor = serverPlayer.getArmorValue();
                float mobHealthBoost = maxHeart / 15.0f + maxArmor / 10.0f;
                float mobAttackBoost = maxHeart / 20.0f + maxArmor / 15.0f;
                boolean isEssenced = EssenceOfTheBees.hasEssence(serverPlayer);
                if (!isEssenced) {
                    mobHealthBoost *= 1.5f;
                    mobAttackBoost *= 1.5f;
                }
                float timeProgress = 1.0f - (float)essenceBlockEntity.getEventTimer() / (float)((EssenceBlock)blockState.getBlock()).getEventTimeFrame();
                float enemyProgress = essenceBlockEntity.getExtraEventTrackingProgress() / 100;
                float progressDiff = (float)(Math.pow(enemyProgress - timeProgress + 1.0f, 2.0) - 1.0);
                if ((double)progressDiff > 0.06) {
                    progressDiff = (float)Math.pow((double)((enemyProgress - timeProgress) * 2.0f) + 0.5, 5.0);
                    mobHealthBoost += (float)((int)(progressDiff / 0.025f));
                    mobAttackBoost += (float)((int)(progressDiff / 0.1f));
                }
                if (entity instanceof LivingEntity) {
                    AttributeInstance livingEntityAttributeFollowRange;
                    AttributeInstance livingEntityAttributeFlyingSpeed;
                    AttributeInstance livingEntityAttributeSpeed;
                    AttributeInstance livingEntityAttributeAttack;
                    LivingEntity livingEntity = (LivingEntity)entity;
                    AttributeInstance livingEntityAttributeHealth = livingEntity.getAttribute(Attributes.MAX_HEALTH);
                    if (livingEntityAttributeHealth != null) {
                        livingEntityAttributeHealth.addPermanentModifier(new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"essence_arena_health_boost"), (double)mobHealthBoost, AttributeModifier.Operation.ADD_VALUE));
                        livingEntity.heal(mobHealthBoost);
                    }
                    if ((livingEntityAttributeAttack = livingEntity.getAttribute(Attributes.ATTACK_DAMAGE)) != null) {
                        livingEntityAttributeAttack.addPermanentModifier(new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"essence_arena_damage_boost"), (double)mobAttackBoost, AttributeModifier.Operation.ADD_VALUE));
                    }
                    if ((livingEntityAttributeSpeed = livingEntity.getAttribute(Attributes.MOVEMENT_SPEED)) != null) {
                        livingEntityAttributeSpeed.addPermanentModifier(new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"essence_arena_speed_boost"), isEssenced ? 0.05 : 0.065, AttributeModifier.Operation.ADD_VALUE));
                    }
                    if ((livingEntityAttributeFlyingSpeed = livingEntity.getAttribute(Attributes.FLYING_SPEED)) != null) {
                        livingEntityAttributeFlyingSpeed.addPermanentModifier(new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"essence_arena_flying_speed_boost"), 0.065, AttributeModifier.Operation.ADD_VALUE));
                    }
                    if ((livingEntityAttributeFollowRange = livingEntity.getAttribute(Attributes.FOLLOW_RANGE)) != null) {
                        livingEntityAttributeFollowRange.addPermanentModifier(new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"essence_arena_sight_boost"), 32.0, AttributeModifier.Operation.ADD_VALUE));
                    }
                }
                if (entity instanceof NeutralMob) {
                    NeutralMob neutralMob = (NeutralMob)entity;
                    neutralMob.setRemainingPersistentAngerTime(Integer.MAX_VALUE);
                    neutralMob.setPersistentAngerTarget(playerUUID);
                    neutralMob.setTarget((LivingEntity)serverPlayer);
                } else if (entity instanceof Mob) {
                    Mob mob = (Mob)entity;
                    mob.setTarget((LivingEntity)serverPlayer);
                    if (entity instanceof Rabbit) {
                        Rabbit rabbit = (Rabbit)entity;
                        rabbit.setVariant(Rabbit.Variant.EVIL);
                    }
                }
            }
        }
    }

    @Override
    public void onPlayerEnter(ServerLevel serverLevel, ServerPlayer serverPlayer, EssenceBlockEntity essenceBlockEntity) {
        MusicPacketFromServer.sendToClient((Player)serverPlayer, ((SoundEvent)BzSounds.RAGING_EVENT.get()).getLocation(), true);
        super.onPlayerEnter(serverLevel, serverPlayer, essenceBlockEntity);
    }

    @Override
    public void onPlayerLeave(ServerLevel serverLevel, ServerPlayer serverPlayer, EssenceBlockEntity essenceBlockEntity) {
        MusicPacketFromServer.sendToClient((Player)serverPlayer, ((SoundEvent)BzSounds.RAGING_EVENT.get()).getLocation(), false);
        super.onPlayerLeave(serverLevel, serverPlayer, essenceBlockEntity);
    }
}

