/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.blocks;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class RotationFacingBlock
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.FACING;
    public static final IntegerProperty ROTATION = IntegerProperty.create((String)"rotation", (int)0, (int)3);
    public static final MapCodec<RotationFacingBlock> CODEC = Block.simpleCodec(RotationFacingBlock::new);

    protected RotationFacingBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)ROTATION, (Comparable)Integer.valueOf(1))).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    public MapCodec<? extends RotationFacingBlock> codec() {
        return CODEC;
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        Direction facingDirection = (Direction)state.getValue((Property)FACING);
        int rotationIndex = (Integer)state.getValue((Property)ROTATION);
        Direction newFacingDirection = rotation.rotate(facingDirection);
        int newRotationIndex = RotationFacingBlock.getRotatedRotation(facingDirection, rotationIndex, rotation);
        return (BlockState)((BlockState)state.setValue((Property)FACING, (Comparable)newFacingDirection)).setValue((Property)ROTATION, (Comparable)Integer.valueOf(newRotationIndex));
    }

    private static int getRotatedRotation(Direction attachmentFace, int rotationIndex, Rotation rotation) {
        if (attachmentFace.getAxis() == Direction.Axis.Y) {
            return (rotationIndex + 4 - rotation.ordinal()) % 4;
        }
        return rotationIndex;
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        Direction facingDirection = (Direction)state.getValue((Property)FACING);
        int rotationIndex = (Integer)state.getValue((Property)ROTATION);
        Direction newFacingDirection = mirror.mirror(facingDirection);
        int newRotationIndex = RotationFacingBlock.getMirroredRotation(facingDirection, rotationIndex, mirror);
        return (BlockState)((BlockState)state.setValue((Property)FACING, (Comparable)newFacingDirection)).setValue((Property)ROTATION, (Comparable)Integer.valueOf(newRotationIndex));
    }

    private static int getMirroredRotation(Direction attachmentFace, int rotationIndex, Mirror mirror) {
        boolean rotationIsEven;
        if (mirror == Mirror.NONE) {
            return rotationIndex;
        }
        boolean specialCase = mirror == Mirror.LEFT_RIGHT && attachmentFace.getAxis() == Direction.Axis.Y;
        boolean bl = rotationIsEven = rotationIndex % 2 == 0;
        if (specialCase && rotationIsEven || !specialCase && !rotationIsEven) {
            return (rotationIndex + 2) % 4;
        }
        return rotationIndex;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
        builder.add(new Property[]{ROTATION});
    }

    public BlockState getStateForPlacement(BlockPlaceContext blockPlaceContext) {
        Direction clickFaceDirection = blockPlaceContext.getClickedFace();
        Vec3 clickedPos = blockPlaceContext.getClickLocation().subtract(blockPlaceContext.getClickedPos().getCenter());
        double xSpot = clickedPos.x();
        double ySpot = clickedPos.y();
        double zSpot = clickedPos.z();
        int rotation = clickFaceDirection.getAxis() == Direction.Axis.Y ? (Math.abs(xSpot) > Math.abs(zSpot) ? (xSpot > 0.0 ? 1 : 3) : (zSpot > 0.0 ? 0 : 2)) : (clickFaceDirection.getAxis() == Direction.Axis.X ? (Math.abs(ySpot) > Math.abs(zSpot) ? (ySpot > 0.0 ? 0 : 2) : (zSpot > 0.0 ? (clickFaceDirection == Direction.WEST ? 3 : 1) : (clickFaceDirection == Direction.WEST ? 1 : 3))) : (Math.abs(ySpot) > Math.abs(xSpot) ? (ySpot > 0.0 ? 0 : 2) : (xSpot > 0.0 ? (clickFaceDirection == Direction.SOUTH ? 3 : 1) : (clickFaceDirection == Direction.SOUTH ? 1 : 3))));
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)clickFaceDirection)).setValue((Property)ROTATION, (Comparable)Integer.valueOf(rotation));
    }
}

