/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.entities.mobs;

import com.telepathicgrunt.the_bumblezone.advancements.GenericTrigger;
import com.telepathicgrunt.the_bumblezone.client.LivingEntityFlyingSoundInstance;
import com.telepathicgrunt.the_bumblezone.configs.BzBeeAggressionConfigs;
import com.telepathicgrunt.the_bumblezone.configs.BzGeneralConfigs;
import com.telepathicgrunt.the_bumblezone.entities.BeeInteractivity;
import com.telepathicgrunt.the_bumblezone.entities.controllers.BeehemothMoveController;
import com.telepathicgrunt.the_bumblezone.entities.goals.BeehemothFlyingStillGoal;
import com.telepathicgrunt.the_bumblezone.entities.goals.BeehemothRandomFlyGoal;
import com.telepathicgrunt.the_bumblezone.entities.goals.BeehemothTemptGoal;
import com.telepathicgrunt.the_bumblezone.entities.navigation.DirectPathNavigator;
import com.telepathicgrunt.the_bumblezone.items.BeeBread;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzDimension;
import com.telepathicgrunt.the_bumblezone.modinit.BzEffects;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzSounds;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.packets.SyncBeehemothSpeedConfigFromServer;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PlayerRideable;
import net.minecraft.world.entity.Saddleable;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class BeehemothEntity
extends TamableAnimal
implements FlyingAnimal,
Saddleable,
PlayerRideable {
    public static boolean beehemothSpeedConfigChanged = false;
    public static double beehemothSpeedConfigValue = BzGeneralConfigs.beehemothSpeed;
    private static final EntityDataAccessor<Boolean> SADDLED = SynchedEntityData.defineId(BeehemothEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> QUEEN = SynchedEntityData.defineId(BeehemothEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> FRIENDSHIP = SynchedEntityData.defineId(BeehemothEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final MutableComponent QUEEN_NAME = Component.translatable((String)"entity.the_bumblezone.beehemoth_queen");
    public static final int TICKS_PER_FLAP = Mth.ceil((float)1.4959966f);
    private boolean stopWandering = false;
    public final float offset1;
    public final float offset2;
    public final float offset3;
    public final float offset4;
    public final float offset5;
    public final float offset6;
    public boolean movingStraightUp = false;
    public boolean movingStraightDown = false;
    private boolean wasOnGround = false;
    public float flyingSpeed = 0.02f;
    private static final ResourceLocation FRIENDSHIP_HEALTH_BOOST = ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"friendship_health_boost");
    private static final int MAX_FRIENDSHIP_HEALTH_BOOST_AMOUNT = 20;

    public BeehemothEntity(EntityType<? extends BeehemothEntity> type, Level world) {
        super(type, world);
        this.moveControl = new BeehemothMoveController(this);
        this.offset1 = this.random.nextFloat() - 0.5f;
        this.offset2 = this.random.nextFloat() - 0.5f;
        this.offset3 = this.random.nextFloat() - 0.5f;
        this.offset4 = this.random.nextFloat() - 0.5f;
        this.offset5 = this.random.nextFloat() - 0.5f;
        this.offset6 = this.random.nextFloat() - 0.5f;
    }

    protected Component getTypeName() {
        if (this.isQueen()) {
            return QUEEN_NAME;
        }
        return super.getTypeName();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(SADDLED, (Object)false);
        builder.define(QUEEN, (Object)false);
        builder.define(FRIENDSHIP, (Object)0);
    }

    public static AttributeSupplier.Builder getAttributeBuilder() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 40.0).add(Attributes.FLYING_SPEED, (double)0.4f).add(Attributes.MOVEMENT_SPEED, 0.3).add(Attributes.ATTACK_DAMAGE, 4.0).add(Attributes.FOLLOW_RANGE, 128.0);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new BeehemothTemptGoal(this, 0.012, BzTags.BEEHEMOTH_FAST_LURING_DESIRED_ITEMS));
        this.goalSelector.addGoal(2, (Goal)new BeehemothTemptGoal(this, 0.006, BzTags.BEEHEMOTH_DESIRED_ITEMS));
        this.goalSelector.addGoal(3, (Goal)new BeehemothFlyingStillGoal(this));
        this.goalSelector.addGoal(4, (Goal)new BeehemothRandomFlyGoal(this));
        this.goalSelector.addGoal(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 60.0f));
        this.goalSelector.addGoal(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(6, (Goal)new FloatGoal((Mob)this));
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putBoolean("saddled", this.isSaddled());
        tag.putBoolean("queen", this.isQueen());
        tag.putInt("friendship", this.getFriendship());
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setSaddled(tag.getBoolean("saddled"));
        this.setQueen(tag.contains("queen") && tag.getBoolean("queen"));
        this.setFriendship(tag.getInt("friendship"));
    }

    public boolean isFood(ItemStack itemStack) {
        return itemStack.is(BzTags.BEE_FEEDING_ITEMS);
    }

    protected PathNavigation createNavigation(Level pLevel) {
        return new DirectPathNavigator((Mob)this, pLevel);
    }

    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    public boolean isQueen() {
        return (Boolean)this.entityData.get(QUEEN);
    }

    public boolean isSaddleable() {
        return this.isAlive() && !this.isBaby() && this.isTame();
    }

    public void equipSaddle(ItemStack saddle, SoundSource soundSource) {
        this.entityData.set(SADDLED, (Object)true);
        if (soundSource != null) {
            this.level().playSound(null, (Entity)this, SoundEvents.HORSE_SADDLE, soundSource, 0.5f, 1.0f);
        }
    }

    public void setSaddled(boolean saddled) {
        this.entityData.set(SADDLED, (Object)saddled);
    }

    public boolean isSaddled() {
        return (Boolean)this.entityData.get(SADDLED);
    }

    public int getMaxFriendshipThreshold() {
        return 1000;
    }

    public boolean isMaxFriendship() {
        return this.getFriendship() >= this.getMaxFriendshipThreshold();
    }

    public void setQueen(boolean queen) {
        this.entityData.set(QUEEN, (Object)queen);
    }

    public int getFriendship() {
        return (Integer)this.entityData.get(FRIENDSHIP);
    }

    public void setFriendship(Integer newFriendship) {
        this.entityData.set(FRIENDSHIP, (Object)Math.min(Math.max(newFriendship, -100), this.getMaxFriendshipThreshold()));
        this.setMaxHealth();
    }

    public void addFriendship(Integer deltaFriendship) {
        this.entityData.set(FRIENDSHIP, (Object)Math.min(Math.max(this.getFriendship() + deltaFriendship, -100), this.getMaxFriendshipThreshold()));
        this.setMaxHealth();
    }

    public void setMaxHealth() {
        int healthBoost = this.isQueen() ? 20 : (int)(Math.max((double)this.getFriendship() / (double)this.getMaxFriendshipThreshold(), 0.0) * 20.0);
        int oldHealthBoost = 0;
        boolean doNothingWithCurrentHealth = false;
        AttributeInstance attributeInstance = this.getAttribute(Attributes.MAX_HEALTH);
        if (attributeInstance != null) {
            AttributeModifier attributeModifier = attributeInstance.getModifier(FRIENDSHIP_HEALTH_BOOST);
            if (attributeModifier != null) {
                if (attributeModifier.amount() == (double)healthBoost) {
                    doNothingWithCurrentHealth = true;
                } else {
                    oldHealthBoost = (int)attributeModifier.amount();
                }
            }
            if (!doNothingWithCurrentHealth) {
                attributeInstance.removeModifier(FRIENDSHIP_HEALTH_BOOST);
                attributeInstance.addTransientModifier(new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"friendship_health_boost"), (double)healthBoost, AttributeModifier.Operation.ADD_VALUE));
                if (oldHealthBoost < healthBoost) {
                    this.heal(healthBoost - oldHealthBoost);
                }
            }
        }
    }

    public boolean isStopWandering() {
        return this.stopWandering;
    }

    public void makeStuckInBlock(BlockState blockState, Vec3 speedMult) {
        if (blockState.getBlock() instanceof SweetBerryBushBlock) {
            return;
        }
        super.makeStuckInBlock(blockState, speedMult);
    }

    public boolean isInvulnerableTo(DamageSource damageSource) {
        if (damageSource == this.level().damageSources().sweetBerryBush()) {
            return true;
        }
        return super.isInvulnerableTo(damageSource);
    }

    public boolean hurt(DamageSource source, float amount) {
        if (this.isInvulnerableTo(source)) {
            return false;
        }
        if (this.isOnPortalCooldown() && source == this.level().damageSources().inWall()) {
            this.spawnMadParticles();
            this.playHurtSound(source);
            return false;
        }
        Entity entity = source.getEntity();
        if (!this.isNoAi()) {
            if (!BzGeneralConfigs.beehemothFriendlyFire && entity != null && entity.getUUID().equals(this.getOwnerUUID())) {
                return false;
            }
            this.setOrderedToSit(false);
            if (source.type() != this.level().damageSources().inWall().type()) {
                if (entity != null && entity.getUUID().equals(this.getOwnerUUID()) && this.isTame()) {
                    this.addFriendship((int)(-3.0f * amount));
                }
                if (BzBeeAggressionConfigs.aggressiveBees && BzBeeAggressionConfigs.beehemothTriggersWrath && entity instanceof LivingEntity) {
                    Player player;
                    LivingEntity livingEntity = (LivingEntity)entity;
                    if (this.isTame()) {
                        this.addFriendship((int)(-amount));
                    }
                    if (!(livingEntity instanceof Player && ((player = (Player)livingEntity).isCreative() || this.level().getDifficulty() == Difficulty.PEACEFUL) || !livingEntity.level().dimension().equals(BzDimension.BZ_WORLD_KEY) && !BzBeeAggressionConfigs.allowWrathOfTheHiveOutsideBumblezone || livingEntity.isSpectator())) {
                        if (livingEntity.hasEffect(BzEffects.PROTECTION_OF_THE_HIVE.holder())) {
                            livingEntity.removeEffect(BzEffects.PROTECTION_OF_THE_HIVE.holder());
                        } else {
                            livingEntity.addEffect(new MobEffectInstance(BzEffects.WRATH_OF_THE_HIVE.holder(), BzBeeAggressionConfigs.howLongWrathOfTheHiveLasts, 2, false, BzBeeAggressionConfigs.showWrathOfTheHiveParticles, true));
                        }
                    }
                } else if (this.isTame()) {
                    this.addFriendship((int)(-amount));
                }
            }
        }
        this.spawnMadParticles();
        return super.hurt(source, amount);
    }

    public static boolean checkMobSpawnRules(EntityType<? extends Mob> entityType, LevelAccessor iWorld, MobSpawnType spawnReason, BlockPos blockPos, RandomSource random) {
        return true;
    }

    public boolean checkSpawnRules(LevelAccessor world, MobSpawnType spawnReason) {
        return true;
    }

    public boolean checkSpawnObstruction(LevelReader worldReader) {
        AABB box = this.getBoundingBox();
        return !worldReader.containsAnyLiquid(box) && worldReader.getBlockStates(box).noneMatch(state -> state.blocksMotion()) && worldReader.isUnobstructed((Entity)this);
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        InteractionResult actionresulttype1;
        if (this.isNoAi()) {
            return InteractionResult.PASS;
        }
        ItemStack stack = player.getItemInHand(hand);
        Item item = stack.getItem();
        ResourceLocation itemRL = BuiltInRegistries.ITEM.getKey((Object)item);
        if (this.level().isClientSide) {
            if (this.isTame() && this.isOwnedBy((LivingEntity)player)) {
                return InteractionResult.SUCCESS;
            }
            return !(this.getHealth() < this.getMaxHealth()) && this.isTame() ? InteractionResult.PASS : InteractionResult.SUCCESS;
        }
        if (this.isTame()) {
            if (this.isOwnedBy((LivingEntity)player)) {
                if (stack.is(BzTags.BEE_FEEDING_ITEMS) && !player.isShiftKeyDown()) {
                    if (stack.is(BzTags.ROYAL_JELLY_BUCKETS)) {
                        this.heal(40.0f);
                        BeeInteractivity.calmAndSpawnHearts(this.level(), player, (LivingEntity)this, 1.0f, 30);
                        this.addFriendship(this.getMaxFriendshipThreshold());
                        this.addEffect(new MobEffectInstance(BzEffects.BEENERGIZED.holder(), -1, 4, true, true, true));
                        for (int i = 0; i < 75; ++i) {
                            BeehemothEntity.spawnParticles((LevelAccessor)this.level(), this.position(), this.random, 0.1, 0.1, 0.1);
                        }
                    } else if (item == BzItems.ROYAL_JELLY_BOTTLE.get()) {
                        this.heal(10.0f);
                        BeeInteractivity.calmAndSpawnHearts(this.level(), player, (LivingEntity)this, 1.0f, 10);
                        this.addFriendship(250);
                        this.addEffect(new MobEffectInstance(BzEffects.BEENERGIZED.holder(), -1, 3, true, true, true));
                        for (int i = 0; i < 30; ++i) {
                            BeehemothEntity.spawnParticles((LevelAccessor)this.level(), this.position(), this.random, 0.1, 0.1, 0.1);
                        }
                    } else if (item == BzItems.BEE_BREAD.get()) {
                        this.heal(2.0f);
                        BeeInteractivity.calmAndSpawnHearts(this.level(), player, (LivingEntity)this, 0.8f, 5);
                        this.addFriendship(5);
                        BeeBread.grantStackingBeenergized(player, (LivingEntity)this);
                    } else if (stack.is(BzTags.HONEY_BUCKETS)) {
                        this.heal(this.getMaxHealth() - this.getHealth());
                        BeeInteractivity.calmAndSpawnHearts(this.level(), player, (LivingEntity)this, 0.8f, 5);
                        this.addFriendship(5);
                    } else if (itemRL.getPath().contains("honey")) {
                        this.heal(2.0f);
                        BeeInteractivity.calmAndSpawnHearts(this.level(), player, (LivingEntity)this, 0.3f, 3);
                        this.addFriendship(3);
                    } else {
                        this.heal(1.0f);
                        BeeInteractivity.calmAndSpawnHearts(this.level(), player, (LivingEntity)this, 0.1f, 3);
                        this.addFriendship(1);
                    }
                    GeneralUtils.givePlayerItem(player, hand, ItemStack.EMPTY, true, true);
                    player.swing(hand, true);
                    return InteractionResult.CONSUME;
                }
                if (item == Items.SADDLE && !this.isSaddled()) {
                    return InteractionResult.PASS;
                }
                if (player.isShiftKeyDown()) {
                    if (this.isSaddled() && this.isInSittingPose() && stack.isEmpty()) {
                        this.setSaddled(false);
                        ItemStack saddle = new ItemStack((ItemLike)Items.SADDLE);
                        if (player.addItem(saddle)) {
                            ItemEntity entity = new ItemEntity(player.level(), player.getX(), player.getY(), player.getZ(), saddle);
                            player.level().addFreshEntity((Entity)entity);
                        }
                    } else {
                        this.setOrderedToSit(!this.isOrderedToSit());
                        this.navigation.stop();
                        this.setTarget(null);
                    }
                    return InteractionResult.SUCCESS;
                }
                if (!this.isVehicle() && !player.isSecondaryUseActive()) {
                    if (!this.level().isClientSide) {
                        player.startRiding((Entity)this);
                        this.setOrderedToSit(false);
                    }
                    return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
                }
            }
        } else if (stack.is(BzTags.BEE_FEEDING_ITEMS)) {
            float tameChance;
            int friendshipAmount = 6;
            if (stack.is(BzTags.ROYAL_JELLY_BUCKETS)) {
                friendshipAmount = this.getMaxFriendshipThreshold();
                tameChance = 1.0f;
                for (int i = 0; i < 75; ++i) {
                    BeehemothEntity.spawnParticles((LevelAccessor)this.level(), this.position(), this.random, 0.1, 0.1, 0.1);
                }
            } else if (item == BzItems.ROYAL_JELLY_BOTTLE.get()) {
                friendshipAmount = 250;
                tameChance = 1.0f;
                for (int i = 0; i < 30; ++i) {
                    BeehemothEntity.spawnParticles((LevelAccessor)this.level(), this.position(), this.random, 0.1, 0.1, 0.1);
                }
            } else {
                tameChance = stack.is(BzTags.HONEY_BUCKETS) || item == BzItems.BEE_BREAD.get() ? 0.25f : (itemRL.getPath().contains("honey") ? 0.1f : 0.067f);
            }
            if (this.random.nextFloat() < tameChance) {
                this.tame(player);
                this.setFriendship(friendshipAmount);
                this.setOrderedToSit(true);
                this.level().broadcastEntityEvent((Entity)this, (byte)7);
            } else {
                this.level().broadcastEntityEvent((Entity)this, (byte)6);
            }
            GeneralUtils.givePlayerItem(player, hand, ItemStack.EMPTY, true, true);
            this.setPersistenceRequired();
            player.swing(hand, true);
            if (this.getFriendship() < 0) {
                this.spawnMadParticles();
            }
            return InteractionResult.CONSUME;
        }
        if ((actionresulttype1 = super.mobInteract(player, hand)).consumesAction()) {
            this.setPersistenceRequired();
        }
        if (this.getFriendship() < 0) {
            this.spawnMadParticles();
        }
        return actionresulttype1;
    }

    private void spawnMadParticles() {
        if (!this.level().isClientSide()) {
            ((ServerLevel)this.level()).sendParticles((ParticleOptions)ParticleTypes.ANGRY_VILLAGER, this.getX(), this.getY(), this.getZ(), Math.min(Math.max(1, this.getFriendship() / -3), 7), (double)(this.getRandom().nextFloat() - 0.5f), (double)(this.getRandom().nextFloat() * 0.4f + 0.4f), (double)(this.getRandom().nextFloat() - 0.5f), (double)(this.getRandom().nextFloat() * 0.8f + 0.4f));
        }
    }

    public void positionRider(Entity passenger, Entity.MoveFunction moveFunction) {
        if (passenger instanceof LivingEntity) {
            ((LivingEntity)passenger).yBodyRot = this.yBodyRot;
        }
        if (this.hasPassenger(passenger)) {
            Vec3 vec3 = this.getPassengerRidingPosition(passenger);
            moveFunction.accept(passenger, vec3.x, vec3.y + 0.25 - passenger.getVehicleAttachmentPoint((Entity)this).y(), vec3.z);
            double currentSpeed = this.getDeltaMovement().length();
            if (currentSpeed > 1.0E-6 && (double)this.getRandom().nextFloat() < 0.0085 && passenger.getUUID().equals(this.getOwnerUUID())) {
                this.addFriendship(1);
            }
        }
    }

    protected Vec3 getPassengerAttachmentPoint(Entity entity, EntityDimensions entityDimensions, float f) {
        float ff = Math.min(0.25f, this.walkAnimation.speed());
        float f1 = this.walkAnimation.position();
        float height = (float)((double)this.getBbHeight() - 0.2 + (double)(0.12f * Mth.cos((float)(f1 * 0.7f)) * 0.7f * ff));
        return new Vec3(0.0, (double)height, 0.0);
    }

    protected void removePassenger(Entity entity) {
        super.removePassenger(entity);
        if (entity == this.getOwner()) {
            this.setOrderedToSit(true);
        }
    }

    public boolean isNoGravity() {
        return true;
    }

    protected void playBlockFallSound() {
    }

    protected void playStepSound(BlockPos pos, BlockState blockState) {
    }

    protected SoundEvent getAmbientSound() {
        return null;
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return (SoundEvent)BzSounds.BEEHEMOTH_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)BzSounds.BEEHEMOTH_DEATH.get();
    }

    public void recreateFromPacket(ClientboundAddEntityPacket clientboundAddMobPacket) {
        super.recreateFromPacket(clientboundAddMobPacket);
        LivingEntityFlyingSoundInstance.playSound((LivingEntity)this, (SoundEvent)BzSounds.BEEHEMOTH_LOOP.get());
    }

    public void tick() {
        if (beehemothSpeedConfigChanged && !this.level().isClientSide()) {
            beehemothSpeedConfigValue = BzGeneralConfigs.beehemothSpeed;
            SyncBeehemothSpeedConfigFromServer.sendToClient((Entity)this, beehemothSpeedConfigValue);
            beehemothSpeedConfigChanged = false;
        }
        super.tick();
        this.stopWandering = this.isLeashed();
        if (!this.isQueen() && this.getFriendship() >= this.getMaxFriendshipThreshold()) {
            this.setQueen(true);
            LivingEntity livingEntity = this.getOwner();
            if (livingEntity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
                ((GenericTrigger)((Object)BzCriterias.QUEEN_BEEHEMOTH_TRIGGER.get())).trigger(serverPlayer);
            }
            if (this.level().isClientSide()) {
                for (int i = 0; i < 75; ++i) {
                    BeehemothEntity.spawnParticles((LevelAccessor)this.level(), this.position(), this.random, 0.1, 0.1, 0.1);
                }
            }
        } else if (this.getFriendship() < 0 && this.isTame()) {
            this.ejectPassengers();
            if (this.getRandom().nextFloat() < 0.01f) {
                this.spawnMadParticles();
            }
        }
        if (this.onGround()) {
            this.setDeltaMovement(this.getDeltaMovement().x(), this.getDeltaMovement().y() - 0.006, this.getDeltaMovement().z());
        } else if (this.wasOnGround) {
            this.setDeltaMovement(this.getDeltaMovement().x(), this.getDeltaMovement().y() + 0.006, this.getDeltaMovement().z());
        }
    }

    public static void spawnParticles(LevelAccessor world, Vec3 location, RandomSource random, double speedXZModifier, double speedYModifier, double initYSpeed) {
        double xOffset = random.nextFloat() * 2.0f - 1.0f;
        double yOffset = random.nextFloat() * 2.0f - 1.0f;
        double zOffset = random.nextFloat() * 2.0f - 1.0f;
        world.addParticle((ParticleOptions)ParticleTypes.FIREWORK, location.x() + xOffset, location.y() + yOffset + 1.0, location.z() + zOffset, random.nextGaussian() * speedXZModifier, random.nextGaussian() * speedYModifier + initYSpeed, random.nextGaussian() * speedXZModifier);
    }

    public AgeableMob getBreedOffspring(ServerLevel serverWorld, AgeableMob ageableEntity) {
        return null;
    }

    public void setLeashedTo(Entity entity, boolean sendAttachNotification) {
        super.setLeashedTo(entity, sendAttachNotification);
        this.stopWandering = true;
    }

    public Vec3 getLeashOffset() {
        return new Vec3(0.0, (double)(0.5f * this.getEyeHeight()), (double)(this.getBbWidth() * 0.2f));
    }

    public boolean isFlying() {
        return this.tickCount % TICKS_PER_FLAP == 0;
    }

    @Nullable
    public LivingEntity getControllingPassenger() {
        Entity firstPassenger;
        if (this.isSaddled() && (firstPassenger = this.getFirstPassenger()) instanceof Player) {
            Player player = (Player)firstPassenger;
            return player;
        }
        return null;
    }

    public float getFlyingSpeed() {
        if (!this.isTame() || !this.isOrderedToSit() && !this.isVehicle()) {
            return (float)(this.getAttributeValue(Attributes.FLYING_SPEED) / ((Attribute)Attributes.FLYING_SPEED.value()).getDefaultValue() * (double)0.0038f);
        }
        float reducedAttrDiff = (float)((this.getAttributeValue(Attributes.FLYING_SPEED) - ((Attribute)Attributes.FLYING_SPEED.value()).getDefaultValue()) / 3.0);
        float adjustedSpeedMultiplier = (float)(((double)reducedAttrDiff + ((Attribute)Attributes.FLYING_SPEED.value()).getDefaultValue()) / ((Attribute)Attributes.FLYING_SPEED.value()).getDefaultValue());
        return adjustedSpeedMultiplier * this.flyingSpeed;
    }

    public void travel(Vec3 moveVector) {
        if (this.isAlive() && !this.isNoAi()) {
            LivingEntity livingEntity = this.getControllingPassenger();
            if (this.isVehicle() && livingEntity != null) {
                float startRot = Mth.wrapDegrees((float)this.getYRot());
                float targetRot = Mth.wrapDegrees((float)livingEntity.getYRot());
                float lerpedRot = Mth.rotLerp((float)0.185f, (float)startRot, (float)targetRot);
                this.setYRot(lerpedRot);
                this.yRotO = this.getYRot();
                this.setXRot(livingEntity.getXRot() * 0.5f);
                this.setRot(this.getYRot(), this.getXRot());
                this.yHeadRot = this.yBodyRot = this.getYRot();
                double currentSpeed = this.flyingSpeed;
                double queenModifier = this.isQueen() ? 0.55 : 0.15;
                double friendlyModifier = (double)this.getFriendship() / 1100.0 + 0.05;
                double speedModifier = (queenModifier + friendlyModifier) * 0.1;
                double verticalSpeed = livingEntity.getLookAngle().y() * (double)Math.abs(livingEntity.zza) * 5.0;
                double forwardSpeed = livingEntity.zza * 10.0f;
                double strafeSpeed = 0.0;
                currentSpeed = livingEntity.zza != 0.0f || this.movingStraightUp || this.movingStraightDown ? Math.min(BzGeneralConfigs.beehemothSpeed * speedModifier, currentSpeed + 0.003) : Math.max(0.0, currentSpeed - 0.2);
                if (this.movingStraightUp || this.movingStraightDown) {
                    if (this.movingStraightUp) {
                        verticalSpeed = 10.0;
                    }
                    if (this.movingStraightDown) {
                        verticalSpeed = -10.0;
                    }
                }
                if (this.onGround()) {
                    forwardSpeed *= (double)0.025f;
                    verticalSpeed -= 0.5;
                } else if (this.wasOnGround) {
                    verticalSpeed += 0.5;
                }
                if (this.isControlledByLocalInstance()) {
                    this.flyingSpeed = (float)currentSpeed;
                    this.setSpeed(this.getFlyingSpeed());
                    Vec3 moveDir = new Vec3(strafeSpeed, verticalSpeed, forwardSpeed);
                    super.travel(moveDir);
                } else if (livingEntity instanceof Player) {
                    this.setDeltaMovement(Vec3.ZERO);
                }
                this.calculateEntityAnimation(false);
                this.tryCheckInsideBlocks();
            } else {
                super.travel(moveVector);
            }
            this.wasOnGround = this.onGround();
        }
    }

    public void ejectPassengers() {
        super.ejectPassengers();
        this.movingStraightUp = false;
        this.movingStraightDown = false;
    }

    public boolean isTargetBlocked(Vec3 target) {
        Vec3 vec3 = new Vec3(this.getX(), this.getEyeY(), this.getZ());
        return this.level().clip(new ClipContext(vec3, target, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this)).getType() != HitResult.Type.MISS;
    }
}

