/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.fluids.base;

import com.teamresourceful.resourcefullib.common.fluid.ResourcefulFlowingFluid;
import com.teamresourceful.resourcefullib.common.fluid.data.FluidData;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import org.jetbrains.annotations.NotNull;

public abstract class BzFluid
extends ResourcefulFlowingFluid {
    private final FluidData info;

    public BzFluid(FluidData info, boolean source) {
        super(info);
        this.info = info;
        if (source) {
            info.setStill(() -> this);
        } else {
            info.setFlowing(() -> this);
        }
    }

    public FluidData info() {
        return this.info;
    }

    public Fluid getFlowing() {
        return (Fluid)this.info.flowing().get();
    }

    public Fluid getSource() {
        return (Fluid)this.info.still().get();
    }

    protected boolean canConvertToSource(@NotNull Level level) {
        return this.info.properties().canConvertToSource();
    }

    protected void beforeDestroyingBlock(@NotNull LevelAccessor level, @NotNull BlockPos pos, BlockState blockState) {
        BlockEntity blockEntity = blockState.hasBlockEntity() ? level.getBlockEntity(pos) : null;
        Block.dropResources((BlockState)blockState, (LevelAccessor)level, (BlockPos)pos, (BlockEntity)blockEntity);
    }

    protected int getSlopeFindDistance(@NotNull LevelReader level) {
        return this.info.properties().slopeFindDistance();
    }

    protected int getDropOff(@NotNull LevelReader level) {
        return this.info.properties().dropOff();
    }

    public Item getBucket() {
        Item bucket = (Item)this.info.bucket().get();
        return bucket == null ? Items.AIR : bucket;
    }

    protected boolean canBeReplacedWith(@NotNull FluidState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull Fluid fluid, @NotNull Direction direction) {
        return Direction.DOWN == direction && !this.isSame(fluid);
    }

    public int getTickDelay(@NotNull LevelReader level) {
        return this.info.properties().tickDelay();
    }

    protected float getExplosionResistance() {
        return this.info.properties().explosionResistance();
    }

    protected BlockState createLegacyBlock(@NotNull FluidState state) {
        Block block = (Block)this.info.block().get();
        if (block == null) {
            return Blocks.AIR.defaultBlockState();
        }
        return (BlockState)block.defaultBlockState().setValue((Property)LiquidBlock.LEVEL, (Comparable)Integer.valueOf(BzFluid.getLegacyLevel((FluidState)state)));
    }

    public boolean isSame(@NotNull Fluid fluid) {
        return fluid == this.info.still().get() || fluid == this.info.flowing().get();
    }

    public Optional<SoundEvent> getPickupSound() {
        SoundEvent event = this.info.properties().sounds().getOrDefault("bucket_fill", null);
        return event == null ? Optional.of(SoundEvents.BUCKET_FILL) : Optional.of(event);
    }

    public static class Flowing
    extends BzFluid {
        public Flowing(FluidData info) {
            super(info, false);
            this.registerDefaultState((FluidState)((FluidState)this.stateDefinition.any()).setValue((Property)LEVEL, (Comparable)Integer.valueOf(7)));
        }

        protected void createFluidStateDefinition(@NotNull StateDefinition.Builder<Fluid, FluidState> builder) {
            super.createFluidStateDefinition(builder);
            builder.add(new Property[]{LEVEL});
        }

        public boolean isSource(@NotNull FluidState state) {
            return false;
        }

        public int getAmount(@NotNull FluidState state) {
            return (Integer)state.getValue((Property)LEVEL);
        }
    }

    public static class Source
    extends BzFluid {
        public Source(FluidData info) {
            super(info, true);
        }

        public boolean isSource(@NotNull FluidState state) {
            return true;
        }

        public int getAmount(@NotNull FluidState state) {
            return 8;
        }
    }
}

