/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.worldgen.neoforge;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.the_bumblezone.configs.BzModCompatibilityConfigs;
import com.telepathicgrunt.the_bumblezone.modinit.neoforge.BzBiomeModifiers;
import com.telepathicgrunt.the_bumblezone.utils.PlatformHooks;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.ModifiableBiomeInfo;

public record BzModCompatBiomeModifier(HolderSet<Biome> biomes, HolderSet<PlacedFeature> feature, GenerationStep.Decoration step, String modid) implements BiomeModifier
{
    public static final MapCodec<BzModCompatBiomeModifier> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Biome.LIST_CODEC.fieldOf("biomes").forGetter(BzModCompatBiomeModifier::biomes), (App)PlacedFeature.LIST_CODEC.fieldOf("feature").forGetter(BzModCompatBiomeModifier::feature), (App)GenerationStep.Decoration.CODEC.fieldOf("step").forGetter(BzModCompatBiomeModifier::step), (App)Codec.STRING.fieldOf("required_mod").forGetter(BzModCompatBiomeModifier::modid)).apply((Applicative)builder, BzModCompatBiomeModifier::new));

    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (this.feature.size() != 0 && phase == BiomeModifier.Phase.ADD && PlatformHooks.isModLoaded(this.modid) && this.biomes.contains(biome)) {
            if (this.modid.equals("productivebees")) {
                if (BzModCompatibilityConfigs.spawnProductiveBeesHoneycombVariants) {
                    this.feature.stream().forEach(pf -> builder.getGenerationSettings().addFeature(this.step, pf));
                }
            } else if (this.modid.equals("resourcefulbees")) {
                if (BzModCompatibilityConfigs.spawnResourcefulBeesHoneycombVeins) {
                    this.feature.stream().filter(placedFeatureHolder -> {
                        FeatureConfiguration featureConfiguration = ((ConfiguredFeature)((PlacedFeature)placedFeatureHolder.value()).feature().value()).config();
                        if (featureConfiguration instanceof OreConfiguration) {
                            OreConfiguration oreConfiguration = (OreConfiguration)featureConfiguration;
                            return oreConfiguration.targetStates.stream().noneMatch(e -> e.state.isAir());
                        }
                        return true;
                    }).forEach(pf -> builder.getGenerationSettings().addFeature(this.step, pf));
                }
            } else {
                this.feature.stream().forEach(pf -> builder.getGenerationSettings().addFeature(this.step, pf));
            }
        }
    }

    public MapCodec<? extends BiomeModifier> codec() {
        return (MapCodec)BzBiomeModifiers.BIOME_MODIFIER.get();
    }
}

