/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.advancements;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.telepathicgrunt.the_bumblezone.items.BeeArmor;
import com.telepathicgrunt.the_bumblezone.modules.PlayerDataModule;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;

public class KilledCounterTrigger
extends SimpleCriterionTrigger<Instance> {
    private final ResourceLocation id;

    public KilledCounterTrigger(ResourceLocation id) {
        this.id = id;
    }

    public ResourceLocation m_7295_() {
        return this.id;
    }

    public Instance createInstance(JsonObject jsonObject, ContextAwarePredicate predicate, DeserializationContext deserializationContext) {
        JsonElement beeArmorJson = jsonObject.get("bee_armor_required");
        JsonElement targetTagJson = jsonObject.get("is_target_tag");
        return new Instance(predicate, new ResourceLocation(jsonObject.get("target_entity").getAsString()), jsonObject.get("target_count").getAsInt(), targetTagJson != null && targetTagJson.getAsBoolean(), beeArmorJson != null && beeArmorJson.getAsBoolean());
    }

    public void trigger(ServerPlayer serverPlayer, Entity currentEntity, PlayerDataModule module) {
        super.m_66234_(serverPlayer, trigger -> trigger.matches(serverPlayer, currentEntity, module));
    }

    public class Instance
    extends AbstractCriterionTriggerInstance {
        private final int targetCount;
        private final ResourceLocation targetEntity;
        private final boolean isTargetTag;
        private final boolean beeArmorRequired;

        public Instance(ContextAwarePredicate predicate, ResourceLocation targetEntity, int targetCount, boolean isTargetTag, boolean beeArmorRequired) {
            super(KilledCounterTrigger.this.id, predicate);
            this.targetCount = targetCount;
            this.targetEntity = targetEntity;
            this.isTargetTag = isTargetTag;
            this.beeArmorRequired = beeArmorRequired;
        }

        public boolean matches(ServerPlayer serverPlayer, Entity currentEntity, PlayerDataModule module) {
            boolean entityMatch = this.isTargetTag ? currentEntity.m_6095_().m_204039_(TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)this.targetEntity)) : BuiltInRegistries.f_256780_.m_7981_((Object)currentEntity.m_6095_()).equals((Object)this.targetEntity);
            int currentCount = 0;
            if (entityMatch) {
                module.mobsKilledTracker.merge(this.targetEntity, 1, Integer::sum);
                currentCount = module.mobsKilledTracker.get(this.targetEntity);
            }
            return entityMatch && (!this.beeArmorRequired || BeeArmor.getBeeThemedWearablesCount((Entity)serverPlayer) >= 4) && currentCount >= this.targetCount;
        }

        public JsonObject m_7683_(SerializationContext serializationContext) {
            JsonObject jsonobject = super.m_7683_(serializationContext);
            jsonobject.addProperty("target_count", (Number)this.targetCount);
            jsonobject.addProperty("target_entity", this.targetEntity.toString());
            jsonobject.addProperty("is_target_tag", Boolean.valueOf(this.isTargetTag));
            jsonobject.addProperty("bee_armor_required", Boolean.valueOf(this.beeArmorRequired));
            return jsonobject;
        }
    }
}

