/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.blocks;

import com.telepathicgrunt.the_bumblezone.items.essence.EssenceOfTheBees;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public interface AncientWaxBase {
    default public void applyEntityEffects(BlockState currentState, Entity collidingEntity) {
        if (collidingEntity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)collidingEntity;
            if (!collidingEntity.m_9236_().m_5776_() && collidingEntity.f_19797_ % 10 == 0) {
                Player player;
                if (livingEntity instanceof Player && ((player = (Player)livingEntity).m_7500_() || player.m_5833_())) {
                    return;
                }
                if (livingEntity.m_6095_().m_204039_(BzTags.ANCIENT_WAX_IMMUNE_TO_EFFECTS)) {
                    return;
                }
                if (!(livingEntity instanceof ServerPlayer) || !EssenceOfTheBees.hasEssence((ServerPlayer)(player = (ServerPlayer)livingEntity))) {
                    livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 95, 0, true, false, true));
                    livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19599_, 100, 2, true, false, true));
                    livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 100, 2, true, false, true));
                }
            }
        }
    }

    default public InteractionResult swapBlocks(Level world, BlockState currentState, BlockPos blockPos, TagKey<Block> blockIterationTag) {
        List<Block> blockList;
        int indexOfCurrentBlock;
        Optional tagEntries = BuiltInRegistries.f_256975_.m_203431_(blockIterationTag);
        if (tagEntries.isPresent() && ((HolderSet.Named)tagEntries.get()).m_203632_() > 1 && (indexOfCurrentBlock = (blockList = ((HolderSet.Named)tagEntries.get()).m_203614_().map(Holder::m_203334_).toList()).indexOf(currentState.m_60734_())) != -1) {
            Block newBlock = indexOfCurrentBlock + 1 == blockList.size() ? blockList.get(0) : blockList.get(indexOfCurrentBlock + 1);
            BlockState newState = newBlock.m_49966_();
            for (Property property : currentState.m_61147_()) {
                if (!newState.m_61138_(property)) continue;
                newState = GeneralUtils.getStateWithProperty(newState, currentState, property);
            }
            world.m_7731_(blockPos, newState, 3);
            return InteractionResult.m_19078_((boolean)world.m_5776_());
        }
        return InteractionResult.PASS;
    }
}

