/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.client.rendering;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.telepathicgrunt.the_bumblezone.fluids.HoneyFluidBlock;
import com.telepathicgrunt.the_bumblezone.modinit.BzFluids;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Matrix4f;

public class FluidClientOverlay {
    private static final ResourceLocation HONEY_TEXTURE_UNDERWATER = new ResourceLocation("the_bumblezone:textures/misc/honey_fluid_underwater.png");
    private static final ResourceLocation ROYAL_JELLY_TEXTURE_UNDERWATER = new ResourceLocation("the_bumblezone:textures/misc/royal_jelly_fluid_underwater.png");

    public static boolean renderHoneyOverlay(Player clientPlayerEntity, PoseStack matrixStack) {
        BlockState state = clientPlayerEntity.m_9236_().m_8055_(BlockPos.m_274446_((Position)clientPlayerEntity.m_20299_(1.0f)));
        if (state.m_60713_((Block)BzFluids.HONEY_FLUID_BLOCK.get()) || state.m_60713_((Block)BzFluids.ROYAL_JELLY_FLUID_BLOCK.get())) {
            if (state.m_61138_((Property)HoneyFluidBlock.BOTTOM_LEVEL)) {
                double yOffset = Math.abs(clientPlayerEntity.m_20299_(1.0f).m_7098_() - Math.floor(clientPlayerEntity.m_20299_(1.0f).m_7098_()));
                if ((double)((Integer)state.m_61143_((Property)HoneyFluidBlock.BOTTOM_LEVEL)).intValue() / 8.0 > yOffset + 0.1) {
                    return false;
                }
            }
            RenderSystem.setShader(GameRenderer::m_172817_);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)(state.m_60713_((Block)BzFluids.HONEY_FLUID_BLOCK.get()) ? HONEY_TEXTURE_UNDERWATER : ROYAL_JELLY_TEXTURE_UNDERWATER));
            BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
            float brightness = (float)Math.max(Math.pow(FluidClientOverlay.getDimensionBrightnessAtEyes((Entity)clientPlayerEntity), 2.0), (double)clientPlayerEntity.m_9236_().m_6042_().f_63838_());
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            float[] olderShaderColor = (float[])RenderSystem.getShaderColor().clone();
            RenderSystem.setShaderColor((float)brightness, (float)brightness, (float)brightness, (float)0.95f);
            float modifiedYaw = -clientPlayerEntity.m_146908_() / 512.0f;
            float modifiedPitch = clientPlayerEntity.m_146909_() / 512.0f;
            Matrix4f matrix4f = matrixStack.m_85850_().m_252922_();
            bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
            bufferBuilder.m_252986_(matrix4f, -1.0f, -1.0f, -0.5f).m_7421_(1.0f + modifiedYaw, 1.0f + modifiedPitch).m_5752_();
            bufferBuilder.m_252986_(matrix4f, 1.0f, -1.0f, -0.5f).m_7421_(0.0f + modifiedYaw, 2.0f + modifiedPitch).m_5752_();
            bufferBuilder.m_252986_(matrix4f, 1.0f, 1.0f, -0.5f).m_7421_(1.0f + modifiedYaw, 1.0f + modifiedPitch).m_5752_();
            bufferBuilder.m_252986_(matrix4f, -1.0f, 1.0f, -0.5f).m_7421_(2.0f + modifiedYaw, 0.0f + modifiedPitch).m_5752_();
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
            RenderSystem.setShaderColor((float)olderShaderColor[0], (float)olderShaderColor[1], (float)olderShaderColor[2], (float)olderShaderColor[3]);
            RenderSystem.disableBlend();
            return true;
        }
        return false;
    }

    public static float getDimensionBrightnessAtEyes(Entity entity) {
        float lightLevelAtEyes;
        Level level = entity.m_9236_();
        if (level.m_6042_().f_223549_()) {
            lightLevelAtEyes = level.m_45524_(BlockPos.m_274446_((Position)entity.m_20299_(1.0f)), level.m_7445_());
            level.m_46465_();
            if (level.m_46462_()) {
                float moonBrightness = level.m_46940_();
                lightLevelAtEyes *= moonBrightness;
            }
        } else {
            lightLevelAtEyes = level.m_45524_(BlockPos.m_274446_((Position)entity.m_20299_(1.0f)), 0);
        }
        return lightLevelAtEyes / 15.0f;
    }
}

