/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.entities.teleportation;

import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.configs.BzDimensionConfigs;
import com.telepathicgrunt.the_bumblezone.entities.teleportation.EntityTeleportationBackend;
import com.telepathicgrunt.the_bumblezone.modinit.BzDimension;
import com.telepathicgrunt.the_bumblezone.modules.base.ModuleHelper;
import com.telepathicgrunt.the_bumblezone.modules.registry.ModuleRegistry;
import com.telepathicgrunt.the_bumblezone.utils.PlatformHooks;
import com.telepathicgrunt.the_bumblezone.utils.ThreadExecutor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundChangeDifficultyPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerAbilitiesPacket;
import net.minecraft.network.protocol.game.ClientboundRespawnPacket;
import net.minecraft.network.protocol.game.ClientboundSetExperiencePacket;
import net.minecraft.network.protocol.game.ClientboundUpdateMobEffectPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraft.world.phys.Vec3;

public class BzWorldSavedData
extends SavedData {
    private static final String TELEPORTATION_DATA = "the_bumblezoneteleportation";
    private static final BzWorldSavedData CLIENT_DUMMY = new BzWorldSavedData(null);
    private static final List<QueuedEntityData> QUEUED_ENTITIES_TO_TELEPORT_FOR_BUMBLEZONE = new ArrayList<QueuedEntityData>();
    private static final List<QueuedEntityData> QUEUED_ENTITIES_TO_GENERIC_TELEPORT = new ArrayList<QueuedEntityData>();
    private static final List<NextTickRunnable> RUNNABLES_FOR_NEXT_TICK = new ArrayList<NextTickRunnable>();

    public BzWorldSavedData(CompoundTag tag) {
    }

    public static BzWorldSavedData get(Level world) {
        if (!(world instanceof ServerLevel)) {
            return CLIENT_DUMMY;
        }
        DimensionDataStorage storage = ((ServerLevel)world).m_8895_();
        return (BzWorldSavedData)storage.m_164858_(BzWorldSavedData::new, TELEPORTATION_DATA);
    }

    public CompoundTag m_7176_(CompoundTag data) {
        return null;
    }

    public static void queueEntityToTeleport(Entity entity, ResourceKey<Level> destination) {
        if (entity != null && !entity.m_9236_().m_5776_() && !BzWorldSavedData.isEntityQueuedToTeleportAlready(entity)) {
            QUEUED_ENTITIES_TO_TELEPORT_FOR_BUMBLEZONE.add(new QueuedEntityData(entity, destination));
        }
    }

    public static void queueEntityToGenericTeleport(Entity entity, ResourceKey<Level> destination, BlockPos destinationPos, Runnable runnable) {
        if (entity != null && !entity.m_9236_().m_5776_() && !BzWorldSavedData.isEntityQueuedToGenericTeleportAlready(entity)) {
            QUEUED_ENTITIES_TO_GENERIC_TELEPORT.add(new QueuedEntityData(entity, destination, destinationPos, runnable));
        }
    }

    public static boolean isEntityQueuedToTeleportAlready(Entity entity) {
        return QUEUED_ENTITIES_TO_TELEPORT_FOR_BUMBLEZONE.stream().anyMatch(entry -> entry.getEntity().equals((Object)entity));
    }

    public static boolean isEntityQueuedToGenericTeleportAlready(Entity entity) {
        return QUEUED_ENTITIES_TO_GENERIC_TELEPORT.stream().anyMatch(entry -> entry.getEntity().equals((Object)entity));
    }

    public static void tick(ServerLevel world) {
        Entity entity;
        ResourceKey<Level> destinationKey;
        HashSet<Entity> teleportedEntities;
        RUNNABLES_FOR_NEXT_TICK.removeIf(r -> r.executeTick(world));
        if (QUEUED_ENTITIES_TO_GENERIC_TELEPORT.size() > 0) {
            teleportedEntities = new HashSet<Entity>();
            for (QueuedEntityData entry2 : QUEUED_ENTITIES_TO_GENERIC_TELEPORT) {
                destinationKey = entry2.getDestination();
                BlockPos destinationPos = entry2.getDestinationPos();
                entity = entry2.getEntity();
                ServerLevel destination = world.m_6018_().m_7654_().m_129880_(destinationKey);
                BzWorldSavedData.baseTeleporting(entity, destinationPos.m_252807_(), destination, teleportedEntities, entity);
                entry2.runnable.run();
            }
            QUEUED_ENTITIES_TO_GENERIC_TELEPORT.removeIf(entry -> teleportedEntities.contains(entry.getEntity()));
        }
        if (QUEUED_ENTITIES_TO_TELEPORT_FOR_BUMBLEZONE.size() > 0) {
            teleportedEntities = new HashSet();
            for (QueuedEntityData entry2 : QUEUED_ENTITIES_TO_TELEPORT_FOR_BUMBLEZONE) {
                Entity entity2;
                if (!entry2.getIsCurrentTeleporting()) {
                    ServerPlayer serverPlayer;
                    entry2.setIsCurrentTeleporting(true);
                    destinationKey = entry2.getDestination();
                    if (destinationKey.equals(BzDimension.BZ_WORLD_KEY)) {
                        entity = entry2.getEntity();
                        if (entity instanceof ServerPlayer) {
                            serverPlayer = (ServerPlayer)entity;
                            serverPlayer.m_5661_((Component)Component.m_237115_((String)"system.the_bumblezone.teleporting_into_bz"), true);
                        }
                        ThreadExecutor.dimensionDestinationSearch(world.m_7654_(), () -> {
                            try {
                                ServerLevel bumblezoneWorld = world.m_7654_().m_129880_(BzDimension.BZ_WORLD_KEY);
                                return Optional.of(EntityTeleportationBackend.getBzCoordinate(entry2.getEntity(), world, bumblezoneWorld));
                            }
                            catch (Throwable e) {
                                Bumblezone.LOGGER.error("Bumblezone: Failed to teleport entity. Error:", e);
                                return Optional.empty();
                            }
                        }).thenOnServerThread(entry2::setDestinationPosFound);
                        continue;
                    }
                    entity = entry2.getEntity();
                    if (entity instanceof ServerPlayer) {
                        serverPlayer = (ServerPlayer)entity;
                        serverPlayer.m_5661_((Component)Component.m_237115_((String)"system.the_bumblezone.teleporting_out_of_bz"), true);
                    }
                    ThreadExecutor.dimensionDestinationSearch(world.m_7654_(), () -> {
                        try {
                            ServerLevel destination = world.m_6018_().m_7654_().m_129880_(destinationKey);
                            return Optional.of(EntityTeleportationBackend.destPostFromOutOfBoundsTeleport(entry2.getEntity(), destination));
                        }
                        catch (Throwable e) {
                            Bumblezone.LOGGER.error("Bumblezone: Failed to teleport entity. Error:", e);
                            return Optional.empty();
                        }
                    }).thenOnServerThread(entry2::setDestinationPosFound);
                    continue;
                }
                if (entry2.getDestinationPosFound() == null || teleportedEntities.contains(entity2 = entry2.getEntity())) continue;
                ResourceKey<Level> destinationKey2 = entry2.getDestination();
                ServerLevel destination = world.m_6018_().m_7654_().m_129880_(destinationKey2);
                if (entry2.getDestinationPosFound().isPresent()) {
                    Vec3 destinationPos = entry2.getDestinationPosFound().get();
                    if (destinationKey2.equals(BzDimension.BZ_WORLD_KEY)) {
                        BzWorldSavedData.enteringBumblezone(entity2, destinationPos, teleportedEntities);
                        continue;
                    }
                    if (entity2.m_6688_() != null) {
                        BzWorldSavedData.exitingBumblezone((Entity)entity2.m_6688_(), destinationPos, destination, teleportedEntities);
                        continue;
                    }
                    BzWorldSavedData.exitingBumblezone(entity2, destinationPos, destination, teleportedEntities);
                    continue;
                }
                teleportedEntities.add(entity2);
                if (!(entity2 instanceof ServerPlayer)) continue;
                ServerPlayer serverPlayer = (ServerPlayer)entity2;
                serverPlayer.m_5661_((Component)Component.m_237115_((String)"system.the_bumblezone.failed_teleporting"), false);
                Bumblezone.LOGGER.error("Bumblezone: Failed to teleport entity. Aborting teleportation. Please retry. Entity: {}-{} Pos: {} Destination: {}", new Object[]{entity2.getClass().getSimpleName(), entity2.m_7755_(), entity2.m_20182_(), destinationKey2});
            }
            QUEUED_ENTITIES_TO_TELEPORT_FOR_BUMBLEZONE.removeIf(entry -> teleportedEntities.contains(entry.getEntity()));
        }
    }

    public static void enteringBumblezone(Entity entity, Vec3 destinationPosFound, Set<Entity> teleportedEntities) {
        if (!entity.m_9236_().m_5776_()) {
            MinecraftServer minecraftServer = entity.m_20194_();
            ServerLevel bumblezoneWorld = minecraftServer.m_129880_(BzDimension.BZ_WORLD_KEY);
            BlockPos blockPos = BlockPos.m_274446_((Position)destinationPosFound);
            if (bumblezoneWorld != null) {
                if (bumblezoneWorld.m_8055_(blockPos.m_7494_()).m_60828_((BlockGetter)bumblezoneWorld, blockPos.m_7494_())) {
                    RUNNABLES_FOR_NEXT_TICK.add(new NextTickRunnable(bumblezoneWorld.m_46467_() + 5L, () -> {
                        ServerPlayer fakePlayer = BzWorldSavedData.createSilkTouchFakePlayer(bumblezoneWorld);
                        BzWorldSavedData.destroyAndPlaceBlock(bumblezoneWorld, fakePlayer, blockPos, Blocks.f_50016_);
                        BzWorldSavedData.destroyAndPlaceBlock(bumblezoneWorld, fakePlayer, blockPos.m_7494_(), Blocks.f_50016_);
                        BzWorldSavedData.destroyAndPlaceBlock(bumblezoneWorld, fakePlayer, blockPos.m_7495_(), Blocks.f_50720_);
                        BzWorldSavedData.destroyAndPlaceBlock(bumblezoneWorld, fakePlayer, blockPos.m_7494_().m_7494_(), Blocks.f_50720_);
                        BzWorldSavedData.destroyAndPlaceBlock(bumblezoneWorld, fakePlayer, blockPos.m_122012_(), Blocks.f_50720_);
                        BzWorldSavedData.destroyAndPlaceBlock(bumblezoneWorld, fakePlayer, blockPos.m_122024_(), Blocks.f_50720_);
                        BzWorldSavedData.destroyAndPlaceBlock(bumblezoneWorld, fakePlayer, blockPos.m_122029_(), Blocks.f_50720_);
                        BzWorldSavedData.destroyAndPlaceBlock(bumblezoneWorld, fakePlayer, blockPos.m_122019_(), Blocks.f_50720_);
                        BzWorldSavedData.destroyAndPlaceBlock(bumblezoneWorld, fakePlayer, blockPos.m_122012_().m_7494_(), Blocks.f_50720_);
                        BzWorldSavedData.destroyAndPlaceBlock(bumblezoneWorld, fakePlayer, blockPos.m_122024_().m_7494_(), Blocks.f_50720_);
                        BzWorldSavedData.destroyAndPlaceBlock(bumblezoneWorld, fakePlayer, blockPos.m_122029_().m_7494_(), Blocks.f_50720_);
                        BzWorldSavedData.destroyAndPlaceBlock(bumblezoneWorld, fakePlayer, blockPos.m_122019_().m_7494_(), Blocks.f_50720_);
                    }));
                }
                if (BzDimensionConfigs.enableInitialWelcomeMessage && entity instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)entity;
                    RUNNABLES_FOR_NEXT_TICK.add(new NextTickRunnable(bumblezoneWorld.m_46467_() + 20L, () -> ModuleHelper.getModule((Entity)serverPlayer, ModuleRegistry.PLAYER_DATA).ifPresent(playerData -> {
                        if (!playerData.gottenWelcomedInDimension) {
                            playerData.gottenWelcomedInDimension = true;
                            serverPlayer.m_5661_((Component)Component.m_237115_((String)"system.the_bumblezone.advancement_hint"), false);
                        }
                    })));
                }
            }
            ModuleHelper.getModule(entity, ModuleRegistry.ENTITY_POS_AND_DIM).ifPresent(capability -> {
                capability.setNonBZPos(entity.m_20182_());
                capability.setNonBZDim(entity.m_9236_().m_46472_().m_135782_());
                if (bumblezoneWorld == null) {
                    if (entity instanceof ServerPlayer) {
                        ServerPlayer playerEntity = (ServerPlayer)entity;
                        Bumblezone.LOGGER.info("Bumblezone: Please restart the server. The Bumblezone dimension hasn't been made yet due to this bug: https://bugs.mojang.com/browse/MC-195468. A restart will fix this.");
                        MutableComponent message = Component.m_237110_((String)"system.the_bumblezone.missing_dimension", (Object[])new Object[]{Component.m_237115_((String)"system.the_bumblezone.missing_dimension_link").m_130940_(ChatFormatting.RED)});
                        playerEntity.m_5661_((Component)message, false);
                    }
                    teleportedEntities.add(entity);
                    return;
                }
                Entity baseVehicle = entity.m_20201_();
                BzWorldSavedData.baseTeleporting(entity, destinationPosFound, bumblezoneWorld, teleportedEntities, baseVehicle);
            });
        }
    }

    public static void exitingBumblezone(Entity entity, Vec3 destinationPosition, ServerLevel destination, Set<Entity> teleportedEntities) {
        BlockPos destBlockPos = BlockPos.m_274446_((Position)destinationPosition);
        if (destination.m_8055_(destBlockPos.m_7494_()).m_60828_((BlockGetter)destination, destBlockPos.m_7494_())) {
            RUNNABLES_FOR_NEXT_TICK.add(new NextTickRunnable(destination.m_46467_() + 5L, () -> {
                ServerPlayer fakePlayer = BzWorldSavedData.createSilkTouchFakePlayer(destination);
                BzWorldSavedData.destroyAndPlaceBlock(destination, fakePlayer, destBlockPos, Blocks.f_50016_);
                BzWorldSavedData.destroyAndPlaceBlock(destination, fakePlayer, destBlockPos.m_7494_(), Blocks.f_50016_);
            }));
        }
        Entity baseVehicle = entity.m_20201_();
        BzWorldSavedData.baseTeleporting(entity, destinationPosition, destination, teleportedEntities, baseVehicle);
    }

    private static void destroyAndPlaceBlock(ServerLevel level, ServerPlayer fakePlayer, BlockPos blockPos, Block block) {
        BlockState state = level.m_8055_(blockPos);
        BlockEntity blockEntity = state.m_155947_() ? level.m_7702_(blockPos) : null;
        Block.m_49881_((BlockState)state, (Level)level, (BlockPos)blockPos, (BlockEntity)blockEntity, (Entity)fakePlayer, (ItemStack)fakePlayer.m_21205_());
        level.m_46597_(blockPos, block.m_49966_());
    }

    private static ServerPlayer createSilkTouchFakePlayer(ServerLevel level) {
        ServerPlayer serverPlayer = PlatformHooks.getFakePlayer(level, null);
        ItemStack fakeHandItem = Items.f_42427_.m_7968_();
        HashMap<Enchantment, Integer> enchantmentHashMap = new HashMap<Enchantment, Integer>();
        enchantmentHashMap.put(Enchantments.f_44985_, 1);
        EnchantmentHelper.m_44865_(enchantmentHashMap, (ItemStack)fakeHandItem);
        serverPlayer.m_21008_(InteractionHand.MAIN_HAND, fakeHandItem);
        return serverPlayer;
    }

    private static void baseTeleporting(Entity entity, Vec3 destinationPosition, ServerLevel destination, Set<Entity> teleportedEntities, Entity baseVehicle) {
        BzWorldSavedData.teleportEntityAndAssignToVehicle(baseVehicle, null, destination, destinationPosition, teleportedEntities);
        ((ServerLevel)entity.m_9236_()).m_8886_();
        destination.m_8886_();
    }

    private static void teleportEntityAndAssignToVehicle(Entity entity, Entity vehicle, ServerLevel destination, Vec3 destinationPosition, Set<Entity> teleportedEntities) {
        Entity teleportedEntity;
        List passengers = entity.m_20197_();
        entity.m_20153_();
        entity.m_20091_();
        if (destination.m_46472_().equals(BzDimension.BZ_WORLD_KEY)) {
            ModuleHelper.getModule(entity, ModuleRegistry.ENTITY_POS_AND_DIM).ifPresent(capability -> {
                capability.setNonBZPos(entity.m_20182_());
                capability.setNonBZDim(entity.m_9236_().m_46472_().m_135782_());
            });
        }
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            if (serverPlayer.m_5803_()) {
                serverPlayer.m_6145_(true, true);
            }
            if (PlatformHooks.isDimensionAllowed(serverPlayer, (ResourceKey<Level>)destination.m_46472_())) {
                serverPlayer.f_8906_.m_9829_((Packet)new ClientboundRespawnPacket(destination.m_220362_(), destination.m_46472_(), BiomeManager.m_47877_((long)destination.m_7328_()), serverPlayer.f_8941_.m_9290_(), serverPlayer.f_8941_.m_9293_(), destination.m_46659_(), destination.m_8584_(), 3, serverPlayer.m_219759_(), serverPlayer.m_287157_()));
                serverPlayer.m_8999_(destination, destinationPosition.f_82479_, destinationPosition.f_82480_ + (double)0.1f, destinationPosition.f_82481_, serverPlayer.m_146908_(), serverPlayer.m_146909_());
                serverPlayer.f_8906_.m_9829_((Packet)new ClientboundChangeDifficultyPacket(destination.m_46791_(), destination.m_6106_().m_5474_()));
                serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetExperiencePacket(serverPlayer.f_36080_, serverPlayer.f_36079_, serverPlayer.f_36078_));
                serverPlayer.f_8906_.m_9829_((Packet)new ClientboundPlayerAbilitiesPacket(serverPlayer.m_150110_()));
                serverPlayer.f_8924_.m_6846_().m_11229_(serverPlayer, destination);
                serverPlayer.f_8924_.m_6846_().m_11289_(serverPlayer);
                serverPlayer.m_287199_(100);
                serverPlayer.m_7292_(new MobEffectInstance(MobEffects.f_19591_, 20, 1, false, false, false));
                serverPlayer.f_8924_.m_6846_().m_11292_(serverPlayer);
                teleportedEntity = destination.m_46003_(serverPlayer.m_20148_());
            } else {
                teleportedEntity = null;
            }
        } else {
            Entity newEntity = entity;
            if ((newEntity = newEntity.m_6095_().m_20615_((Level)destination)) == null) {
                return;
            }
            newEntity.m_20361_(entity);
            newEntity.m_7678_(destinationPosition.f_82479_, destinationPosition.f_82480_, destinationPosition.f_82481_, entity.m_146908_(), entity.m_146909_());
            newEntity.m_287199_(100);
            destination.m_143334_(newEntity);
            teleportedEntity = newEntity;
            entity.m_142687_(Entity.RemovalReason.CHANGED_DIMENSION);
        }
        teleportedEntities.add(entity);
        if (teleportedEntity != null) {
            ChunkPos chunkpos = new ChunkPos(BlockPos.m_274561_((double)destinationPosition.f_82479_, (double)destinationPosition.f_82480_, (double)destinationPosition.f_82481_));
            destination.m_7726_().m_8387_(TicketType.f_9448_, chunkpos, 1, (Object)entity.m_19879_());
            if (vehicle != null) {
                teleportedEntity.m_20329_(vehicle);
            }
            if (teleportedEntity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)teleportedEntity;
                if (livingEntity instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
                    for (MobEffectInstance effectInstance : new ArrayList(livingEntity.m_21220_())) {
                        serverPlayer.f_8906_.m_9829_((Packet)new ClientboundUpdateMobEffectPacket(serverPlayer.m_19879_(), effectInstance));
                    }
                } else {
                    BzWorldSavedData.reAddStatusEffect(livingEntity);
                }
            }
            passengers.forEach(passenger -> BzWorldSavedData.teleportEntityAndAssignToVehicle(passenger, teleportedEntity, destination, destinationPosition, teleportedEntities));
        }
    }

    private static void reAddStatusEffect(LivingEntity livingEntity) {
        ArrayList effectInstanceList = new ArrayList(livingEntity.m_21220_());
        for (int i = effectInstanceList.size() - 1; i >= 0; --i) {
            MobEffectInstance effectInstance = (MobEffectInstance)effectInstanceList.get(i);
            if (effectInstance == null) continue;
            livingEntity.m_21195_(effectInstance.m_19544_());
            livingEntity.m_7292_(new MobEffectInstance(effectInstance.m_19544_(), effectInstance.m_19557_(), effectInstance.m_19564_(), effectInstance.m_19571_(), effectInstance.m_19572_(), effectInstance.m_19575_()));
        }
    }

    private static final class QueuedEntityData {
        private final Entity entity;
        private final ResourceKey<Level> destination;
        private final BlockPos destinationPos;
        private final Runnable runnable;
        private boolean isCurrentTeleporting = false;
        private Optional<Vec3> destinationPosFound = null;

        public QueuedEntityData(Entity entity, ResourceKey<Level> destination) {
            this.entity = entity;
            this.destination = destination;
            this.destinationPos = null;
            this.runnable = null;
        }

        public QueuedEntityData(Entity entity, ResourceKey<Level> destination, BlockPos destinationPos, Runnable runnable) {
            this.entity = entity;
            this.destination = destination;
            this.destinationPos = destinationPos;
            this.runnable = runnable;
        }

        public Entity getEntity() {
            return this.entity;
        }

        public ResourceKey<Level> getDestination() {
            return this.destination;
        }

        public BlockPos getDestinationPos() {
            return this.destinationPos;
        }

        public Runnable getRunnable() {
            return this.runnable;
        }

        public Optional<Vec3> getDestinationPosFound() {
            return this.destinationPosFound;
        }

        public void setDestinationPosFound(Optional<Vec3> destinationPosFound) {
            this.destinationPosFound = destinationPosFound;
        }

        public boolean getIsCurrentTeleporting() {
            return this.isCurrentTeleporting;
        }

        public void setIsCurrentTeleporting(boolean isCurrentTeleporting) {
            this.isCurrentTeleporting = isCurrentTeleporting;
        }
    }

    private record NextTickRunnable(long targetTick, Runnable runnable) {
        public boolean executeTick(ServerLevel serverLevel) {
            if (serverLevel.m_46467_() >= this.targetTick()) {
                this.runnable.run();
                return true;
            }
            return false;
        }
    }
}

