/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.blocks;

import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.blocks.blockentities.EssenceBlockEntity;
import com.telepathicgrunt.the_bumblezone.bossbars.ServerEssenceEvent;
import com.telepathicgrunt.the_bumblezone.entities.living.CosmicCrystalEntity;
import com.telepathicgrunt.the_bumblezone.items.essence.EssenceOfTheBees;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlockEntities;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzParticles;
import com.telepathicgrunt.the_bumblezone.platform.BlockExtension;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import com.telepathicgrunt.the_bumblezone.utils.OptionalBoolean;
import com.telepathicgrunt.the_bumblezone.worldgen.processors.ArenaSpecialBlockHandlerProcessor;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public abstract class EssenceBlock
extends BaseEntityBlock
implements BlockExtension {
    private static final VoxelShape ALMOST_BLOCK = Block.m_49796_((double)1.0E-4, (double)1.0E-4, (double)1.0E-4, (double)0.9999, (double)0.9999, (double)0.9999);
    public static final GeneralUtils.Lazy<StructurePlaceSettings> PLACEMENT_SETTINGS = new GeneralUtils.Lazy<StructurePlaceSettings>(() -> new StructurePlaceSettings().m_74379_(Rotation.NONE).m_74377_(Mirror.NONE).m_163782_(false).m_74392_(true).m_74402_(true).m_74383_((StructureProcessor)new BlockIgnoreProcessor(List.of(BzBlocks.ESSENCE_BLOCK_RED.get(), BzBlocks.ESSENCE_BLOCK_PURPLE.get(), BzBlocks.ESSENCE_BLOCK_BLUE.get(), BzBlocks.ESSENCE_BLOCK_GREEN.get(), BzBlocks.ESSENCE_BLOCK_YELLOW.get(), BzBlocks.ESSENCE_BLOCK_WHITE.get(), BzBlocks.INFINITY_BARRIER.get()))).m_74383_((StructureProcessor)new ArenaSpecialBlockHandlerProcessor(false)));
    public static final GeneralUtils.Lazy<StructurePlaceSettings> PLACEMENT_SETTINGS_WITH_ENTITIES = new GeneralUtils.Lazy<StructurePlaceSettings>(() -> new StructurePlaceSettings().m_74379_(Rotation.NONE).m_74377_(Mirror.NONE).m_163782_(false).m_74392_(false).m_74402_(true).m_74383_((StructureProcessor)new BlockIgnoreProcessor(List.of(BzBlocks.ESSENCE_BLOCK_RED.get(), BzBlocks.ESSENCE_BLOCK_PURPLE.get(), BzBlocks.ESSENCE_BLOCK_BLUE.get(), BzBlocks.ESSENCE_BLOCK_GREEN.get(), BzBlocks.ESSENCE_BLOCK_YELLOW.get(), BzBlocks.ESSENCE_BLOCK_WHITE.get()))).m_74383_((StructureProcessor)new ArenaSpecialBlockHandlerProcessor(true)));

    public EssenceBlock(BlockBehaviour.Properties properties) {
        super(properties.m_60913_(-1.0f, 3600000.8f).m_60953_(blockState -> 15).m_222994_().m_280606_().m_60922_((blockState, blockGetter, blockPos, entityType) -> false).m_60971_((blockState, blockGetter, blockPos) -> false).m_278166_(PushReaction.BLOCK));
    }

    public VoxelShape m_7952_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        return Shapes.m_83144_();
    }

    public RenderShape m_7514_(BlockState blockState) {
        return RenderShape.MODEL;
    }

    public VoxelShape m_5939_(BlockState blockState, BlockGetter level, BlockPos blockPos, CollisionContext context) {
        if (context instanceof EntityCollisionContext) {
            EntityCollisionContext ctx = (EntityCollisionContext)context;
            Entity entity = ctx.m_193113_();
            if (entity == null || entity instanceof CosmicCrystalEntity || entity.m_5833_()) {
                return Shapes.m_83040_();
            }
            if (entity instanceof LivingEntity || entity instanceof Player) {
                return ALMOST_BLOCK;
            }
        }
        return Shapes.m_83040_();
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new EssenceBlockEntity(blockPos, blockState);
    }

    public abstract ResourceLocation getArenaNbt();

    public abstract int getEventTimeFrame();

    public abstract void performUniqueArenaTick(ServerLevel var1, BlockPos var2, BlockState var3, EssenceBlockEntity var4);

    public abstract ServerEssenceEvent getServerEssenceEvent();

    public abstract ResourceLocation getEssenceItemReward();

    public abstract void awardPlayerWinStat(ServerPlayer var1);

    public abstract int getEssenceXpReward();

    public abstract boolean hasMiningFatigue();

    public void onPlayerEnter(ServerLevel serverLevel, ServerPlayer serverPlayer, EssenceBlockEntity essenceBlockEntity) {
    }

    public void onPlayerLeave(ServerLevel serverLevel, ServerPlayer serverPlayer, EssenceBlockEntity essenceBlockEntity) {
        if (serverPlayer.m_21023_(MobEffects.f_19599_)) {
            serverPlayer.m_21195_(MobEffects.f_19599_);
        }
    }

    public boolean m_7420_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        return true;
    }

    public void m_7892_(BlockState blockState, Level level, BlockPos blockPos, Entity entity) {
        EssenceBlockEntity essenceBlockEntity;
        ServerLevel serverLevel;
        BlockEntity blockEntity;
        ServerPlayer touchingPlayer;
        ServerPlayer serverPlayer;
        boolean isNonEssencedServerPlayer;
        Player player;
        Block block = blockState.m_60734_();
        if (!(block instanceof EssenceBlock)) {
            return;
        }
        EssenceBlock essenceBlock = (EssenceBlock)block;
        Vec3 center = Vec3.m_82512_((Vec3i)blockPos);
        float powerPush = entity instanceof Player && (player = (Player)entity).m_20096_() ? 10 : 1;
        entity.m_5997_((entity.m_20185_() - center.m_7096_()) * (double)powerPush, (entity.m_20186_() - center.m_7098_()) * (double)powerPush, (entity.m_20189_() - center.m_7094_()) * (double)powerPush);
        boolean isClientside = entity.m_9236_().m_5776_();
        boolean isNonPlayer = entity instanceof LivingEntity && !(entity instanceof Player);
        boolean bl = isNonEssencedServerPlayer = entity instanceof ServerPlayer && !EssenceOfTheBees.hasEssence(serverPlayer = (ServerPlayer)entity);
        if ((isClientside || isNonPlayer || isNonEssencedServerPlayer) && !isClientside) {
            if (entity instanceof ServerPlayer) {
                EssenceBlockEntity essenceBlockEntity2;
                serverPlayer = (ServerPlayer)entity;
                BlockEntity blockEntity2 = level.m_7702_(blockPos);
                if (blockEntity2 instanceof EssenceBlockEntity && (essenceBlockEntity2 = (EssenceBlockEntity)blockEntity2).getPlayerInArena().isEmpty()) {
                    serverPlayer.m_5661_((Component)Component.m_237115_((String)"essence.the_bumblezone.missing_essence_effect").m_130940_(ChatFormatting.RED), true);
                }
            }
            entity.m_6469_(entity.m_269291_().m_269425_(), 0.5f);
        }
        if (entity instanceof ServerPlayer && EssenceOfTheBees.hasEssence(touchingPlayer = (ServerPlayer)entity) && (blockEntity = (serverLevel = (ServerLevel)level).m_7702_(blockPos)) instanceof EssenceBlockEntity && (essenceBlockEntity = (EssenceBlockEntity)blockEntity).getPlayerInArena().isEmpty()) {
            StructureTemplateManager structureTemplateManager = serverLevel.m_215082_();
            Optional optionalStructureTemplate = structureTemplateManager.m_230407_(this.getArenaNbt());
            optionalStructureTemplate.ifPresentOrElse(loadingStructureTemplate -> {
                StructureTemplate savingStructureTemplate;
                Vec3i size = loadingStructureTemplate.m_163801_();
                BlockPos negativeHalfLengths = new BlockPos(-size.m_123341_() / 2, -size.m_123342_() / 2, -size.m_123343_() / 2);
                essenceBlockEntity.setArenaSize(new BlockPos(size));
                try {
                    savingStructureTemplate = structureTemplateManager.m_230359_(essenceBlockEntity.getSavedNbtLocation());
                }
                catch (Exception exception) {
                    Bumblezone.LOGGER.error("Bumblezone Essence Block failed to create the NBT file to save area - {} - {} - {} - Location: {} - Error: {}", new Object[]{blockState, blockPos, this.getArenaNbt(), essenceBlockEntity.getSavedNbtLocationAsString(), exception});
                    return;
                }
                savingStructureTemplate.m_163802_((Level)serverLevel, blockPos.m_121955_((Vec3i)negativeHalfLengths), size, !PLACEMENT_SETTINGS.getOrFillFromInternal().m_74408_(), (Block)essenceBlock);
                try {
                    structureTemplateManager.m_230416_(essenceBlockEntity.getSavedNbtLocation());
                }
                catch (Exception exception) {
                    Bumblezone.LOGGER.error("Bumblezone Essence Block failed to save area into NBT file - {} - {} - {} - Location: {} - Error: {}", new Object[]{blockState, blockPos, this.getArenaNbt(), essenceBlockEntity.getSavedNbtLocationAsString(), exception});
                    return;
                }
                GeneralUtils.placeInWorldWithoutNeighborUpdate((ServerLevelAccessor)serverLevel, loadingStructureTemplate, blockPos.m_121955_((Vec3i)negativeHalfLengths), blockPos.m_121955_((Vec3i)negativeHalfLengths), PLACEMENT_SETTINGS_WITH_ENTITIES.getOrFillFromInternal().m_74385_(blockPos), serverLevel.m_213780_(), 18);
                List players = ((ServerLevel)level).m_8795_(p -> blockPos.m_123341_() + size.m_123341_() > p.m_20183_().m_123341_() && blockPos.m_123342_() + size.m_123342_() > p.m_20183_().m_123342_() && blockPos.m_123343_() + size.m_123343_() > p.m_20183_().m_123343_() && blockPos.m_123341_() - size.m_123341_() < p.m_20183_().m_123341_() && blockPos.m_123342_() - size.m_123342_() < p.m_20183_().m_123342_() && blockPos.m_123343_() - size.m_123343_() < p.m_20183_().m_123343_());
                essenceBlockEntity.getPlayerInArena().clear();
                for (ServerPlayer serverPlayer : players) {
                    essenceBlock.onPlayerEnter(serverLevel, serverPlayer, essenceBlockEntity);
                    essenceBlockEntity.getPlayerInArena().add(serverPlayer.m_20148_());
                    if (serverPlayer != touchingPlayer) {
                        serverPlayer.m_20334_(touchingPlayer.m_20184_().m_7096_(), touchingPlayer.m_20184_().m_7098_(), touchingPlayer.m_20184_().m_7094_());
                        serverPlayer.m_6021_(touchingPlayer.m_20185_(), touchingPlayer.m_20186_(), touchingPlayer.m_20189_());
                    }
                    EssenceBlock.spawnParticles(serverLevel, serverPlayer.m_20182_(), serverPlayer.m_217043_());
                    for (int x = -1; x <= 1; ++x) {
                        for (int z = -1; z <= 1; ++z) {
                            ChunkPos chunkPos = new ChunkPos(blockPos);
                            serverLevel.m_6325_(chunkPos.f_45578_ + x, chunkPos.f_45579_ + z).m_6141_(1512000L);
                        }
                    }
                }
                essenceBlockEntity.getEventBar().m_142711_(1.0f);
                essenceBlockEntity.setEventTimer(this.getEventTimeFrame());
                essenceBlockEntity.m_6596_();
            }, () -> Bumblezone.LOGGER.error("Bumblezone Essence Block failed to even detect the nbt file at all {} - {} - {}", new Object[]{essenceBlockEntity, blockState, this.getArenaNbt()}));
        }
    }

    public VoxelShape m_7947_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        return Shapes.m_83040_();
    }

    public void m_214162_(BlockState blockState, Level level, BlockPos blockPos, RandomSource randomSource) {
        for (int i = 0; i <= 2; ++i) {
            level.m_7106_((ParticleOptions)BzParticles.SPARKLE_PARTICLE.get(), (double)blockPos.m_123341_() + randomSource.m_188500_() * 1.5 - 0.25, (double)blockPos.m_123342_() + randomSource.m_188500_() * 1.5 - 0.25, (double)blockPos.m_123343_() + randomSource.m_188500_() * 1.5 - 0.25, randomSource.m_188583_() * 0.003, randomSource.m_188583_() * 0.003, randomSource.m_188583_() * 0.003);
        }
    }

    public static void spawnParticles(ServerLevel world, Vec3 location, RandomSource random) {
        world.m_8767_((ParticleOptions)ParticleTypes.f_123815_, location.m_7096_(), location.m_7098_() + 1.0, location.m_7094_(), 100, random.m_188583_() * 0.1, random.m_188583_() * 0.1 + 0.1, random.m_188583_() * 0.1, (double)random.m_188501_() * 0.4 + (double)0.2f);
        world.m_8767_((ParticleOptions)ParticleTypes.f_123809_, location.m_7096_(), location.m_7098_() + 1.0, location.m_7094_(), 400, 1.0, 1.0, 1.0, (double)random.m_188501_() * 0.5 + (double)1.2f);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return EssenceBlock.createEssenceTicker(level, blockEntityType, BzBlockEntities.ESSENCE_BLOCK.get());
    }

    @Nullable
    protected static <T extends BlockEntity> BlockEntityTicker<T> createEssenceTicker(Level level, BlockEntityType<T> blockEntityType, BlockEntityType<? extends EssenceBlockEntity> blockEntityType2) {
        return level.f_46443_ ? null : EssenceBlock.m_152132_(blockEntityType, blockEntityType2, EssenceBlockEntity::serverTick);
    }

    @Override
    public OptionalBoolean bz$shouldNotDisplayFluidOverlay() {
        return OptionalBoolean.TRUE;
    }
}

