/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.blocks;

import com.google.common.collect.MapMaker;
import com.telepathicgrunt.the_bumblezone.entities.TemporaryPlayerData;
import com.telepathicgrunt.the_bumblezone.modcompat.ModChecker;
import com.telepathicgrunt.the_bumblezone.modcompat.ModCompat;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzParticles;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class HeavyAir
extends Block {
    private static final ConcurrentMap<String, Integer> APPLIED_PUSH_FOR_ENTITY = new MapMaker().concurrencyLevel(2).weakKeys().makeMap();

    public HeavyAir() {
        super(BlockBehaviour.Properties.m_284310_().m_60913_(-1.0f, 0.0f).m_60910_().m_280170_().m_222994_().m_60955_().m_278166_(PushReaction.DESTROY));
    }

    public boolean m_7420_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        return true;
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return collisionContext.m_7142_(BzItems.HEAVY_AIR.get()) ? Shapes.m_83144_() : Shapes.m_83040_();
    }

    public VoxelShape m_5939_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return Shapes.m_83040_();
    }

    public RenderShape m_7514_(BlockState blockState) {
        return RenderShape.INVISIBLE;
    }

    public float m_7749_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        return 1.0f;
    }

    public void m_7892_(BlockState blockState, Level level, BlockPos blockPos, Entity entity) {
        if (entity.m_6095_().m_204039_(BzTags.HEAVY_AIR_IMMUNE) || entity instanceof Projectile) {
            return;
        }
        if (APPLIED_PUSH_FOR_ENTITY.getOrDefault(entity.m_20149_(), -1) == entity.f_19797_) {
            return;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (livingEntity.f_19797_ % 10 == 0) {
                List<Holder> effectsToRemove = BuiltInRegistries.f_256974_.m_203431_(BzTags.HEAVY_AIR_REMOVE_EFFECTS).stream().flatMap(HolderSet.ListBacked::m_203614_).filter(Holder::m_203633_).toList();
                for (Holder effectToRemove : effectsToRemove) {
                    if (!livingEntity.m_21023_((MobEffect)effectToRemove.m_203334_())) continue;
                    livingEntity.m_21195_((MobEffect)effectToRemove.m_203334_());
                }
            }
        }
        double extraGravity = -0.005;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.m_7500_() && player.m_150110_().f_35935_ || player.m_5833_()) {
                return;
            }
            if (player.m_150110_().f_35935_) {
                player.m_150110_().f_35935_ = false;
                player.m_6885_();
            }
            if (entity instanceof TemporaryPlayerData) {
                TemporaryPlayerData temporaryPlayerData = (TemporaryPlayerData)entity;
                int ticksOffGround = temporaryPlayerData.bumblezonePlayerTickOffGroundInHeavyAir();
                int offsetTicks = Math.max(0, ticksOffGround - 10);
                extraGravity *= (double)(offsetTicks * 4 + 1);
            }
            for (ModCompat compat : ModChecker.HEAVY_AIR_RESTRICTED_COMPATS) {
                compat.restrictFlight(entity, extraGravity);
            }
            Entity vehicle = entity.m_275832_();
            if (vehicle != null) {
                vehicle.m_20334_(vehicle.m_20184_().f_82479_, vehicle.m_20184_().f_82480_ + extraGravity, vehicle.m_20184_().f_82481_);
            }
        }
        entity.m_20256_(entity.m_20184_().m_82520_(0.0, extraGravity, 0.0));
        APPLIED_PUSH_FOR_ENTITY.put(entity.m_20149_(), entity.f_19797_);
    }

    public static boolean isInHeavyAir(Level level, AABB boundingBox) {
        for (BlockPos pos : BlockPos.m_121976_((int)Mth.m_14107_((double)boundingBox.f_82288_), (int)Mth.m_14107_((double)boundingBox.f_82289_), (int)Mth.m_14107_((double)boundingBox.f_82290_), (int)Mth.m_14107_((double)boundingBox.f_82291_), (int)Mth.m_14107_((double)boundingBox.f_82292_), (int)Mth.m_14107_((double)boundingBox.f_82293_))) {
            if (!level.m_8055_(pos).m_60713_(BzBlocks.HEAVY_AIR.get())) continue;
            return true;
        }
        return false;
    }

    public void m_214162_(BlockState blockState, Level level, BlockPos blockPos, RandomSource randomSource) {
        if (randomSource.m_188501_() < 0.04f) {
            level.m_7106_((ParticleOptions)BzParticles.DUST_PARTICLE.get(), (double)blockPos.m_123341_() + randomSource.m_188500_(), (double)blockPos.m_123342_() + randomSource.m_188500_(), (double)blockPos.m_123343_() + randomSource.m_188500_(), randomSource.m_188583_() * 0.003, randomSource.m_188583_() * 2.0E-4, randomSource.m_188583_() * 0.003);
        }
    }
}

