/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.client.rendering.cosmiccrystal;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.telepathicgrunt.the_bumblezone.client.rendering.cosmiccrystal.CosmicCrystalAnimation;
import com.telepathicgrunt.the_bumblezone.entities.living.CosmicCrystalEntity;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class CosmicCrystalModel
extends HierarchicalModel<CosmicCrystalEntity> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("the_bumblezone", "cosmic_crystal"), "main");
    private final ModelPart root;
    private final ModelPart body;
    private final ModelPart spikes;
    private final ModelPart charging;

    public CosmicCrystalModel(ModelPart root) {
        super(RenderType::m_110473_);
        this.root = root;
        this.body = root.m_171324_("body");
        this.spikes = root.m_171324_("laser").m_171324_("spikes");
        this.charging = root.m_171324_("laser").m_171324_("charging");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)-0.15f));
        PartDefinition bottom = body.m_171599_("bottom", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-0.5f, (float)-5.0f, (float)-0.75f));
        PartDefinition insideB = bottom.m_171599_("insideB", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.6207f, (float)1.4229f, (float)0.783f));
        PartDefinition insideBottom_r1 = insideB.m_171599_("insideBottom_r1", CubeListBuilder.m_171558_().m_171514_(18, 38).m_171488_(-3.0f, -3.0f, -3.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(-1.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-1.1074f, (float)-0.4245f, (float)0.6825f));
        PartDefinition outsideB = bottom.m_171599_("outsideB", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.4954f, (float)1.2721f, (float)0.9316f));
        PartDefinition outsideBottom_r1 = outsideB.m_171599_("outsideBottom_r1", CubeListBuilder.m_171558_().m_171514_(24, 8).m_171488_(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-1.1074f, (float)-0.4245f, (float)0.6825f));
        PartDefinition top = body.m_171599_("top", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-0.5f, (float)-29.0f, (float)-0.75f));
        PartDefinition insideT = top.m_171599_("insideT", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.6207f, (float)1.4229f, (float)0.783f));
        PartDefinition insideTop_r1 = insideT.m_171599_("insideTop_r1", CubeListBuilder.m_171558_().m_171514_(26, 26).m_171488_(-3.0f, -3.0f, -3.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(-1.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-1.1074f, (float)-0.4245f, (float)0.6825f));
        PartDefinition outsideT = top.m_171599_("outsideT", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.4954f, (float)1.2721f, (float)0.9316f));
        PartDefinition outsideTop_r1 = outsideT.m_171599_("outsideTop_r1", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-1.1074f, (float)-0.4245f, (float)0.6825f));
        PartDefinition middle = body.m_171599_("middle", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-0.5f, (float)-17.0f, (float)-0.75f));
        PartDefinition insideM = middle.m_171599_("insideM", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.6207f, (float)1.4229f, (float)0.533f));
        PartDefinition insideMiddle_r1 = insideM.m_171599_("insideMiddle_r1", CubeListBuilder.m_171558_().m_171514_(0, 32).m_171488_(-3.0f, -3.0f, -3.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(1.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-1.1074f, (float)-0.4245f, (float)0.6825f));
        PartDefinition outsideM = middle.m_171599_("outsideM", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.4954f, (float)1.2721f, (float)0.9316f));
        PartDefinition outsideMiddle_r1 = outsideM.m_171599_("outsideMiddle_r1", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(3.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-1.1074f, (float)-0.4245f, (float)0.6825f));
        PartDefinition laser = partdefinition.m_171599_("laser", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition spikes = laser.m_171599_("spikes", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition spike4_r1 = spikes.m_171599_("spike4_r1", CubeListBuilder.m_171558_().m_171514_(30, 58).m_171488_(-5.0f, 1.0f, -2.0f, 4.0f, 0.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-1.5708f, (float)1.0472f, (float)-1.5708f));
        PartDefinition spike3_r1 = spikes.m_171599_("spike3_r1", CubeListBuilder.m_171558_().m_171514_(30, 58).m_171488_(-5.0f, 1.0f, -2.0f, 4.0f, 0.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)3.1416f, (float)0.0f, (float)-2.618f));
        PartDefinition spike2_r1 = spikes.m_171599_("spike2_r1", CubeListBuilder.m_171558_().m_171514_(30, 58).m_171488_(-5.0f, 1.0f, -2.0f, 4.0f, 0.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)1.5708f, (float)-1.0472f, (float)-1.5708f));
        PartDefinition spike1_r1 = spikes.m_171599_("spike1_r1", CubeListBuilder.m_171558_().m_171514_(30, 58).m_171488_(-5.0f, 1.0f, -2.0f, 4.0f, 0.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.5236f));
        PartDefinition charging = laser.m_171599_("charging", CubeListBuilder.m_171558_().m_171514_(-10, 50).m_171488_(-5.0f, 3.0f, -5.0f, 10.0f, 0.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-1.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(CosmicCrystalEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.body.f_104207_ = true;
        this.body.m_171331_().forEach(ModelPart::m_233569_);
        boolean isLaserState = CosmicCrystalEntity.isLaserState(entity.getCosmicCrystalState());
        if (isLaserState && entity.isLaserFiring()) {
            float pulse;
            this.spikes.f_104207_ = true;
            this.charging.f_104207_ = false;
            this.spikes.m_171331_().forEach(ModelPart::m_233569_);
            this.spikes.f_233553_ = pulse = Math.abs(Mth.m_14031_((float)((float)(entity.currentStateTimeTick % 360 * 6) * ((float)Math.PI / 180)))) + 1.5f;
            this.spikes.f_233555_ = pulse;
        } else if (isLaserState && entity.currentStateTimeTick > entity.getLaserStartDelay()) {
            float chargeTime;
            this.spikes.f_104207_ = false;
            this.charging.f_104207_ = true;
            this.charging.m_171331_().forEach(ModelPart::m_233569_);
            float durationToFiring = entity.getLaserFireStartTime() - entity.getLaserStartDelay();
            this.charging.f_233553_ = chargeTime = (1.0f - (float)(entity.currentStateTimeTick - entity.getLaserStartDelay()) / durationToFiring) * 3.0f;
            this.charging.f_233555_ = chargeTime;
        } else {
            this.charging.f_104207_ = false;
            this.spikes.f_104207_ = false;
        }
        this.m_233381_(entity.idleAnimationState, CosmicCrystalAnimation.MODEL_IDLE, ageInTicks);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.root.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public ModelPart m_142109_() {
        return this.root;
    }
}

