/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.entities.goals;

import com.telepathicgrunt.the_bumblezone.entities.controllers.HoneySlimeMoveController;
import com.telepathicgrunt.the_bumblezone.entities.mobs.HoneySlimeEntity;
import java.util.EnumSet;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class HoneySlimeTemptGoal
extends Goal {
    private static final TargetingConditions ENTITY_PREDICATE = TargetingConditions.m_148353_().m_26883_(10.0).m_148355_();
    protected final HoneySlimeEntity slime;
    private double targetX;
    private double targetY;
    private double targetZ;
    private double pitch;
    private double yaw;
    protected Player closestPlayer;
    private int delayTemptCounter;
    private final TagKey<Item> temptItemTag;

    public HoneySlimeTemptGoal(HoneySlimeEntity creatureIn, TagKey<Item> temptItemTag) {
        this.slime = creatureIn;
        this.temptItemTag = temptItemTag;
        this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (this.delayTemptCounter > 0) {
            --this.delayTemptCounter;
            return false;
        }
        this.closestPlayer = this.slime.m_9236_().m_45946_(ENTITY_PREDICATE, (LivingEntity)this.slime);
        if (this.closestPlayer == null) {
            return false;
        }
        return this.isTempting(this.closestPlayer.m_21205_()) || this.isTempting(this.closestPlayer.m_21206_());
    }

    protected boolean isTempting(ItemStack stack) {
        return stack.m_204117_(this.temptItemTag);
    }

    public boolean m_8045_() {
        if (this.isScaredByPlayerMovement()) {
            if (this.slime.m_20280_((Entity)this.closestPlayer) < 36.0) {
                if (this.closestPlayer.m_20275_(this.targetX, this.targetY, this.targetZ) > 0.010000000000000002) {
                    return false;
                }
                if (Math.abs((double)this.closestPlayer.m_146909_() - this.pitch) > 5.0 || Math.abs((double)this.closestPlayer.m_146908_() - this.yaw) > 5.0) {
                    return false;
                }
            } else {
                this.targetX = this.closestPlayer.m_20185_();
                this.targetY = this.closestPlayer.m_20186_();
                this.targetZ = this.closestPlayer.m_20189_();
            }
            this.pitch = this.closestPlayer.m_146909_();
            this.yaw = this.closestPlayer.m_146908_();
        }
        return this.m_8036_();
    }

    protected boolean isScaredByPlayerMovement() {
        return false;
    }

    public void m_8056_() {
        this.targetX = this.closestPlayer.m_20185_();
        this.targetY = this.closestPlayer.m_20186_();
        this.targetZ = this.closestPlayer.m_20189_();
    }

    public void m_8041_() {
        this.closestPlayer = null;
        this.slime.m_21573_().m_26573_();
        this.delayTemptCounter = 100;
    }

    public void m_8037_() {
        this.slime.m_21563_().m_24960_((Entity)this.closestPlayer, (float)(this.slime.m_8085_() + 20), (float)this.slime.m_8132_());
        if (this.slime.m_20280_((Entity)this.closestPlayer) < 6.25) {
            this.slime.m_21573_().m_26573_();
        } else {
            MoveControl moveControl = this.slime.m_21566_();
            if (moveControl instanceof HoneySlimeMoveController) {
                HoneySlimeMoveController honeySlimeMoveController = (HoneySlimeMoveController)moveControl;
                this.slime.m_21391_((Entity)this.closestPlayer, 10.0f, 10.0f);
                honeySlimeMoveController.setDirection(this.slime.m_146908_(), true);
                honeySlimeMoveController.setSpeed(1.0);
            }
        }
    }
}

