/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.modcompat;

import com.mojang.datafixers.util.Function6;
import com.telepathicgrunt.the_bumblezone.blocks.EmptyHoneycombBrood;
import com.telepathicgrunt.the_bumblezone.blocks.HoneycombBrood;
import com.telepathicgrunt.the_bumblezone.configs.BzGeneralConfigs;
import com.telepathicgrunt.the_bumblezone.configs.BzModCompatibilityConfigs;
import com.telepathicgrunt.the_bumblezone.mixin.blocks.DispenserBlockInvoker;
import com.telepathicgrunt.the_bumblezone.modcompat.BroodBlockModdedCompatDispenseBehavior;
import com.telepathicgrunt.the_bumblezone.modcompat.ModChecker;
import com.telepathicgrunt.the_bumblezone.modcompat.ModCompat;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import java.util.EnumSet;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.entity.DispenserBlockEntity;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class GoodallCompat
implements ModCompat {
    private static Optional<Item> BOTTLED_BEE;

    public GoodallCompat() {
        BOTTLED_BEE = BuiltInRegistries.f_257033_.m_6612_(new ResourceLocation("goodall", "bottled_bee"));
        if (BOTTLED_BEE.isPresent() && BzModCompatibilityConfigs.allowGoodallBottledBeesRevivingEmptyBroodBlock) {
            GoodallCompat.setupDispenserCompat(BOTTLED_BEE.get());
        }
        ModChecker.goodallPresent = true;
    }

    private static void setupDispenserCompat(Item containerItem) {
        BroodBlockModdedCompatDispenseBehavior newDispenseBehavior = new BroodBlockModdedCompatDispenseBehavior(((DispenserBlockInvoker)Blocks.f_50061_).bumblezone$invokeGetDispenseMethod(new ItemStack((ItemLike)containerItem)), (Function6<DispenseItemBehavior, BlockSource, ItemStack, ServerLevel, BlockPos, BlockState, ItemStack>)((Function6)(originalModdedDispenseBehavior, blockSource, itemStack, serverLevel, blockPos, blockState) -> {
            serverLevel.m_46597_(blockPos, (BlockState)((BlockState)BzBlocks.HONEYCOMB_BROOD.get().m_49966_().m_61124_((Property)HoneycombBrood.f_52588_, (Comparable)((Direction)blockState.m_61143_((Property)EmptyHoneycombBrood.f_52588_)))).m_61124_((Property)HoneycombBrood.STAGE, (Comparable)Integer.valueOf(GoodallCompat.isBabyBottledBeesItem(itemStack) ? 2 : 3)));
            itemStack.m_41774_(1);
            if (!BzGeneralConfigs.dispensersDropGlassBottles) {
                if (!itemStack.m_41619_()) {
                    ItemStack honeyBottle;
                    DispenserBlockEntity dispenser;
                    if (blockSource.m_8118_() instanceof DispenserBlockEntity && !HopperBlockEntity.m_59326_(null, (Container)(dispenser = (DispenserBlockEntity)blockSource.m_8118_()), (ItemStack)(honeyBottle = new ItemStack((ItemLike)Items.f_42590_)), null).m_41619_()) {
                        originalModdedDispenseBehavior.m_6115_(blockSource, honeyBottle);
                    }
                } else {
                    itemStack = new ItemStack((ItemLike)Items.f_42590_);
                }
            } else {
                BroodBlockModdedCompatDispenseBehavior.DEFAULT_DROP_ITEM_BEHAVIOR.m_6115_(blockSource, new ItemStack((ItemLike)Items.f_42590_));
            }
            return itemStack;
        }));
        DispenserBlock.m_52672_((ItemLike)containerItem, (DispenseItemBehavior)newDispenseBehavior);
    }

    @Override
    public EnumSet<ModCompat.Type> compatTypes() {
        return EnumSet.of(ModCompat.Type.EMPTY_BROOD);
    }

    public static boolean isBottledBeesItem(ItemStack itemStack) {
        return BOTTLED_BEE.isPresent() && itemStack.m_150930_(BOTTLED_BEE.get());
    }

    public static boolean isBabyBottledBeesItem(ItemStack itemStack) {
        if (!GoodallCompat.isBottledBeesItem(itemStack) || !itemStack.m_41782_()) {
            return false;
        }
        CompoundTag compoundTag = itemStack.m_41784_();
        return compoundTag.m_128441_("BlockEntityTag") && compoundTag.m_128469_("BlockEntityTag").m_128441_("Entity") && compoundTag.m_128469_("BlockEntityTag").m_128469_("Entity").m_128451_("Age") < 0;
    }

    @Override
    public InteractionResult onEmptyBroodInteract(ItemStack itemstack, Player playerEntity, InteractionHand playerHand) {
        if (!BzModCompatibilityConfigs.allowGoodallBottledBeesRevivingEmptyBroodBlock) {
            return InteractionResult.PASS;
        }
        if (GoodallCompat.isBottledBeesItem(itemstack) && !playerEntity.m_6047_()) {
            if (!playerEntity.m_7500_()) {
                playerEntity.m_21008_(playerHand, new ItemStack((ItemLike)Items.f_42590_));
            }
            return GoodallCompat.isBabyBottledBeesItem(itemstack) ? InteractionResult.CONSUME_PARTIAL : InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

