/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.packets;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.telepathicgrunt.the_bumblezone.client.screens.CrystallineFlowerScreen;
import com.telepathicgrunt.the_bumblezone.client.utils.GeneralUtilsClient;
import com.telepathicgrunt.the_bumblezone.menus.CrystallineFlowerMenu;
import com.telepathicgrunt.the_bumblezone.menus.EnchantmentSkeleton;
import com.telepathicgrunt.the_bumblezone.packets.MessageHandler;
import com.telepathicgrunt.the_bumblezone.packets.networking.base.Packet;
import com.telepathicgrunt.the_bumblezone.packets.networking.base.PacketContext;
import com.telepathicgrunt.the_bumblezone.packets.networking.base.PacketHandler;
import java.util.HashMap;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;

public record CrystallineFlowerEnchantmentPacket(int containerId, List<EnchantmentSkeleton> enchantmentSkeletons, ResourceLocation selectedResourceLocation) implements Packet<CrystallineFlowerEnchantmentPacket>
{
    public static final Gson GSON = new GsonBuilder().create();
    public static final ResourceLocation ID = new ResourceLocation("the_bumblezone", "crystalline_flower_enchantment");
    static final Handler HANDLER = new Handler();

    public static void sendToClient(ServerPlayer player, int containerId, List<EnchantmentSkeleton> enchantmentSkeletons, ResourceLocation selectedResourceLocation) {
        MessageHandler.DEFAULT_CHANNEL.sendToPlayer(new CrystallineFlowerEnchantmentPacket(containerId, enchantmentSkeletons, selectedResourceLocation), (Player)player);
    }

    @Override
    public ResourceLocation getID() {
        return ID;
    }

    @Override
    public PacketHandler<CrystallineFlowerEnchantmentPacket> getHandler() {
        return HANDLER;
    }

    private static final class Handler
    implements PacketHandler<CrystallineFlowerEnchantmentPacket> {
        private Handler() {
        }

        @Override
        public void encode(CrystallineFlowerEnchantmentPacket message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.containerId());
            buffer.m_236828_(message.enchantmentSkeletons(), (buf, enchantmentSkeleton) -> buf.m_130070_(GSON.toJson(enchantmentSkeleton)));
            buffer.m_130085_(message.selectedResourceLocation);
        }

        @Override
        public CrystallineFlowerEnchantmentPacket decode(FriendlyByteBuf buffer) {
            return new CrystallineFlowerEnchantmentPacket(buffer.readInt(), buffer.m_236845_(buf -> (EnchantmentSkeleton)GSON.fromJson(buf.m_130277_(), EnchantmentSkeleton.class)), buffer.m_130281_());
        }

        @Override
        public PacketContext handle(CrystallineFlowerEnchantmentPacket message) {
            return (player, level) -> {
                AbstractContainerMenu patt0$temp;
                if (GeneralUtilsClient.getClientPlayer() != null && GeneralUtilsClient.getClientPlayer().f_36096_.f_38840_ == message.containerId && (patt0$temp = GeneralUtilsClient.getClientPlayer().f_36096_) instanceof CrystallineFlowerMenu) {
                    CrystallineFlowerMenu crystallineFlowerMenu = (CrystallineFlowerMenu)patt0$temp;
                    HashMap<ResourceLocation, EnchantmentSkeleton> map = new HashMap<ResourceLocation, EnchantmentSkeleton>();
                    for (EnchantmentSkeleton enchantmentSkeleton : message.enchantmentSkeletons()) {
                        map.put(new ResourceLocation(enchantmentSkeleton.namespace, enchantmentSkeleton.path), enchantmentSkeleton);
                    }
                    crystallineFlowerMenu.selectedEnchantment = null;
                    CrystallineFlowerScreen.enchantmentsAvailable = map;
                    CrystallineFlowerScreen.SortAndAssignAvailableEnchants();
                    ResourceLocation resourceLocation = crystallineFlowerMenu.selectedEnchantment = message.selectedResourceLocation().equals((Object)new ResourceLocation("minecraft", "empty")) ? null : message.selectedResourceLocation();
                    if (!CrystallineFlowerScreen.enchantmentsAvailable.containsKey(crystallineFlowerMenu.selectedEnchantment)) {
                        crystallineFlowerMenu.selectedEnchantment = CrystallineFlowerScreen.enchantmentsAvailable.keySet().stream().findFirst().orElse(null);
                    }
                }
            };
        }
    }
}

