/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.packets.networking.forge;

import com.telepathicgrunt.the_bumblezone.client.utils.GeneralUtilsClient;
import com.telepathicgrunt.the_bumblezone.packets.networking.base.Packet;
import com.telepathicgrunt.the_bumblezone.packets.networking.base.PacketHandler;
import com.telepathicgrunt.the_bumblezone.platform.ModInfo;
import com.telepathicgrunt.the_bumblezone.utils.PlatformHooks;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class PacketChannelHelperImpl {
    public static final Map<ResourceLocation, Channel> CHANNELS = new HashMap<ResourceLocation, Channel>();

    public static void registerChannel(ResourceLocation name) {
        ModInfo info = PlatformHooks.getModInfo("the_bumblezone", true);
        String protocolVersion = info.version();
        Channel channel = new Channel(0, NetworkRegistry.newSimpleChannel((ResourceLocation)name, () -> protocolVersion, protocolVersion::equals, protocolVersion::equals));
        CHANNELS.put(name, channel);
    }

    public static <T extends Packet<T>> void registerS2CPacket(ResourceLocation name, ResourceLocation id, PacketHandler<T> handler, Class<T> packetClass) {
        Channel channel = CHANNELS.get(name);
        if (channel == null) {
            throw new IllegalStateException("Channel " + String.valueOf(name) + " not registered");
        }
        ++channel.packets;
        channel.channel.registerMessage(channel.packets, packetClass, handler::encode, handler::decode, (msg, ctx) -> {
            NetworkEvent.Context context = (NetworkEvent.Context)ctx.get();
            ServerPlayer sender = context.getSender();
            context.enqueueWork(() -> PacketChannelHelperImpl.lambda$registerS2CPacket$1((Player)sender, handler, msg));
            context.setPacketHandled(true);
        });
    }

    public static <T extends Packet<T>> void registerC2SPacket(ResourceLocation name, ResourceLocation id, PacketHandler<T> handler, Class<T> packetClass) {
        Channel channel = CHANNELS.get(name);
        if (channel == null) {
            throw new IllegalStateException("Channel " + String.valueOf(name) + " not registered");
        }
        ++channel.packets;
        channel.channel.registerMessage(channel.packets, packetClass, handler::encode, handler::decode, (msg, ctx) -> {
            NetworkEvent.Context context = (NetworkEvent.Context)ctx.get();
            ServerPlayer player = context.getSender();
            context.enqueueWork(() -> PacketChannelHelperImpl.lambda$registerC2SPacket$3((Player)player, handler, msg));
            context.setPacketHandled(true);
        });
    }

    public static <T extends Packet<T>> void sendToServer(ResourceLocation name, T packet) {
        Channel channel = CHANNELS.get(name);
        if (channel == null) {
            throw new IllegalStateException("Channel " + String.valueOf(name) + " not registered");
        }
        channel.channel.sendToServer(packet);
    }

    public static <T extends Packet<T>> void sendToPlayer(ResourceLocation name, T packet, Player player) {
        Channel channel = CHANNELS.get(name);
        if (channel == null) {
            throw new IllegalStateException("Channel " + String.valueOf(name) + " not registered");
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            channel.channel.send(PacketDistributor.PLAYER.with(() -> serverPlayer), packet);
        }
    }

    private static /* synthetic */ void lambda$registerC2SPacket$3(Player player, PacketHandler handler, Packet msg) {
        if (player != null) {
            handler.handle(msg).apply(player, player.m_9236_());
        }
    }

    private static /* synthetic */ void lambda$registerS2CPacket$1(Player sender, PacketHandler handler, Packet msg) {
        Player player = null;
        if (sender == null) {
            player = GeneralUtilsClient.getClientPlayer();
        }
        if (player != null) {
            handler.handle(msg).apply(player, player.m_9236_());
        }
    }

    private static final class Channel {
        private int packets;
        private final SimpleChannel channel;

        private Channel(int packets, SimpleChannel channel) {
            this.packets = packets;
            this.channel = channel;
        }
    }
}

