/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.worldgen.features;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.the_bumblezone.blocks.GlisteringHoneyCrystal;
import com.telepathicgrunt.the_bumblezone.mixin.world.WorldGenRegionAccessor;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.utils.UnsafeBulkSectionAccess;
import java.util.Iterator;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.Structure;

public class GiantHoneyCrystalFeature
extends Feature<NoneFeatureConfiguration> {
    public GiantHoneyCrystalFeature(Codec<NoneFeatureConfiguration> configFactory) {
        super(configFactory);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        BlockState state;
        BlockPos.MutableBlockPos blockpos$Mutable = new BlockPos.MutableBlockPos();
        RandomSource random = context.m_225041_();
        BlockPos origin = context.m_159777_();
        UnsafeBulkSectionAccess bulkSectionAccess = new UnsafeBulkSectionAccess((LevelAccessor)context.m_159774_());
        BlockState currentState = bulkSectionAccess.getBlockState(origin);
        if (currentState.m_60815_() || currentState.m_204336_(BzTags.AIR_LIKE)) {
            return false;
        }
        Registry structureRegistry = (Registry)context.m_159774_().m_9598_().m_6632_(Registries.f_256944_).get();
        if (context.m_159774_() instanceof WorldGenRegion) {
            Structure thronePillar;
            StructureManager structureManager = ((WorldGenRegionAccessor)context.m_159774_()).bumblezone$getStructureManager();
            if (origin.m_123342_() > 130 && origin.m_123342_() < 148 && (thronePillar = (Structure)structureRegistry.m_7745_(new ResourceLocation("the_bumblezone", "throne_pillar"))) != null && structureManager.m_220494_(origin, thronePillar).m_73603_()) {
                return false;
            }
            Optional optionalHolders = structureRegistry.m_203431_(BzTags.NO_GIANT_SPIKES);
            if (optionalHolders.isPresent()) {
                for (Iterator structureHolder : (HolderSet.Named)optionalHolders.get()) {
                    if (!structureManager.m_220494_(origin, (Structure)structureHolder.m_203334_()).m_73603_()) continue;
                    return false;
                }
            }
        }
        boolean validSpot = false;
        boolean superSlant = false;
        Direction wallDirection = null;
        for (Direction direction : Direction.Plane.VERTICAL) {
            blockpos$Mutable.m_122190_((Vec3i)origin).m_122175_(direction, 5);
            state = bulkSectionAccess.getBlockState((BlockPos)blockpos$Mutable);
            if (!state.m_60815_()) continue;
            validSpot = true;
            break;
        }
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            blockpos$Mutable.m_122190_((Vec3i)origin).m_122175_(direction, 1);
            state = bulkSectionAccess.getBlockState((BlockPos)blockpos$Mutable);
            if (!state.m_60815_()) continue;
            superSlant = true;
            wallDirection = direction;
            validSpot = true;
        }
        if (!validSpot) {
            return false;
        }
        blockpos$Mutable.m_122190_((Vec3i)origin).m_122175_(Direction.UP, 5);
        int directionSign = bulkSectionAccess.getBlockState((BlockPos)blockpos$Mutable).m_60815_() ? -1 : 1;
        int currentY = origin.m_123342_() - directionSign * 5;
        int thickness = random.m_188503_(3) + 4;
        int height = random.m_188503_(5) + 12;
        int slantAmountX = random.m_188503_(10) * (random.m_188499_() ? -1 : 1);
        int slantAmountZ = random.m_188503_(10) * (random.m_188499_() ? -1 : 1);
        if (random.m_188503_(4) == 0) {
            slantAmountX = 0;
        }
        if (random.m_188503_(4) == 0) {
            slantAmountZ = 0;
        }
        if (superSlant) {
            slantAmountX = -wallDirection.m_122429_() * (random.m_188503_(2) + 1);
            slantAmountZ = -wallDirection.m_122431_() * (random.m_188503_(2) + 1);
        }
        for (int layer = 0; layer < height; ++layer) {
            int currentZSlant;
            float currentThickness = thickness;
            int currentXSlant = slantAmountX == 0 ? 0 : layer / slantAmountX;
            int n = currentZSlant = slantAmountZ == 0 ? 0 : layer / slantAmountZ;
            if (layer == 0) {
                currentThickness -= 2.0f;
            } else if (layer == 1) {
                currentThickness -= 1.0f;
            } else if (layer == height - 1) {
                currentThickness = 0.5f;
                currentXSlant = slantAmountX == 0 ? 0 : (layer - 1) / slantAmountX;
                currentZSlant = slantAmountZ == 0 ? 0 : (layer - 1) / slantAmountZ;
            } else {
                currentThickness *= Math.max((float)(height - layer) / (float)height, 0.2f);
                currentThickness = Math.max(currentThickness, 1.1f);
            }
            int x = (int)(-currentThickness);
            while ((float)x <= currentThickness) {
                int z = (int)(-currentThickness);
                while ((float)z <= currentThickness) {
                    if ((float)(x * x + z * z) < currentThickness * currentThickness) {
                        blockpos$Mutable.m_122178_(origin.m_123341_() + x + currentXSlant, currentY, origin.m_123343_() + z + currentZSlant);
                        BlockState state2 = bulkSectionAccess.getBlockState((BlockPos)blockpos$Mutable);
                        if (!state2.m_60815_() && !state2.m_155947_()) {
                            BlockState newState = BzBlocks.GLISTERING_HONEY_CRYSTAL.get().m_49966_();
                            if (random.m_188501_() < 0.5f) {
                                newState = (BlockState)newState.m_61124_((Property)GlisteringHoneyCrystal.f_52588_, (Comparable)Direction.m_235672_((RandomSource)random));
                            }
                            bulkSectionAccess.setBlockState((BlockPos)blockpos$Mutable, newState, false);
                        }
                    }
                    ++z;
                }
                ++x;
            }
            currentY += directionSign;
        }
        return false;
    }
}

