/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.worldgen.processors;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.the_bumblezone.modinit.BzProcessors;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class TagReplaceProcessor
extends StructureProcessor {
    public static final Codec<TagReplaceProcessor> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.f_256975_.m_194605_().fieldOf("input_block").forGetter(config -> config.inputBlock), (App)TagKey.m_203877_((ResourceKey)Registries.f_256747_).fieldOf("output_block_tag").forGetter(config -> config.outputBlockTag), (App)TagKey.m_203877_((ResourceKey)Registries.f_256747_).optionalFieldOf("blacklisted_output_block_tag").forGetter(config -> config.blacklistedOutputBlockTag), (App)Codec.BOOL.fieldOf("double_tall_flower").orElse((Object)false).forGetter(config -> config.doubleTallFlower), (App)Codec.BOOL.fieldOf("same_throughout_piece").orElse((Object)false).forGetter(config -> config.sameThroughoutPiece), (App)Codec.INT.fieldOf("seed_random_addition").orElse((Object)0).forGetter(config -> config.seedRandomAddition)).apply((Applicative)instance, instance.stable(TagReplaceProcessor::new)));
    private final Block inputBlock;
    private final TagKey<Block> outputBlockTag;
    private final Optional<TagKey<Block>> blacklistedOutputBlockTag;
    private final boolean doubleTallFlower;
    private final boolean sameThroughoutPiece;
    private final int seedRandomAddition;

    public TagReplaceProcessor(Block inputBlock, TagKey<Block> outputBlockTag, Optional<TagKey<Block>> blacklistedOutputBlockTag, boolean doubleTallFlower, boolean sameThroughoutPiece, int seedRandomAddition) {
        this.inputBlock = inputBlock;
        this.outputBlockTag = outputBlockTag;
        this.blacklistedOutputBlockTag = blacklistedOutputBlockTag;
        this.doubleTallFlower = doubleTallFlower;
        this.sameThroughoutPiece = sameThroughoutPiece;
        this.seedRandomAddition = seedRandomAddition;
    }

    public StructureTemplate.StructureBlockInfo m_7382_(LevelReader levelReader, BlockPos pos, BlockPos pos2, StructureTemplate.StructureBlockInfo infoIn1, StructureTemplate.StructureBlockInfo structureBlockInfoWorld, StructurePlaceSettings settings) {
        StructureTemplate.StructureBlockInfo returnInfo = structureBlockInfoWorld;
        if (structureBlockInfoWorld.f_74676_().m_60734_() == this.inputBlock && (settings.m_74409_() == null || settings.m_74409_().m_71051_((Vec3i)structureBlockInfoWorld.f_74675_()))) {
            if (GeneralUtils.isOutsideStructureAllowedBounds(settings, structureBlockInfoWorld.f_74675_())) {
                return structureBlockInfoWorld;
            }
            Optional optionalBlocks = BuiltInRegistries.f_256975_.m_203431_(this.outputBlockTag);
            if (optionalBlocks.isPresent()) {
                RandomSource randomSource = this.sameThroughoutPiece ? settings.m_230326_(pos.m_6630_(this.seedRandomAddition)) : settings.m_230326_(structureBlockInfoWorld.f_74675_());
                randomSource.m_188499_();
                List blockList = optionalBlocks.map(holderSet -> holderSet.m_203614_().filter(block -> this.blacklistedOutputBlockTag.map(blockTagKey -> !block.m_203656_(blockTagKey)).orElse(true)).map(Holder::m_203334_).toList()).orElse(new ArrayList());
                if (this.doubleTallFlower) {
                    blockList = blockList.stream().filter(block -> block instanceof DoublePlantBlock).collect(Collectors.toList());
                }
                if (blockList.size() > 0) {
                    BlockState newBlockState = ((Block)blockList.get(randomSource.m_188503_(blockList.size()))).m_49966_();
                    for (Property property : structureBlockInfoWorld.f_74676_().m_61147_()) {
                        if (!newBlockState.m_61138_(property)) continue;
                        newBlockState = GeneralUtils.getStateWithProperty(newBlockState, structureBlockInfoWorld.f_74676_(), property);
                    }
                    if (newBlockState.m_60734_() instanceof MultifaceBlock) {
                        for (Direction direction : Direction.values()) {
                            BooleanProperty faceProperty = MultifaceBlock.m_153933_((Direction)direction);
                            if (!newBlockState.m_61138_((Property)faceProperty)) continue;
                            newBlockState = (BlockState)newBlockState.m_61124_((Property)faceProperty, (Comparable)Boolean.valueOf(direction == Direction.DOWN));
                        }
                    }
                    if (newBlockState.m_61138_((Property)BlockStateProperties.f_271526_)) {
                        newBlockState = (BlockState)newBlockState.m_61124_((Property)BlockStateProperties.f_271526_, (Comparable)Integer.valueOf(4));
                    }
                    if (newBlockState.m_61138_((Property)BlockStateProperties.f_61362_)) {
                        newBlockState = (BlockState)newBlockState.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(!structureBlockInfoWorld.f_74676_().m_60819_().m_76178_()));
                    }
                    if (newBlockState.m_60734_() instanceof LeavesBlock) {
                        Property property;
                        Optional<Property> optionalProperty = newBlockState.m_61147_().stream().filter(p -> p.m_61708_().equalsIgnoreCase("age")).findAny();
                        if (optionalProperty.isPresent() && (property = optionalProperty.get()).m_61709_() == Integer.class) {
                            newBlockState = (BlockState)newBlockState.m_61124_(property, (Comparable)((Integer)property.m_6908_().stream().toArray()[settings.m_230326_(structureBlockInfoWorld.f_74675_()).m_188503_(property.m_6908_().size())]));
                        }
                        if (newBlockState.m_61138_((Property)BlockStateProperties.f_61414_)) {
                            newBlockState = (BlockState)newBlockState.m_61124_((Property)BlockStateProperties.f_61414_, (Comparable)Integer.valueOf(1));
                        }
                    }
                    ChunkAccess chunk = levelReader.m_46865_(structureBlockInfoWorld.f_74675_());
                    BlockPos mainPos = structureBlockInfoWorld.f_74675_();
                    BlockPos groundPos = mainPos.m_7495_();
                    BlockState checkingState = newBlockState;
                    BlockState oldTopBlock = null;
                    BlockPos oldTopPos = null;
                    if (this.doubleTallFlower) {
                        if (newBlockState.m_61143_((Property)DoublePlantBlock.f_52858_) == DoubleBlockHalf.UPPER) {
                            oldTopPos = mainPos;
                            mainPos = mainPos.m_7495_();
                            groundPos = mainPos.m_7495_();
                            checkingState = (BlockState)checkingState.m_61124_((Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.LOWER);
                        } else {
                            oldTopPos = structureBlockInfoWorld.f_74675_().m_7494_();
                        }
                        oldTopBlock = chunk.m_8055_(oldTopPos);
                        chunk.m_6978_(oldTopPos, Blocks.f_50016_.m_49966_(), false);
                    }
                    BlockState oldBlockstate = chunk.m_8055_(mainPos);
                    BlockState belowGroundBlockstate = chunk.m_8055_(groundPos);
                    chunk.m_6978_(mainPos, Blocks.f_50016_.m_49966_(), false);
                    chunk.m_6978_(groundPos, Blocks.f_50440_.m_49966_(), false);
                    if (checkingState.m_60710_(levelReader, mainPos)) {
                        returnInfo = new StructureTemplate.StructureBlockInfo(structureBlockInfoWorld.f_74675_(), newBlockState, structureBlockInfoWorld.f_74677_());
                    }
                    if (oldTopBlock != null) {
                        chunk.m_6978_(oldTopPos, oldTopBlock, false);
                    }
                    chunk.m_6978_(mainPos, oldBlockstate, false);
                    chunk.m_6978_(groundPos, belowGroundBlockstate, false);
                }
            }
        }
        return returnInfo;
    }

    protected StructureProcessorType<?> m_6953_() {
        return BzProcessors.TAG_REPLACE_PROCESSOR.get();
    }
}

