/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.client.blockentityrenderer;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.telepathicgrunt.the_bumblezone.blocks.blockentities.EssenceBlockEntity;
import com.telepathicgrunt.the_bumblezone.configs.BzClientConfigs;
import java.util.Random;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.level.BlockGetter;
import org.joml.Matrix4f;

public class EssenceBlockEntityRenderer
implements BlockEntityRenderer<EssenceBlockEntity> {
    private static final long RANDOM_SEED = 31100L;
    private static final Random RANDOM = new Random(31100L);
    public static final ResourceLocation BASE_TEXTURE = new ResourceLocation("the_bumblezone", "textures/block/essence/base_background.png");
    public static final ResourceLocation BEE_TEXTURE = new ResourceLocation("the_bumblezone", "textures/block/essence/bee_icon_background.png");
    public static final VertexFormat POSITION_COLOR_NORMAL = new VertexFormat(ImmutableMap.builder().put((Object)"Position", (Object)DefaultVertexFormat.f_85804_).put((Object)"Color", (Object)DefaultVertexFormat.f_85805_).put((Object)"Normal", (Object)DefaultVertexFormat.f_85809_).build());
    public static ShaderInstance SAFE_SHADER_INSTANCE = null;
    public final RenderType.CompositeRenderType ESSENCE_RENDER_TYPE = RenderType.m_173215_((String)"bumblezone_essence_block", (VertexFormat)POSITION_COLOR_NORMAL, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(new RenderStateShard.ShaderStateShard(() -> SAFE_SHADER_INSTANCE)).m_173290_((RenderStateShard.EmptyTextureStateShard)RenderStateShard.MultiTextureStateShard.m_173127_().m_173132_(BASE_TEXTURE, false, false).m_173132_(BEE_TEXTURE, false, false).m_173131_()).m_110691_(false));

    public EssenceBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(EssenceBlockEntity blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource multiBufferSource, int brightness, int overlayType) {
        if (BzClientConfigs.disableEssenceBlockShaders) {
            return;
        }
        RANDOM.setSeed(31100L);
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        this.renderSides(blockEntity, matrix4f, multiBufferSource.m_6299_(this.getType()));
    }

    private void renderSides(EssenceBlockEntity blockEntity, Matrix4f matrix4f, VertexConsumer vertexConsumer) {
        int colorInt = blockEntity.m_58900_().m_284242_((BlockGetter)blockEntity.m_58904_(), (BlockPos)blockEntity.m_58899_()).f_283871_;
        float red = (float)FastColor.ARGB32.m_13665_((int)colorInt) / 255.0f;
        float green = (float)FastColor.ARGB32.m_13667_((int)colorInt) / 255.0f;
        float blue = (float)FastColor.ARGB32.m_13669_((int)colorInt) / 255.0f;
        this.renderSide(blockEntity, matrix4f, vertexConsumer, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, red, green, blue, Direction.SOUTH);
        this.renderSide(blockEntity, matrix4f, vertexConsumer, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, red, green, blue, Direction.NORTH);
        this.renderSide(blockEntity, matrix4f, vertexConsumer, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, red, green, blue, Direction.EAST);
        this.renderSide(blockEntity, matrix4f, vertexConsumer, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, red, green, blue, Direction.WEST);
        this.renderSide(blockEntity, matrix4f, vertexConsumer, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, red, green, blue, Direction.DOWN);
        this.renderSide(blockEntity, matrix4f, vertexConsumer, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, red, green, blue, Direction.UP);
    }

    private void renderSide(EssenceBlockEntity blockEntity, Matrix4f model, VertexConsumer vertexConsumer, float x1, float x2, float y1, float y2, float z1, float z2, float z3, float z4, float red, float green, float blue, Direction direction) {
        if (blockEntity.shouldDrawSide(direction)) {
            Vec3i normal = direction.m_122436_();
            EssenceBlockEntityRenderer.addPortalVertex(vertexConsumer, model, x1, y1, z1, red, green, blue, normal);
            EssenceBlockEntityRenderer.addPortalVertex(vertexConsumer, model, x2, y1, z2, red, green, blue, normal);
            EssenceBlockEntityRenderer.addPortalVertex(vertexConsumer, model, x2, y2, z3, red, green, blue, normal);
            EssenceBlockEntityRenderer.addPortalVertex(vertexConsumer, model, x1, y2, z4, red, green, blue, normal);
        }
    }

    private static void addPortalVertex(VertexConsumer vertexConsumer, Matrix4f mat, float x, float y, float z, float red, float green, float blue, Vec3i normal) {
        vertexConsumer.m_252986_(mat, x, y, z).m_85950_(red, green, blue, 1.0f).m_5601_((float)normal.m_123341_(), (float)normal.m_123342_(), (float)normal.m_123343_()).m_5752_();
    }

    protected RenderType getType() {
        return this.ESSENCE_RENDER_TYPE;
    }
}

